/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.fs;

import java.nio.file.Path;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.blobstore.fs.FsBlobStore;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.env.Environment;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class FsRepository
extends BlobStoreRepository {
    private static final Logger logger = LogManager.getLogger(FsRepository.class);
    public static final String TYPE = "fs";
    public static final Setting<String> LOCATION_SETTING = new Setting("location", "", Function.identity(), Setting.Property.NodeScope);
    public static final Setting<String> REPOSITORIES_LOCATION_SETTING = new Setting<String>("repositories.fs.location", LOCATION_SETTING, Function.identity(), Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> CHUNK_SIZE_SETTING = Setting.byteSizeSetting("chunk_size", ByteSizeValue.ofBytes(Long.MAX_VALUE), ByteSizeValue.ofBytes(5L), ByteSizeValue.ofBytes(Long.MAX_VALUE), Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> REPOSITORIES_CHUNK_SIZE_SETTING = Setting.byteSizeSetting("repositories.fs.chunk_size", ByteSizeValue.ofBytes(Long.MAX_VALUE), ByteSizeValue.ofBytes(5L), ByteSizeValue.ofBytes(Long.MAX_VALUE), Setting.Property.NodeScope);
    private final Environment environment;
    private final ByteSizeValue chunkSize;

    public FsRepository(RepositoryMetadata metadata, Environment environment, NamedXContentRegistry namedXContentRegistry, ClusterService clusterService, BigArrays bigArrays, RecoverySettings recoverySettings) {
        super(metadata, namedXContentRegistry, clusterService, bigArrays, recoverySettings, BlobPath.EMPTY);
        this.environment = environment;
        String location = REPOSITORIES_LOCATION_SETTING.get(metadata.settings());
        if (location.isEmpty()) {
            logger.warn("the repository location is missing, it should point to a shared file system location that is available on all master and data nodes");
            throw new RepositoryException(metadata.name(), "missing location", new Object[0]);
        }
        Path locationFile = environment.resolveRepoFile(location);
        if (locationFile == null) {
            if (environment.repoFiles().length > 0) {
                logger.warn("The specified location [{}] doesn't start with any repository paths specified by the path.repo setting: [{}] ", (Object)location, (Object)environment.repoFiles());
                throw new RepositoryException(metadata.name(), "location [" + location + "] doesn't match any of the locations specified by path.repo", new Object[0]);
            }
            logger.warn("The specified location [{}] should start with a repository path specified by the path.repo setting, but the path.repo setting was not set on this node", (Object)location);
            throw new RepositoryException(metadata.name(), "location [" + location + "] doesn't match any of the locations specified by path.repo because this setting is empty", new Object[0]);
        }
        this.chunkSize = CHUNK_SIZE_SETTING.exists(metadata.settings()) ? CHUNK_SIZE_SETTING.get(metadata.settings()) : REPOSITORIES_CHUNK_SIZE_SETTING.get(environment.settings());
    }

    @Override
    protected BlobStore createBlobStore() throws Exception {
        String location = REPOSITORIES_LOCATION_SETTING.get(this.getMetadata().settings());
        Path locationFile = this.environment.resolveRepoFile(location);
        return new FsBlobStore(this.bufferSize, locationFile, this.isReadOnly());
    }

    @Override
    protected ByteSizeValue chunkSize() {
        return this.chunkSize;
    }

    @Override
    public boolean hasAtomicOverwrites() {
        return false;
    }
}

