/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.inference;

import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.xcontent.ToXContentFragment;

public interface InferenceResults
extends NamedWriteable,
ToXContentFragment {
    public static final String MODEL_ID_RESULTS_FIELD = "model_id";

    public static void writeResult(InferenceResults results, IngestDocument ingestDocument, String resultField, String modelId) {
        Objects.requireNonNull(results, "results");
        Objects.requireNonNull(ingestDocument, "ingestDocument");
        Objects.requireNonNull(resultField, "resultField");
        Map<String, Object> resultMap = results.asMap();
        resultMap.put(MODEL_ID_RESULTS_FIELD, modelId);
        InferenceResults.setOrAppendValue(resultField, resultMap, ingestDocument);
    }

    public static void writeResultToField(InferenceResults results, IngestDocument ingestDocument, @Nullable String basePath, String outputField, String modelId, boolean includeModelId) {
        Objects.requireNonNull(results, "results");
        Objects.requireNonNull(ingestDocument, "ingestDocument");
        Objects.requireNonNull(outputField, "outputField");
        Map<String, Object> resultMap = results.asMap(outputField);
        if (includeModelId) {
            resultMap.put(MODEL_ID_RESULTS_FIELD, modelId);
        }
        if (basePath == null) {
            for (Map.Entry<String, Object> entry : resultMap.entrySet()) {
                InferenceResults.setOrAppendValue(entry.getKey(), entry.getValue(), ingestDocument);
            }
        } else {
            for (Map.Entry<String, Object> entry : resultMap.entrySet()) {
                InferenceResults.setOrAppendValue(basePath + "." + entry.getKey(), entry.getValue(), ingestDocument);
            }
        }
    }

    private static void setOrAppendValue(String path, Object value, IngestDocument ingestDocument) {
        if (ingestDocument.hasField(path)) {
            ingestDocument.appendFieldValue(path, value);
        } else {
            ingestDocument.setFieldValue(path, value);
        }
    }

    public String getResultsField();

    public Map<String, Object> asMap();

    public Map<String, Object> asMap(String var1);

    public Object predictedValue();
}

