/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.snapshots.blobstore;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.elasticsearch.core.IOUtils;

public abstract class SlicedInputStream
extends InputStream {
    private int nextSlice = 0;
    private InputStream currentStream;
    private long currentSliceOffset = 0L;
    private final int numSlices;
    private boolean closed = false;
    private boolean initialized = false;
    private int markedSlice = -1;
    private long markedSliceOffset = -1L;

    protected SlicedInputStream(int numSlices) {
        this.numSlices = numSlices;
    }

    private InputStream nextStream() throws IOException {
        assert (!this.initialized || this.currentStream != null);
        assert (!this.closed) : "attempted to get next stream when closed";
        this.initialized = true;
        IOUtils.close((Closeable)this.currentStream);
        this.currentStream = this.nextSlice < this.numSlices ? this.openSlice(this.nextSlice++) : null;
        this.currentSliceOffset = 0L;
        return this.currentStream;
    }

    protected abstract InputStream openSlice(int var1) throws IOException;

    private InputStream currentStream() throws IOException {
        if (this.currentStream == null) {
            return this.initialized ? null : this.nextStream();
        }
        return this.currentStream;
    }

    @Override
    public final int read() throws IOException {
        InputStream stream = this.currentStream();
        if (stream == null) {
            return -1;
        }
        int read = stream.read();
        if (read == -1) {
            this.nextStream();
            return this.read();
        }
        ++this.currentSliceOffset;
        return read;
    }

    @Override
    public final int read(byte[] buffer, int offset, int length) throws IOException {
        InputStream stream = this.currentStream();
        if (stream == null) {
            return -1;
        }
        int read = stream.read(buffer, offset, length);
        if (read <= 0) {
            this.nextStream();
            return this.read(buffer, offset, length);
        }
        this.currentSliceOffset += (long)read;
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        InputStream stream;
        long remaining;
        long skipped;
        for (remaining = n; remaining > 0L && (stream = this.currentStream()) != null; remaining -= skipped) {
            skipped = stream.skip(remaining);
            this.currentSliceOffset += skipped;
            if (skipped >= remaining) continue;
            if (stream.read() < 0) {
                this.nextStream();
                continue;
            }
            ++this.currentSliceOffset;
            ++skipped;
        }
        return n - remaining;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.initialized = true;
        this.currentSliceOffset = 0L;
        InputStream stream = this.currentStream;
        this.currentStream = null;
        IOUtils.close((Closeable)stream);
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public final int available() throws IOException {
        InputStream stream = this.currentStream();
        return stream == null ? 0 : stream.available();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readLimit) {
        if (this.markSupported() && !this.isClosed() && this.numSlices > 0) {
            if (this.initialized) {
                this.markedSlice = this.currentStream == null ? this.numSlices : this.nextSlice - 1;
                this.markedSliceOffset = this.currentSliceOffset;
            } else {
                this.markedSlice = 0;
                this.markedSliceOffset = 0L;
            }
        }
    }

    @Override
    public void reset() throws IOException {
        if (this.markSupported()) {
            if (this.isClosed()) {
                throw new IOException("reset called on a closed stream");
            }
            if (this.numSlices > 0) {
                if (this.markedSlice < 0 || this.markedSliceOffset < 0L) {
                    throw new IOException("Mark has not been set");
                }
                this.nextSlice = this.markedSlice;
                this.initialized = true;
                IOUtils.close((Closeable)this.currentStream);
                if (this.nextSlice < this.numSlices) {
                    this.currentStream = this.openSlice(this.nextSlice++);
                    this.currentStream.skipNBytes(this.markedSliceOffset);
                } else {
                    this.currentStream = null;
                }
                this.currentSliceOffset = this.markedSliceOffset;
            }
        } else {
            throw new IOException("mark/reset not supported");
        }
    }
}

