/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.vectors;

import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.SortField;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.index.mapper.vectors.MultiVectorDVLeafFieldData;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.sort.BucketedSort;
import org.elasticsearch.search.sort.SortOrder;

public class MultiVectorIndexFieldData
implements IndexFieldData<MultiVectorDVLeafFieldData> {
    protected final String fieldName;
    protected final ValuesSourceType valuesSourceType;
    private final int dims;
    private final IndexVersion indexVersion;
    private final DenseVectorFieldMapper.ElementType elementType;

    public MultiVectorIndexFieldData(String fieldName, int dims, ValuesSourceType valuesSourceType, IndexVersion indexVersion, DenseVectorFieldMapper.ElementType elementType) {
        this.fieldName = fieldName;
        this.valuesSourceType = valuesSourceType;
        this.indexVersion = indexVersion;
        this.elementType = elementType;
        this.dims = dims;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public ValuesSourceType getValuesSourceType() {
        return this.valuesSourceType;
    }

    @Override
    public MultiVectorDVLeafFieldData load(LeafReaderContext context) {
        return new MultiVectorDVLeafFieldData(context.reader(), this.fieldName, this.elementType, this.dims);
    }

    @Override
    public MultiVectorDVLeafFieldData loadDirect(LeafReaderContext context) throws Exception {
        return this.load(context);
    }

    @Override
    public SortField sortField(Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
        throw new IllegalArgumentException("Field [" + this.fieldName + "] of type [multi_dense_vector] doesn't support sort");
    }

    @Override
    public BucketedSort newBucketedSort(BigArrays bigArrays, Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        throw new IllegalArgumentException("only supported on numeric fields");
    }

    public static class Builder
    implements IndexFieldData.Builder {
        private final String name;
        private final ValuesSourceType valuesSourceType;
        private final IndexVersion indexVersion;
        private final int dims;
        private final DenseVectorFieldMapper.ElementType elementType;

        public Builder(String name, ValuesSourceType valuesSourceType, IndexVersion indexVersion, int dims, DenseVectorFieldMapper.ElementType elementType) {
            this.name = name;
            this.valuesSourceType = valuesSourceType;
            this.indexVersion = indexVersion;
            this.dims = dims;
            this.elementType = elementType;
        }

        @Override
        public IndexFieldData<?> build(IndexFieldDataCache cache, CircuitBreakerService breakerService) {
            return new MultiVectorIndexFieldData(this.name, this.dims, this.valuesSourceType, this.indexVersion, this.elementType);
        }
    }
}

