/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.vectors;

import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.elasticsearch.index.fielddata.LeafFieldData;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.script.field.DocValuesScriptFieldFactory;
import org.elasticsearch.script.field.vectors.BitMultiDenseVectorDocValuesField;
import org.elasticsearch.script.field.vectors.ByteMultiDenseVectorDocValuesField;
import org.elasticsearch.script.field.vectors.FloatMultiDenseVectorDocValuesField;

final class MultiVectorDVLeafFieldData
implements LeafFieldData {
    private final LeafReader reader;
    private final String field;
    private final DenseVectorFieldMapper.ElementType elementType;
    private final int dims;

    MultiVectorDVLeafFieldData(LeafReader reader, String field, DenseVectorFieldMapper.ElementType elementType, int dims) {
        this.reader = reader;
        this.field = field;
        this.elementType = elementType;
        this.dims = dims;
    }

    @Override
    public DocValuesScriptFieldFactory getScriptFieldFactory(String name) {
        try {
            BinaryDocValues values = DocValues.getBinary((LeafReader)this.reader, (String)this.field);
            BinaryDocValues magnitudeValues = DocValues.getBinary((LeafReader)this.reader, (String)(this.field + "._magnitude"));
            return switch (this.elementType) {
                default -> throw new IncompatibleClassChangeError();
                case DenseVectorFieldMapper.ElementType.BYTE -> new ByteMultiDenseVectorDocValuesField(values, magnitudeValues, name, this.elementType, this.dims);
                case DenseVectorFieldMapper.ElementType.FLOAT -> new FloatMultiDenseVectorDocValuesField(values, magnitudeValues, name, this.elementType, this.dims);
                case DenseVectorFieldMapper.ElementType.BIT -> new BitMultiDenseVectorDocValuesField(values, magnitudeValues, name, this.elementType, this.dims);
            };
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load doc values for multi-vector field!", e);
        }
    }

    @Override
    public SortedBinaryDocValues getBytesValues() {
        throw new UnsupportedOperationException("String representation of doc values for multi-vector fields is not supported");
    }

    public long ramBytesUsed() {
        return 0L;
    }
}

