/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.features;

import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.features.FeatureData;
import org.elasticsearch.features.FeatureSpecification;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;

public class FeatureService {
    public static final NodeFeature FEATURES_SUPPORTED = new NodeFeature("features_supported");
    public static final NodeFeature TEST_FEATURES_ENABLED = new NodeFeature("test_features_enabled");
    private static final Logger logger = LogManager.getLogger(FeatureService.class);
    public static final Version CLUSTER_FEATURES_ADDED_VERSION = Version.V_8_12_0;
    private final NavigableMap<Version, Set<String>> historicalFeatures;
    private final Map<String, NodeFeature> nodeFeatures;

    public FeatureService(List<? extends FeatureSpecification> specs) {
        FeatureData featureData = FeatureData.createFromSpecifications(specs);
        this.nodeFeatures = featureData.getNodeFeatures();
        this.historicalFeatures = featureData.getHistoricalFeatures();
        logger.info("Registered local node features {}", new Object[]{this.nodeFeatures.keySet().stream().sorted().toList()});
    }

    public Map<String, NodeFeature> getNodeFeatures() {
        return this.nodeFeatures;
    }

    @SuppressForbidden(reason="We need basic feature information from cluster state")
    public boolean clusterHasFeature(ClusterState state, NodeFeature feature) {
        if (state.clusterFeatures().clusterHasFeature(feature)) {
            return true;
        }
        Map.Entry<Version, Set<String>> features = this.historicalFeatures.floorEntry(state.getNodes().getMinNodeVersion());
        return features != null && features.getValue().contains(feature.id());
    }
}

