/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class SingleNodeShutdownMetadata
implements SimpleDiffable<SingleNodeShutdownMetadata>,
ToXContentObject {
    public static final TransportVersion REPLACE_SHUTDOWN_TYPE_ADDED_VERSION = TransportVersions.V_7_16_0;
    public static final TransportVersion SIGTERM_ADDED_VERSION = TransportVersions.V_8_9_X;
    public static final TransportVersion GRACE_PERIOD_ADDED_VERSION = TransportVersions.V_8_9_X;
    public static final ParseField NODE_ID_FIELD = new ParseField("node_id", new String[0]);
    public static final ParseField TYPE_FIELD = new ParseField("type", new String[0]);
    public static final ParseField REASON_FIELD = new ParseField("reason", new String[0]);
    public static final String STARTED_AT_READABLE_FIELD = "shutdown_started";
    public static final ParseField STARTED_AT_MILLIS_FIELD = new ParseField("shutdown_startedmillis", new String[0]);
    public static final ParseField ALLOCATION_DELAY_FIELD = new ParseField("allocation_delay", new String[0]);
    public static final ParseField NODE_SEEN_FIELD = new ParseField("node_seen", new String[0]);
    public static final ParseField TARGET_NODE_NAME_FIELD = new ParseField("target_node_name", new String[0]);
    public static final ParseField GRACE_PERIOD_FIELD = new ParseField("grace_period", new String[0]);
    public static final ConstructingObjectParser<SingleNodeShutdownMetadata, Void> PARSER = new ConstructingObjectParser("node_shutdown_info", a -> new SingleNodeShutdownMetadata((String)a[0], Type.valueOf((String)a[1]), (String)a[2], (Long)a[3], (Boolean)a[4], (TimeValue)a[5], (String)a[6], (TimeValue)a[7]));
    public static final TimeValue DEFAULT_RESTART_SHARD_ALLOCATION_DELAY;
    private final String nodeId;
    private final Type type;
    private final String reason;
    private final long startedAtMillis;
    private final boolean nodeSeen;
    @Nullable
    private final TimeValue allocationDelay;
    @Nullable
    private final String targetNodeName;
    @Nullable
    private final TimeValue gracePeriod;

    public static SingleNodeShutdownMetadata parse(XContentParser parser) {
        return (SingleNodeShutdownMetadata)PARSER.apply(parser, null);
    }

    private SingleNodeShutdownMetadata(String nodeId, Type type, String reason, long startedAtMillis, boolean nodeSeen, @Nullable TimeValue allocationDelay, @Nullable String targetNodeName, @Nullable TimeValue gracePeriod) {
        this.nodeId = Objects.requireNonNull(nodeId, "node ID must not be null");
        this.type = Objects.requireNonNull(type, "shutdown type must not be null");
        this.reason = Objects.requireNonNull(reason, "shutdown reason must not be null");
        this.startedAtMillis = startedAtMillis;
        this.nodeSeen = nodeSeen;
        if (allocationDelay != null && !Type.RESTART.equals((Object)type)) {
            throw new IllegalArgumentException("shard allocation delay is only valid for RESTART-type shutdowns");
        }
        this.allocationDelay = allocationDelay;
        if (targetNodeName != null && type != Type.REPLACE) {
            throw new IllegalArgumentException(Strings.format((String)"target node name is only valid for REPLACE type shutdowns, but was given type [%s] and target node name [%s]", (Object[])new Object[]{type, targetNodeName}));
        }
        if (!org.elasticsearch.common.Strings.hasText(targetNodeName) && type == Type.REPLACE) {
            throw new IllegalArgumentException("target node name is required for REPLACE type shutdowns");
        }
        this.targetNodeName = targetNodeName;
        if (Type.SIGTERM.equals((Object)type)) {
            if (gracePeriod == null) {
                throw new IllegalArgumentException("grace period is required for SIGTERM shutdowns");
            }
        } else if (gracePeriod != null) {
            throw new IllegalArgumentException(Strings.format((String)"grace period is only valid for SIGTERM type shutdowns, but was given type [%s] and target node name [%s]", (Object[])new Object[]{type, targetNodeName}));
        }
        this.gracePeriod = gracePeriod;
    }

    public SingleNodeShutdownMetadata(StreamInput in) throws IOException {
        this.nodeId = in.readString();
        this.type = in.readEnum(Type.class);
        this.reason = in.readString();
        this.startedAtMillis = in.readVLong();
        this.nodeSeen = in.readBoolean();
        this.allocationDelay = in.readOptionalTimeValue();
        this.targetNodeName = in.getTransportVersion().onOrAfter(REPLACE_SHUTDOWN_TYPE_ADDED_VERSION) ? in.readOptionalString() : null;
        this.gracePeriod = in.getTransportVersion().onOrAfter(GRACE_PERIOD_ADDED_VERSION) ? in.readOptionalTimeValue() : null;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public Type getType() {
        return this.type;
    }

    public String getReason() {
        return this.reason;
    }

    public long getStartedAtMillis() {
        return this.startedAtMillis;
    }

    public boolean getNodeSeen() {
        return this.nodeSeen;
    }

    public String getTargetNodeName() {
        return this.targetNodeName;
    }

    @Nullable
    public TimeValue getAllocationDelay() {
        if (this.allocationDelay != null) {
            return this.allocationDelay;
        }
        if (Type.RESTART.equals((Object)this.type)) {
            return DEFAULT_RESTART_SHARD_ALLOCATION_DELAY;
        }
        return null;
    }

    @Nullable
    public TimeValue getGracePeriod() {
        return this.gracePeriod;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.nodeId);
        if (out.getTransportVersion().before(REPLACE_SHUTDOWN_TYPE_ADDED_VERSION) && this.type == Type.REPLACE || out.getTransportVersion().before(SIGTERM_ADDED_VERSION) && this.type == Type.SIGTERM) {
            out.writeEnum(Type.REMOVE);
        } else {
            out.writeEnum(this.type);
        }
        out.writeString(this.reason);
        out.writeVLong(this.startedAtMillis);
        out.writeBoolean(this.nodeSeen);
        out.writeOptionalTimeValue(this.allocationDelay);
        if (out.getTransportVersion().onOrAfter(REPLACE_SHUTDOWN_TYPE_ADDED_VERSION)) {
            out.writeOptionalString(this.targetNodeName);
        }
        if (out.getTransportVersion().onOrAfter(GRACE_PERIOD_ADDED_VERSION)) {
            out.writeOptionalTimeValue(this.gracePeriod);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NODE_ID_FIELD.getPreferredName(), this.nodeId);
        builder.field(TYPE_FIELD.getPreferredName(), (Enum)this.type);
        builder.field(REASON_FIELD.getPreferredName(), this.reason);
        builder.timestampFieldsFromUnixEpochMillis(STARTED_AT_MILLIS_FIELD.getPreferredName(), STARTED_AT_READABLE_FIELD, this.startedAtMillis);
        builder.field(NODE_SEEN_FIELD.getPreferredName(), this.nodeSeen);
        if (this.allocationDelay != null) {
            builder.field(ALLOCATION_DELAY_FIELD.getPreferredName(), this.allocationDelay.getStringRep());
        }
        if (this.targetNodeName != null) {
            builder.field(TARGET_NODE_NAME_FIELD.getPreferredName(), this.targetNodeName);
        }
        if (this.gracePeriod != null) {
            builder.field(GRACE_PERIOD_FIELD.getPreferredName(), this.gracePeriod.getStringRep());
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SingleNodeShutdownMetadata)) {
            return false;
        }
        SingleNodeShutdownMetadata that = (SingleNodeShutdownMetadata)o;
        return this.getStartedAtMillis() == that.getStartedAtMillis() && this.getNodeSeen() == that.getNodeSeen() && this.getNodeId().equals(that.getNodeId()) && this.getType() == that.getType() && this.getReason().equals(that.getReason()) && Objects.equals(this.getAllocationDelay(), that.getAllocationDelay()) && Objects.equals(this.getTargetNodeName(), that.getTargetNodeName()) && Objects.equals(this.getGracePeriod(), that.getGracePeriod());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getNodeId(), this.getType(), this.getReason(), this.getStartedAtMillis(), this.getNodeSeen(), this.getAllocationDelay(), this.getTargetNodeName(), this.getGracePeriod()});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{").append("nodeId=[").append(this.nodeId).append(']').append(", type=[").append((Object)this.type).append("], reason=[").append(this.reason).append(']');
        if (this.allocationDelay != null) {
            stringBuilder.append(", allocationDelay=[").append(this.allocationDelay).append("]");
        }
        if (this.targetNodeName != null) {
            stringBuilder.append(", targetNodeName=[").append(this.targetNodeName).append("]");
        }
        if (this.gracePeriod != null) {
            stringBuilder.append(", gracePeriod=[").append(this.gracePeriod).append("]");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(SingleNodeShutdownMetadata original) {
        if (original == null) {
            return SingleNodeShutdownMetadata.builder();
        }
        return new Builder().setNodeId(original.getNodeId()).setType(original.getType()).setReason(original.getReason()).setStartedAtMillis(original.getStartedAtMillis()).setNodeSeen(original.getNodeSeen()).setTargetNodeName(original.getTargetNodeName());
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), NODE_ID_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), TYPE_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), REASON_FIELD);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), STARTED_AT_MILLIS_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), NODE_SEEN_FIELD);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> TimeValue.parseTimeValue((String)p.textOrNull(), (String)ALLOCATION_DELAY_FIELD.getPreferredName()), ALLOCATION_DELAY_FIELD, ObjectParser.ValueType.STRING_OR_NULL);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), TARGET_NODE_NAME_FIELD);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> TimeValue.parseTimeValue((String)p.textOrNull(), (String)GRACE_PERIOD_FIELD.getPreferredName()), GRACE_PERIOD_FIELD, ObjectParser.ValueType.STRING_OR_NULL);
        DEFAULT_RESTART_SHARD_ALLOCATION_DELAY = TimeValue.timeValueMinutes((long)5L);
    }

    public static enum Type {
        REMOVE,
        RESTART,
        REPLACE,
        SIGTERM;


        public static Type parse(String type) {
            return switch (type.toLowerCase(Locale.ROOT)) {
                case "remove" -> REMOVE;
                case "restart" -> RESTART;
                case "replace" -> REPLACE;
                case "sigterm" -> SIGTERM;
                default -> throw new IllegalArgumentException("unknown shutdown type: " + type);
            };
        }

        public boolean isRemovalType() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case REMOVE, SIGTERM, REPLACE -> true;
                case RESTART -> false;
            };
        }
    }

    public static class Builder {
        private String nodeId;
        private Type type;
        private String reason;
        private long startedAtMillis = -1L;
        private boolean nodeSeen = false;
        private TimeValue allocationDelay;
        private String targetNodeName;
        private TimeValue gracePeriod;

        private Builder() {
        }

        public Builder setNodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public Builder setType(Type type) {
            this.type = type;
            return this;
        }

        public Builder setReason(String reason) {
            this.reason = reason;
            return this;
        }

        public Builder setStartedAtMillis(long startedAtMillis) {
            this.startedAtMillis = startedAtMillis;
            return this;
        }

        public Builder setNodeSeen(boolean nodeSeen) {
            this.nodeSeen = nodeSeen;
            return this;
        }

        public Builder setAllocationDelay(TimeValue allocationDelay) {
            this.allocationDelay = allocationDelay;
            return this;
        }

        public Builder setTargetNodeName(String targetNodeName) {
            this.targetNodeName = targetNodeName;
            return this;
        }

        public Builder setGracePeriod(TimeValue gracePeriod) {
            this.gracePeriod = gracePeriod;
            return this;
        }

        public SingleNodeShutdownMetadata build() {
            if (this.startedAtMillis == -1L) {
                throw new IllegalArgumentException("start timestamp must be set");
            }
            return new SingleNodeShutdownMetadata(this.nodeId, this.type, this.reason, this.startedAtMillis, this.nodeSeen, this.allocationDelay, this.targetNodeName, this.gracePeriod);
        }
    }

    public static enum Status {
        NOT_STARTED,
        IN_PROGRESS,
        STALLED,
        COMPLETE;


        public static Status combine(Status ... statuses) {
            int statusOrd = -1;
            for (Status status : statuses) {
                if (status == COMPLETE) continue;
                statusOrd = Math.max(status.ordinal(), statusOrd);
            }
            if (statusOrd == -1) {
                return COMPLETE;
            }
            return Status.values()[statusOrd];
        }
    }
}

