/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsClusterStateUpdateRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateAckListener;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.allocator.AllocationActionMultiListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.ShardLimitValidator;
import org.elasticsearch.threadpool.ThreadPool;

public class MetadataUpdateSettingsService {
    private static final Logger logger = LogManager.getLogger(MetadataUpdateSettingsService.class);
    private final AllocationService allocationService;
    private final IndexScopedSettings indexScopedSettings;
    private final IndicesService indicesService;
    private final ShardLimitValidator shardLimitValidator;
    private final MasterServiceTaskQueue<UpdateSettingsTask> taskQueue;

    public MetadataUpdateSettingsService(ClusterService clusterService, AllocationService allocationService, IndexScopedSettings indexScopedSettings, IndicesService indicesService, ShardLimitValidator shardLimitValidator, ThreadPool threadPool) {
        this.allocationService = allocationService;
        this.indexScopedSettings = indexScopedSettings;
        this.indicesService = indicesService;
        this.shardLimitValidator = shardLimitValidator;
        this.taskQueue = clusterService.createTaskQueue("update-settings", Priority.URGENT, batchExecutionContext -> {
            AllocationActionMultiListener<AcknowledgedResponse> listener = new AllocationActionMultiListener<AcknowledgedResponse>(threadPool.getThreadContext());
            ClusterState state = batchExecutionContext.initialState();
            for (ClusterStateTaskExecutor.TaskContext taskContext : batchExecutionContext.taskContexts()) {
                try {
                    UpdateSettingsTask task = (UpdateSettingsTask)taskContext.getTask();
                    try (Releasable ignored = taskContext.captureResponseHeaders();){
                        state = task.execute(state);
                    }
                    taskContext.success(task.getAckListener(listener));
                }
                catch (Exception e) {
                    taskContext.onFailure(e);
                }
            }
            if (state != batchExecutionContext.initialState()) {
                try (Releasable ignored = batchExecutionContext.dropHeadersContext();){
                    state = allocationService.reroute(state, "settings update", listener.reroute());
                }
            } else {
                listener.noRerouteNeeded();
            }
            return state;
        });
    }

    public void updateSettings(UpdateSettingsClusterStateUpdateRequest request, ActionListener<AcknowledgedResponse> listener) {
        this.taskQueue.submitTask("update-settings " + Arrays.toString(request.indices()), new UpdateSettingsTask(request, listener), request.masterNodeTimeout());
    }

    public static void updateIndexSettings(Set<Index> indices, Metadata.Builder metadataBuilder, BiFunction<Index, Settings.Builder, Boolean> settingUpdater, Boolean preserveExisting, IndexScopedSettings indexScopedSettings) {
        for (Index index : indices) {
            IndexMetadata indexMetadata = metadataBuilder.getSafe(index);
            indexScopedSettings.validate(indexMetadata.getSettings(), true, true, true);
            Settings.Builder indexSettings = Settings.builder().put(indexMetadata.getSettings());
            if (!settingUpdater.apply(index, indexSettings).booleanValue()) continue;
            if (preserveExisting.booleanValue()) {
                indexSettings.put(indexMetadata.getSettings());
            }
            if (!IndexMetadata.INDEX_NUMBER_OF_REPLICAS_SETTING.exists(indexSettings)) {
                indexSettings.put("index.number_of_replicas", IndexMetadata.INDEX_NUMBER_OF_REPLICAS_SETTING.get(Settings.EMPTY));
            }
            Settings finalSettings = indexSettings.build();
            indexScopedSettings.validate(finalSettings.filter(k -> !indexScopedSettings.isPrivateSetting((String)k)), true);
            metadataBuilder.put(IndexMetadata.builder(indexMetadata).settings(finalSettings));
        }
    }

    private static boolean maybeUpdateClusterBlock(String[] actualIndices, ClusterBlocks.Builder blocks, ClusterBlock block, Setting<Boolean> setting, Settings openSettings) {
        boolean changed = false;
        if (setting.exists(openSettings)) {
            boolean updateBlock = setting.get(openSettings);
            for (String index : actualIndices) {
                if (updateBlock) {
                    if (blocks.hasIndexBlock(index, block)) continue;
                    blocks.addIndexBlock(index, block);
                    changed = true;
                    continue;
                }
                if (!blocks.hasIndexBlock(index, block)) continue;
                blocks.removeIndexBlock(index, block);
                changed = true;
            }
        }
        return changed;
    }

    private final class UpdateSettingsTask
    implements ClusterStateTaskListener {
        private final UpdateSettingsClusterStateUpdateRequest request;
        private final ActionListener<AcknowledgedResponse> listener;

        private UpdateSettingsTask(UpdateSettingsClusterStateUpdateRequest request, ActionListener<AcknowledgedResponse> listener) {
            this.request = request;
            this.listener = listener;
        }

        private ClusterStateAckListener getAckListener(final AllocationActionMultiListener<AcknowledgedResponse> multiListener) {
            return new ClusterStateAckListener(){

                @Override
                public boolean mustAck(DiscoveryNode discoveryNode) {
                    return true;
                }

                @Override
                public void onAllNodesAcked() {
                    multiListener.delay(UpdateSettingsTask.this.listener).onResponse(AcknowledgedResponse.of(true));
                }

                @Override
                public void onAckFailure(Exception e) {
                    multiListener.delay(UpdateSettingsTask.this.listener).onFailure(e);
                }

                @Override
                public void onAckTimeout() {
                    multiListener.delay(UpdateSettingsTask.this.listener).onResponse(AcknowledgedResponse.of(false));
                }

                @Override
                public TimeValue ackTimeout() {
                    return UpdateSettingsTask.this.request.ackTimeout();
                }
            };
        }

        @Override
        public void onFailure(Exception e) {
            this.listener.onFailure(e);
        }

        ClusterState execute(ClusterState currentState) {
            Settings normalizedSettings = Settings.builder().put(this.request.settings()).normalizePrefix("index.").build();
            Settings.Builder settingsForClosedIndices = Settings.builder();
            Settings.Builder settingsForOpenIndices = Settings.builder();
            HashSet<String> skippedSettings = new HashSet<String>();
            MetadataUpdateSettingsService.this.indexScopedSettings.validate(normalizedSettings.filter(s -> !Regex.isSimpleMatchPattern(s)), false, true);
            for (String key : normalizedSettings.keySet()) {
                boolean isWildcard;
                Setting<?> setting = MetadataUpdateSettingsService.this.indexScopedSettings.get(key);
                boolean bl = isWildcard = setting == null && Regex.isSimpleMatchPattern(key);
                assert (setting != null || isWildcard && !normalizedSettings.hasValue(key)) : "unknown setting: " + key + " isWildcard: " + isWildcard + " hasValue: " + normalizedSettings.hasValue(key);
                settingsForClosedIndices.copy(key, normalizedSettings);
                if (isWildcard || setting.isDynamic()) {
                    settingsForOpenIndices.copy(key, normalizedSettings);
                    continue;
                }
                skippedSettings.add(key);
            }
            Settings closedSettings = settingsForClosedIndices.build();
            Settings openSettings = settingsForOpenIndices.build();
            boolean preserveExisting = this.request.onExisting() == UpdateSettingsClusterStateUpdateRequest.OnExisting.PRESERVE;
            RoutingTable.Builder routingTableBuilder = null;
            Metadata.Builder metadataBuilder = Metadata.builder(currentState.metadata());
            HashSet<Index> openIndices = new HashSet<Index>();
            HashSet<Index> closedIndices = new HashSet<Index>();
            String[] actualIndices = new String[this.request.indices().length];
            for (int i = 0; i < this.request.indices().length; ++i) {
                Index index2 = this.request.indices()[i];
                actualIndices[i] = index2.getName();
                IndexMetadata metadata = currentState.metadata().getIndexSafe(index2);
                if (metadata.getState() == IndexMetadata.State.OPEN) {
                    openIndices.add(index2);
                    continue;
                }
                closedIndices.add(index2);
            }
            if (!skippedSettings.isEmpty() && !openIndices.isEmpty()) {
                if (this.request.onStaticSetting() == UpdateSettingsClusterStateUpdateRequest.OnStaticSetting.REOPEN_INDICES) {
                    routingTableBuilder = RoutingTable.builder(MetadataUpdateSettingsService.this.allocationService.getShardRoutingRoleStrategy(), currentState.routingTable());
                    for (Index index2 : openIndices) {
                        Settings existingSettings = currentState.getMetadata().index(index2).getSettings();
                        boolean needToReopenIndex = false;
                        for (String setting : skippedSettings) {
                            String newValue = this.request.settings().get(setting);
                            if (Objects.equals(newValue, existingSettings.get(setting))) continue;
                            needToReopenIndex = true;
                            break;
                        }
                        if (!needToReopenIndex) continue;
                        List<ShardRouting> shardRoutingList = currentState.routingTable().allShards(index2.getName());
                        IndexRoutingTable.Builder indexRoutingTableBuilder = IndexRoutingTable.builder(index2);
                        for (ShardRouting shardRouting : shardRoutingList) {
                            if (!ShardRoutingState.UNASSIGNED.equals((Object)shardRouting.state())) {
                                indexRoutingTableBuilder.addShard(shardRouting.moveToUnassigned(new UnassignedInfo(UnassignedInfo.Reason.INDEX_REOPENED, "Unassigning shards to update static settings")));
                                continue;
                            }
                            indexRoutingTableBuilder.addShard(shardRouting);
                        }
                        routingTableBuilder.add(indexRoutingTableBuilder.build());
                        openIndices.remove(index2);
                        closedIndices.add(index2);
                    }
                } else {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Can't update non dynamic settings [%s] for open indices %s unless the `reopen` query parameter is set to true. Alternatively, close the indices, apply the settings changes, and reopen the indices", skippedSettings, openIndices));
                }
            }
            if (IndexMetadata.INDEX_NUMBER_OF_REPLICAS_SETTING.exists(openSettings)) {
                int updatedNumberOfReplicas = IndexMetadata.INDEX_NUMBER_OF_REPLICAS_SETTING.get(openSettings);
                if (!preserveExisting) {
                    MetadataUpdateSettingsService.this.shardLimitValidator.validateShardLimitOnReplicaUpdate(currentState.nodes(), currentState.metadata(), this.request.indices(), updatedNumberOfReplicas);
                    if (routingTableBuilder == null) {
                        routingTableBuilder = RoutingTable.builder(MetadataUpdateSettingsService.this.allocationService.getShardRoutingRoleStrategy(), currentState.routingTable());
                    }
                    routingTableBuilder.updateNumberOfReplicas(updatedNumberOfReplicas, actualIndices);
                    metadataBuilder.updateNumberOfReplicas(updatedNumberOfReplicas, actualIndices);
                    logger.info("updating number_of_replicas to [{}] for indices {}", (Object)updatedNumberOfReplicas, (Object)actualIndices);
                }
            }
            MetadataUpdateSettingsService.updateIndexSettings(openIndices, metadataBuilder, (index, indexSettings) -> MetadataUpdateSettingsService.this.indexScopedSettings.updateDynamicSettings(openSettings, (Settings.Builder)indexSettings, Settings.builder(), index.getName()), preserveExisting, MetadataUpdateSettingsService.this.indexScopedSettings);
            MetadataUpdateSettingsService.updateIndexSettings(closedIndices, metadataBuilder, (index, indexSettings) -> MetadataUpdateSettingsService.this.indexScopedSettings.updateSettings(closedSettings, (Settings.Builder)indexSettings, Settings.builder(), index.getName()), preserveExisting, MetadataUpdateSettingsService.this.indexScopedSettings);
            if (IndexSettings.INDEX_TRANSLOG_RETENTION_AGE_SETTING.exists(normalizedSettings) || IndexSettings.INDEX_TRANSLOG_RETENTION_SIZE_SETTING.exists(normalizedSettings)) {
                for (String index3 : actualIndices) {
                    Settings settings = metadataBuilder.get(index3).getSettings();
                    MetadataCreateIndexService.validateTranslogRetentionSettings(settings);
                    MetadataCreateIndexService.validateStoreTypeSetting(settings);
                }
            }
            boolean changed = false;
            for (String index4 : actualIndices) {
                if (IndexSettings.same(currentState.metadata().index(index4).getSettings(), metadataBuilder.get(index4).getSettings())) continue;
                changed = true;
                IndexMetadata.Builder builder = IndexMetadata.builder(metadataBuilder.get(index4));
                builder.settingsVersion(1L + builder.settingsVersion());
                metadataBuilder.put(builder);
            }
            ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
            boolean changedBlocks = false;
            for (IndexMetadata.APIBlock block : IndexMetadata.APIBlock.values()) {
                changedBlocks |= MetadataUpdateSettingsService.maybeUpdateClusterBlock(actualIndices, blocks, block.block, block.setting, openSettings);
            }
            if (!(changed |= changedBlocks)) {
                return currentState;
            }
            ClusterState updatedState = ClusterState.builder(currentState).metadata(metadataBuilder).routingTable(routingTableBuilder == null ? currentState.routingTable() : routingTableBuilder.build()).blocks(changedBlocks ? blocks.build() : currentState.blocks()).build();
            try {
                IndexMetadata updatedMetadata;
                IndexMetadata currentMetadata;
                for (Index index5 : openIndices) {
                    currentMetadata = currentState.metadata().getIndexSafe(index5);
                    updatedMetadata = updatedState.metadata().getIndexSafe(index5);
                    MetadataUpdateSettingsService.this.indicesService.verifyIndexMetadata(currentMetadata, updatedMetadata);
                }
                for (Index index6 : closedIndices) {
                    currentMetadata = currentState.metadata().getIndexSafe(index6);
                    updatedMetadata = updatedState.metadata().getIndexSafe(index6);
                    MetadataUpdateSettingsService.this.indicesService.verifyIndexMetadata(currentMetadata, updatedMetadata);
                    MetadataUpdateSettingsService.this.indicesService.verifyIndexMetadata(updatedMetadata, updatedMetadata);
                }
            }
            catch (IOException ex) {
                throw ExceptionsHelper.convertToElastic(ex);
            }
            return updatedState;
        }

        public String toString() {
            return this.request.toString();
        }
    }
}

