/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.Diffable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.xcontent.ToXContent;

public class ClusterFeatures
implements Diffable<ClusterFeatures>,
ChunkedToXContentObject {
    private final Map<String, Set<String>> nodeFeatures;
    private Set<String> allNodeFeatures;

    public ClusterFeatures(Map<String, Set<String>> nodeFeatures) {
        this.nodeFeatures = nodeFeatures.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, e -> Set.copyOf((Collection)e.getValue())));
    }

    public static Set<String> calculateAllNodeFeatures(Collection<Set<String>> nodeFeatures) {
        if (nodeFeatures.isEmpty()) {
            return Set.of();
        }
        HashSet<String> allNodeFeatures = null;
        for (Set<String> featureSet : nodeFeatures) {
            if (allNodeFeatures == null) {
                allNodeFeatures = new HashSet<String>(featureSet);
                continue;
            }
            allNodeFeatures.retainAll(featureSet);
        }
        return allNodeFeatures;
    }

    public Map<String, Set<String>> nodeFeatures() {
        return this.nodeFeatures;
    }

    public Set<String> allNodeFeatures() {
        if (this.allNodeFeatures == null) {
            this.allNodeFeatures = Set.copyOf(ClusterFeatures.calculateAllNodeFeatures(this.nodeFeatures.values()));
        }
        return this.allNodeFeatures;
    }

    @SuppressForbidden(reason="directly reading cluster features")
    public boolean clusterHasFeature(NodeFeature feature) {
        return this.allNodeFeatures().contains(feature.id());
    }

    private static void writeCanonicalSets(StreamOutput out, Map<String, Set<String>> featureSets) throws IOException {
        ArrayList<Set<String>> canonicalFeatureSets = new ArrayList<Set<String>>();
        HashMap<String, Integer> nodeFeatureSetIndexes = new HashMap<String, Integer>();
        IdentityHashMap<Set<String>, Integer> identityLookup = new IdentityHashMap<Set<String>, Integer>();
        HashMap<Set<String>, Integer> lookup = new HashMap<Set<String>, Integer>();
        for (Map.Entry<String, Set<String>> fse : featureSets.entrySet()) {
            Integer idx = (Integer)identityLookup.get(fse.getValue());
            if (idx != null) {
                nodeFeatureSetIndexes.put(fse.getKey(), idx);
                continue;
            }
            idx = (Integer)lookup.get(fse.getValue());
            if (idx != null) {
                nodeFeatureSetIndexes.put(fse.getKey(), idx);
                continue;
            }
            idx = canonicalFeatureSets.size();
            canonicalFeatureSets.add(fse.getValue());
            nodeFeatureSetIndexes.put(fse.getKey(), idx);
            identityLookup.put(fse.getValue(), idx);
            lookup.put(fse.getValue(), idx);
        }
        out.writeCollection(canonicalFeatureSets, (o, c) -> o.writeCollection(c, StreamOutput::writeString));
        out.writeMap(nodeFeatureSetIndexes, StreamOutput::writeVInt);
    }

    private static Map<String, Set<String>> readCanonicalSets(StreamInput in) throws IOException {
        Set[] featureSets = in.readArray(i -> i.readCollectionAsImmutableSet(StreamInput::readString), Set[]::new);
        return in.readImmutableMap(streamInput -> featureSets[streamInput.readVInt()]);
    }

    public static ClusterFeatures readFrom(StreamInput in) throws IOException {
        return new ClusterFeatures(ClusterFeatures.readCanonicalSets(in));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        ClusterFeatures.writeCanonicalSets(out, this.nodeFeatures);
    }

    @Override
    public Diff<ClusterFeatures> diff(ClusterFeatures previousState) {
        HashSet<String> deletes = new HashSet<String>();
        HashMap<String, Set<String>> removals = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> additions = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Set<String>> prevNodeFeatures : previousState.nodeFeatures.entrySet()) {
            Set<String> newFeatures = this.nodeFeatures.get(prevNodeFeatures.getKey());
            if (newFeatures == null) {
                deletes.add(prevNodeFeatures.getKey());
                continue;
            }
            HashSet removed = new HashSet(prevNodeFeatures.getValue());
            removed.removeAll(newFeatures);
            if (!removed.isEmpty()) {
                removals.put(prevNodeFeatures.getKey(), removed);
            }
            HashSet<String> added = new HashSet<String>(newFeatures);
            added.removeAll((Collection)prevNodeFeatures.getValue());
            if (added.isEmpty()) continue;
            additions.put(prevNodeFeatures.getKey(), added);
        }
        for (Map.Entry<String, Set<String>> newNodeFeatures : this.nodeFeatures.entrySet()) {
            if (previousState.nodeFeatures.containsKey(newNodeFeatures.getKey())) continue;
            additions.put(newNodeFeatures.getKey(), newNodeFeatures.getValue());
        }
        return new ClusterFeaturesDiff(deletes, removals, additions);
    }

    public static Diff<ClusterFeatures> readDiffFrom(StreamInput in) throws IOException {
        return new ClusterFeaturesDiff(in);
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return ChunkedToXContent.builder(params).array(this.nodeFeatures.entrySet().stream().sorted(Map.Entry.comparingByKey()).iterator(), e -> (builder, p) -> {
            Object[] features = (String[])((Set)e.getValue()).toArray(String[]::new);
            Arrays.sort(features);
            return builder.startObject().field("node_id", (String)e.getKey()).array("features", (String[])features).endObject();
        });
    }

    public String toString() {
        TreeMap<String, Set<String>> features = new TreeMap<String, Set<String>>(this.nodeFeatures);
        features.replaceAll((k, v) -> new TreeSet(v));
        return "ClusterFeatures" + String.valueOf(features);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ClusterFeatures)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ClusterFeatures that = (ClusterFeatures)obj;
        return this.nodeFeatures.equals(that.nodeFeatures);
    }

    public int hashCode() {
        return Objects.hash(this.nodeFeatures);
    }

    private static class ClusterFeaturesDiff
    implements Diff<ClusterFeatures> {
        private final Set<String> deletes;
        private final Map<String, Set<String>> removals;
        private final Map<String, Set<String>> additions;

        private ClusterFeaturesDiff(Set<String> deletes, Map<String, Set<String>> removals, Map<String, Set<String>> additions) {
            this.deletes = deletes;
            this.removals = removals;
            this.additions = additions;
        }

        private ClusterFeaturesDiff(StreamInput in) throws IOException {
            this.deletes = in.readCollectionAsImmutableSet(StreamInput::readString);
            this.removals = ClusterFeatures.readCanonicalSets(in);
            this.additions = ClusterFeatures.readCanonicalSets(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.deletes, StreamOutput::writeString);
            ClusterFeatures.writeCanonicalSets(out, this.removals);
            ClusterFeatures.writeCanonicalSets(out, this.additions);
        }

        @Override
        public ClusterFeatures apply(ClusterFeatures part) {
            if (this.deletes.isEmpty() && this.removals.isEmpty() && this.additions.isEmpty()) {
                return part;
            }
            HashMap<String, Set<String>> newFeatures = new HashMap<String, Set<String>>(part.nodeFeatures);
            this.deletes.forEach(newFeatures::remove);
            for (Map.Entry<String, Set<String>> removes : this.removals.entrySet()) {
                newFeatures.compute(removes.getKey(), (k, v) -> v instanceof HashSet ? v : new HashSet(v)).removeAll((Collection)removes.getValue());
            }
            for (Map.Entry<String, Set<String>> adds : this.additions.entrySet()) {
                newFeatures.compute(adds.getKey(), (k, v) -> v == null ? new HashSet() : (v instanceof HashSet ? v : new HashSet(v))).addAll((Collection)adds.getValue());
            }
            return new ClusterFeatures(newFeatures);
        }
    }
}

