/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.search.SearchContextIdForNode;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.search.internal.ShardSearchContextId;

public final class SearchContextId {
    private final Map<ShardId, SearchContextIdForNode> shards;
    private final Map<String, AliasFilter> aliasFilter;
    private final transient Set<ShardSearchContextId> contextIds;

    SearchContextId(Map<ShardId, SearchContextIdForNode> shards, Map<String, AliasFilter> aliasFilter) {
        this.shards = shards;
        this.aliasFilter = aliasFilter;
        this.contextIds = shards.values().stream().map(SearchContextIdForNode::getSearchContextId).collect(Collectors.toSet());
    }

    public Map<ShardId, SearchContextIdForNode> shards() {
        return this.shards;
    }

    public Map<String, AliasFilter> aliasFilter() {
        return this.aliasFilter;
    }

    public boolean contains(ShardSearchContextId contextId) {
        return this.contextIds.contains(contextId);
    }

    public static BytesReference encode(List<SearchPhaseResult> searchPhaseResults, Map<String, AliasFilter> aliasFilter, TransportVersion version, ShardSearchFailure[] shardFailures) {
        assert (shardFailures.length == 0 || version.onOrAfter(TransportVersions.ALLOW_PARTIAL_SEARCH_RESULTS_IN_PIT)) : "[allow_partial_search_results] cannot be enabled on a cluster that has not been fully upgraded to version [" + String.valueOf(TransportVersions.ALLOW_PARTIAL_SEARCH_RESULTS_IN_PIT) + "] or higher.";
        BytesStreamOutput out = new BytesStreamOutput();
        try {
            out.setTransportVersion(version);
            TransportVersion.writeVersion(version, out);
            boolean allowNullContextId = out.getTransportVersion().onOrAfter(TransportVersions.ALLOW_PARTIAL_SEARCH_RESULTS_IN_PIT);
            int shardSize = searchPhaseResults.size() + (allowNullContextId ? shardFailures.length : 0);
            out.writeVInt(shardSize);
            for (SearchPhaseResult searchResult : searchPhaseResults) {
                SearchShardTarget target = searchResult.getSearchShardTarget();
                target.getShardId().writeTo(out);
                new SearchContextIdForNode(target.getClusterAlias(), target.getNodeId(), searchResult.getContextId()).writeTo(out);
            }
            if (allowNullContextId) {
                for (ShardSearchFailure failure : shardFailures) {
                    failure.shard().getShardId().writeTo(out);
                    new SearchContextIdForNode(failure.shard().getClusterAlias(), null, null).writeTo(out);
                }
            }
            out.writeMap(aliasFilter, StreamOutput::writeWriteable);
            BytesReference bytesReference = out.bytes();
            out.close();
            return bytesReference;
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                assert (false) : e;
                throw new IllegalArgumentException(e);
            }
        }
    }

    public static SearchContextId decode(NamedWriteableRegistry namedWriteableRegistry, BytesReference id) {
        SearchContextId searchContextId;
        NamedWriteableAwareStreamInput in = new NamedWriteableAwareStreamInput(id.streamInput(), namedWriteableRegistry);
        try {
            TransportVersion version = TransportVersion.readVersion(in);
            in.setTransportVersion(version);
            Map<ShardId, SearchContextIdForNode> shards = Collections.unmodifiableMap(in.readCollection(Maps::newHashMapWithExpectedSize, SearchContextId::readShardsMapEntry));
            Map<String, AliasFilter> aliasFilters = in.readImmutableMap(AliasFilter::readFrom);
            if (in.available() > 0) {
                throw new IllegalArgumentException("Not all bytes were read");
            }
            searchContextId = new SearchContextId(shards, aliasFilters);
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                assert (false) : e;
                throw new IllegalArgumentException(e);
            }
        }
        in.close();
        return searchContextId;
    }

    public static String[] decodeIndices(BytesReference id) {
        String[] stringArray;
        block9: {
            StreamInput in = id.streamInput();
            try {
                TransportVersion version = TransportVersion.readVersion(in);
                in.setTransportVersion(version);
                Map<ShardId, SearchContextIdForNode> shards = Collections.unmodifiableMap(in.readCollection(Maps::newHashMapWithExpectedSize, SearchContextId::readShardsMapEntry));
                stringArray = new SearchContextId(shards, Collections.emptyMap()).getActualIndices();
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    assert (false) : e;
                    throw new IllegalArgumentException(e);
                }
            }
            in.close();
        }
        return stringArray;
    }

    private static void readShardsMapEntry(StreamInput in, Map<ShardId, SearchContextIdForNode> shards) throws IOException {
        shards.put(new ShardId(in), new SearchContextIdForNode(in));
    }

    public String[] getActualIndices() {
        TreeSet<Object> indices = new TreeSet<Object>();
        for (Map.Entry<ShardId, SearchContextIdForNode> entry : this.shards().entrySet()) {
            String indexName = entry.getKey().getIndexName();
            String clusterAlias = entry.getValue().getClusterAlias();
            if (Strings.isEmpty(clusterAlias)) {
                indices.add(indexName);
                continue;
            }
            indices.add(clusterAlias + ":" + indexName);
        }
        return (String[])indices.toArray(String[]::new);
    }
}

