/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.settings.get;

import java.util.Collections;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.index.Index;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.Transports;

public class TransportGetSettingsAction
extends TransportMasterNodeReadAction<GetSettingsRequest, GetSettingsResponse> {
    private final SettingsFilter settingsFilter;
    private final IndexScopedSettings indexScopedSettings;

    @Inject
    public TransportGetSettingsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, SettingsFilter settingsFilter, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndexScopedSettings indexedScopedSettings) {
        super("indices:monitor/settings/get", transportService, clusterService, threadPool, actionFilters, GetSettingsRequest::new, indexNameExpressionResolver, GetSettingsResponse::new, threadPool.executor("management"));
        this.settingsFilter = settingsFilter;
        this.indexScopedSettings = indexedScopedSettings;
    }

    @Override
    protected ClusterBlockException checkBlock(GetSettingsRequest request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, this.indexNameExpressionResolver.concreteIndexNames(state, request));
    }

    private static boolean isFilteredRequest(GetSettingsRequest request) {
        return !CollectionUtils.isEmpty(request.names());
    }

    @Override
    protected void masterOperation(Task task, GetSettingsRequest request, ClusterState state, ActionListener<GetSettingsResponse> listener) {
        assert (Transports.assertNotTransportThread("O(indices) work is too much for a transport thread"));
        Index[] concreteIndices = this.indexNameExpressionResolver.concreteIndices(state, request);
        Map<String, Settings> indexToSettings = Maps.newHashMapWithExpectedSize(concreteIndices.length);
        Map<String, Settings> indexToDefaultSettings = request.includeDefaults() ? Maps.newHashMapWithExpectedSize(concreteIndices.length) : null;
        for (Index concreteIndex : concreteIndices) {
            IndexMetadata indexMetadata = state.getMetadata().index(concreteIndex);
            if (indexMetadata == null) continue;
            Settings indexSettings = this.settingsFilter.filter(indexMetadata.getSettings());
            if (request.humanReadable()) {
                indexSettings = IndexMetadata.addHumanReadableSettings(indexSettings);
            }
            if (TransportGetSettingsAction.isFilteredRequest(request)) {
                indexSettings = indexSettings.filter(k -> Regex.simpleMatch(request.names(), k));
            }
            indexToSettings.put(concreteIndex.getName(), indexSettings);
            if (indexToDefaultSettings == null) continue;
            Settings defaultSettings = this.settingsFilter.filter(this.indexScopedSettings.diff(indexSettings, Settings.EMPTY));
            if (TransportGetSettingsAction.isFilteredRequest(request)) {
                defaultSettings = defaultSettings.filter(k -> Regex.simpleMatch(request.names(), k));
            }
            indexToDefaultSettings.put(concreteIndex.getName(), defaultSettings);
        }
        listener.onResponse(new GetSettingsResponse(Collections.unmodifiableMap(indexToSettings), indexToDefaultSettings == null ? Map.of() : Collections.unmodifiableMap(indexToDefaultSettings)));
    }
}

