/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.rollover;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.rollover.Condition;
import org.elasticsearch.action.admin.indices.rollover.RolloverConditions;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.IndexComponentSelector;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

public class RolloverRequest
extends AcknowledgedRequest<RolloverRequest>
implements IndicesRequest {
    private static final ObjectParser<RolloverRequest, Boolean> PARSER = new ObjectParser("rollover");
    private static final ParseField CONDITIONS = new ParseField("conditions", new String[0]);
    private String rolloverTarget;
    private String newIndexName;
    private boolean dryRun;
    private boolean lazy;
    private RolloverConditions conditions = new RolloverConditions();
    private CreateIndexRequest createIndexRequest = new CreateIndexRequest("_na_");
    private IndicesOptions indicesOptions = IndicesOptions.strictSingleIndexNoExpandForbidClosed();

    public RolloverRequest(StreamInput in) throws IOException {
        super(in);
        this.rolloverTarget = in.readString();
        this.newIndexName = in.readOptionalString();
        this.dryRun = in.readBoolean();
        this.conditions = new RolloverConditions(in);
        this.createIndexRequest = new CreateIndexRequest(in);
        this.lazy = in.getTransportVersion().onOrAfter(TransportVersions.V_8_13_0) ? in.readBoolean() : false;
        if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_14_0)) {
            this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        }
    }

    RolloverRequest() {
        super(TRAPPY_IMPLICIT_DEFAULT_MASTER_NODE_TIMEOUT, DEFAULT_ACK_TIMEOUT);
    }

    public RolloverRequest(String rolloverTarget, String newIndexName) {
        super(TRAPPY_IMPLICIT_DEFAULT_MASTER_NODE_TIMEOUT, DEFAULT_ACK_TIMEOUT);
        this.rolloverTarget = rolloverTarget;
        this.newIndexName = newIndexName;
    }

    @Override
    public ActionRequestValidationException validate() {
        IndexComponentSelector selector;
        ActionRequestValidationException validationException = this.createIndexRequest.validate();
        if (this.rolloverTarget == null) {
            validationException = ValidateActions.addValidationError("rollover target is missing", validationException);
        }
        if (this.conditions.hasMinConditions() && !this.conditions.hasMaxConditions()) {
            validationException = ValidateActions.addValidationError("at least one max_* rollover condition must be set when using min_* conditions", validationException);
        }
        if ((selector = this.indicesOptions.selectorOptions().defaultSelector()) == IndexComponentSelector.ALL_APPLICABLE) {
            validationException = ValidateActions.addValidationError("rollover cannot be applied to both regular and failure indices at the same time", validationException);
        }
        return validationException;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.rolloverTarget);
        out.writeOptionalString(this.newIndexName);
        out.writeBoolean(this.dryRun);
        this.conditions.writeTo(out);
        this.createIndexRequest.writeTo(out);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_13_0)) {
            out.writeBoolean(this.lazy);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_14_0)) {
            this.indicesOptions.writeIndicesOptions(out);
        }
    }

    @Override
    public String[] indices() {
        return new String[]{this.rolloverTarget};
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public boolean targetsFailureStore() {
        return DataStream.isFailureStoreFeatureFlagEnabled() && this.indicesOptions.includeFailureIndices();
    }

    public void setIndicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
    }

    @Override
    public boolean includeDataStreams() {
        return true;
    }

    public void setRolloverTarget(String rolloverTarget) {
        this.rolloverTarget = rolloverTarget;
    }

    public void setNewIndexName(String newIndexName) {
        this.newIndexName = newIndexName;
    }

    public void dryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public void setWaitForActiveShards(ActiveShardCount waitForActiveShards) {
        this.createIndexRequest.waitForActiveShards(waitForActiveShards);
    }

    public void setConditions(RolloverConditions conditions) {
        this.conditions = conditions;
    }

    public void lazy(boolean lazy) {
        this.lazy = lazy;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public RolloverConditions getConditions() {
        return this.conditions;
    }

    public Collection<Condition<?>> getConditionValues() {
        return this.conditions.getConditions().values();
    }

    public String getRolloverTarget() {
        return this.rolloverTarget;
    }

    public String getNewIndexName() {
        return this.newIndexName;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public boolean areConditionsMet(Map<String, Boolean> conditionResults) {
        return this.conditions.areConditionsMet(conditionResults);
    }

    public CreateIndexRequest getCreateIndexRequest() {
        return this.createIndexRequest;
    }

    public void fromXContent(boolean isTypeIncluded, XContentParser parser) throws IOException {
        PARSER.parse(parser, (Object)this, (Object)isTypeIncluded);
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new CancellableTask(id, type, action, "", parentTaskId, headers);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RolloverRequest that = (RolloverRequest)o;
        return this.dryRun == that.dryRun && this.lazy == that.lazy && Objects.equals(this.rolloverTarget, that.rolloverTarget) && Objects.equals(this.newIndexName, that.newIndexName) && Objects.equals(this.conditions, that.conditions) && Objects.equals(this.createIndexRequest, that.createIndexRequest) && Objects.equals(this.indicesOptions, that.indicesOptions);
    }

    public int hashCode() {
        return Objects.hash(this.rolloverTarget, this.newIndexName, this.dryRun, this.conditions, this.createIndexRequest, this.lazy, this.indicesOptions);
    }

    static {
        PARSER.declareField((parser, request, context) -> request.setConditions(RolloverConditions.fromXContent(parser)), CONDITIONS, ObjectParser.ValueType.OBJECT);
        PARSER.declareField((parser, request, context) -> request.createIndexRequest.settings(parser.map()), CreateIndexRequest.SETTINGS, ObjectParser.ValueType.OBJECT);
        PARSER.declareField((parser, request, includeTypeName) -> {
            if (includeTypeName.booleanValue()) {
                for (Map.Entry mappingsEntry : parser.map().entrySet()) {
                    Map value = (Map)mappingsEntry.getValue();
                    request.createIndexRequest.mapping(value);
                }
            } else {
                Map mappings = parser.map();
                if (MapperService.isMappingSourceTyped("_doc", mappings)) {
                    throw new IllegalArgumentException("The mapping definition cannot be nested under a type [_doc] unless include_type_name is set to true.");
                }
                request.createIndexRequest.mapping(mappings);
            }
        }, CreateIndexRequest.MAPPINGS.forRestApiVersion(RestApiVersion.equalTo((RestApiVersion)RestApiVersion.V_7)), ObjectParser.ValueType.OBJECT);
        PARSER.declareField((parser, request, context) -> {
            Map mappings = parser.map();
            if (MapperService.isMappingSourceTyped("_doc", mappings)) {
                throw new IllegalArgumentException("The mapping definition cannot be nested under a type");
            }
            request.createIndexRequest.mapping(mappings);
        }, CreateIndexRequest.MAPPINGS.forRestApiVersion(RestApiVersion.onOrAfter((RestApiVersion)RestApiVersion.V_8)), ObjectParser.ValueType.OBJECT);
        PARSER.declareField((parser, request, context) -> request.createIndexRequest.aliases(parser.map()), CreateIndexRequest.ALIASES, ObjectParser.ValueType.OBJECT);
    }
}

