/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.stats;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequestParameters;
import org.elasticsearch.action.admin.indices.stats.CommonStatsFlags;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;

public class NodesStatsRequest
extends BaseNodesRequest<NodesStatsRequest> {
    private final NodesStatsRequestParameters nodesStatsRequestParameters;

    public NodesStatsRequest() {
        super((String[])null);
        this.nodesStatsRequestParameters = new NodesStatsRequestParameters();
    }

    public NodesStatsRequest(String ... nodesIds) {
        this(new NodesStatsRequestParameters(), nodesIds);
    }

    public NodesStatsRequest(NodesStatsRequestParameters nodesStatsRequestParameters, String ... nodesIds) {
        super(nodesIds);
        this.nodesStatsRequestParameters = nodesStatsRequestParameters;
    }

    public NodesStatsRequest all() {
        this.nodesStatsRequestParameters.indices().all();
        this.nodesStatsRequestParameters.requestedMetrics().addAll(NodesStatsRequestParameters.Metric.ALL);
        return this;
    }

    public NodesStatsRequest clear() {
        this.nodesStatsRequestParameters.indices().clear();
        this.nodesStatsRequestParameters.requestedMetrics().clear();
        return this;
    }

    public CommonStatsFlags indices() {
        return this.nodesStatsRequestParameters.indices();
    }

    public NodesStatsRequest indices(CommonStatsFlags indices) {
        this.nodesStatsRequestParameters.setIndices(indices);
        return this;
    }

    public NodesStatsRequest indices(boolean indices) {
        if (indices) {
            this.nodesStatsRequestParameters.indices().all();
        } else {
            this.nodesStatsRequestParameters.indices().clear();
        }
        return this;
    }

    public Set<NodesStatsRequestParameters.Metric> requestedMetrics() {
        return Set.copyOf(this.nodesStatsRequestParameters.requestedMetrics());
    }

    public NodesStatsRequest addMetric(NodesStatsRequestParameters.Metric metric) {
        this.nodesStatsRequestParameters.requestedMetrics().add(metric);
        return this;
    }

    public NodesStatsRequest addMetrics(NodesStatsRequestParameters.Metric ... metrics) {
        for (NodesStatsRequestParameters.Metric metric : metrics) {
            this.nodesStatsRequestParameters.requestedMetrics().add(metric);
        }
        return this;
    }

    public NodesStatsRequest addMetrics(List<NodesStatsRequestParameters.Metric> metrics) {
        this.nodesStatsRequestParameters.requestedMetrics().addAll(metrics);
        return this;
    }

    public NodesStatsRequest removeMetric(NodesStatsRequestParameters.Metric metric) {
        this.nodesStatsRequestParameters.requestedMetrics().remove((Object)metric);
        return this;
    }

    @Override
    public String getDescription() {
        return Strings.format("nodes=%s, metrics=%s, flags=%s", Arrays.toString(this.nodesIds()), this.nodesStatsRequestParameters.requestedMetrics().toString(), Arrays.toString((Object[])this.nodesStatsRequestParameters.indices().getFlags()));
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new CancellableTask(id, type, action, "", parentTaskId, headers){

            @Override
            public String getDescription() {
                return NodesStatsRequest.this.getDescription();
            }
        };
    }

    public boolean includeShardsStats() {
        return this.nodesStatsRequestParameters.includeShardsStats();
    }

    public void setIncludeShardsStats(boolean includeShardsStats) {
        this.nodesStatsRequestParameters.setIncludeShardsStats(includeShardsStats);
    }

    public NodesStatsRequestParameters getNodesStatsRequestParameters() {
        return this.nodesStatsRequestParameters;
    }
}

