/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.health;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ClusterStatsLevel;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.health.ClusterIndexHealth;
import org.elasticsearch.cluster.health.ClusterStateHealth;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class ClusterHealthResponse
extends ActionResponse
implements ToXContentObject {
    static final String CLUSTER_NAME = "cluster_name";
    static final String STATUS = "status";
    static final String TIMED_OUT = "timed_out";
    static final String NUMBER_OF_NODES = "number_of_nodes";
    static final String NUMBER_OF_DATA_NODES = "number_of_data_nodes";
    static final String NUMBER_OF_PENDING_TASKS = "number_of_pending_tasks";
    static final String NUMBER_OF_IN_FLIGHT_FETCH = "number_of_in_flight_fetch";
    static final String DELAYED_UNASSIGNED_SHARDS = "delayed_unassigned_shards";
    private static final String TASK_MAX_WAIT_TIME_IN_QUEUE = "task_max_waiting_in_queue";
    static final String TASK_MAX_WAIT_TIME_IN_QUEUE_IN_MILLIS = "task_max_waiting_in_queue_millis";
    static final String ACTIVE_SHARDS_PERCENT_AS_NUMBER = "active_shards_percent_as_number";
    private static final String ACTIVE_SHARDS_PERCENT = "active_shards_percent";
    static final String ACTIVE_PRIMARY_SHARDS = "active_primary_shards";
    static final String ACTIVE_SHARDS = "active_shards";
    static final String RELOCATING_SHARDS = "relocating_shards";
    static final String INITIALIZING_SHARDS = "initializing_shards";
    static final String UNASSIGNED_SHARDS = "unassigned_shards";
    static final String UNASSIGNED_PRIMARY_SHARDS = "unassigned_primary_shards";
    static final String INDICES = "indices";
    private String clusterName;
    private int numberOfPendingTasks = 0;
    private int numberOfInFlightFetch = 0;
    private int delayedUnassignedShards = 0;
    private TimeValue taskMaxWaitingTime = TimeValue.timeValueMillis((long)0L);
    private boolean timedOut = false;
    private ClusterStateHealth clusterStateHealth;
    private ClusterHealthStatus clusterHealthStatus;

    public ClusterHealthResponse() {
    }

    public ClusterHealthResponse(StreamInput in) throws IOException {
        super(in);
        this.clusterName = in.readString();
        this.clusterHealthStatus = ClusterHealthStatus.readFrom(in);
        this.clusterStateHealth = new ClusterStateHealth(in);
        this.numberOfPendingTasks = in.readInt();
        this.timedOut = in.readBoolean();
        this.numberOfInFlightFetch = in.readInt();
        this.delayedUnassignedShards = in.readInt();
        this.taskMaxWaitingTime = in.readTimeValue();
    }

    public ClusterHealthResponse(String clusterName, String[] concreteIndices, ClusterState clusterState) {
        this(clusterName, concreteIndices, clusterState, -1, -1, -1, TimeValue.timeValueHours((long)0L));
    }

    public ClusterHealthResponse(String clusterName, String[] concreteIndices, ClusterState clusterState, int numberOfPendingTasks, int numberOfInFlightFetch, int delayedUnassignedShards, TimeValue taskMaxWaitingTime) {
        this.clusterName = clusterName;
        this.numberOfPendingTasks = numberOfPendingTasks;
        this.numberOfInFlightFetch = numberOfInFlightFetch;
        this.delayedUnassignedShards = delayedUnassignedShards;
        this.taskMaxWaitingTime = taskMaxWaitingTime;
        this.clusterStateHealth = new ClusterStateHealth(clusterState, concreteIndices);
        this.clusterHealthStatus = this.clusterStateHealth.getStatus();
    }

    ClusterHealthResponse(String clusterName, int numberOfPendingTasks, int numberOfInFlightFetch, int delayedUnassignedShards, TimeValue taskMaxWaitingTime, boolean timedOut, ClusterStateHealth clusterStateHealth) {
        this.clusterName = clusterName;
        this.numberOfPendingTasks = numberOfPendingTasks;
        this.numberOfInFlightFetch = numberOfInFlightFetch;
        this.delayedUnassignedShards = delayedUnassignedShards;
        this.taskMaxWaitingTime = taskMaxWaitingTime;
        this.timedOut = timedOut;
        this.clusterStateHealth = clusterStateHealth;
        this.clusterHealthStatus = clusterStateHealth.getStatus();
    }

    public String getClusterName() {
        return this.clusterName;
    }

    ClusterStateHealth getClusterStateHealth() {
        return this.clusterStateHealth;
    }

    public int getActiveShards() {
        return this.clusterStateHealth.getActiveShards();
    }

    public int getRelocatingShards() {
        return this.clusterStateHealth.getRelocatingShards();
    }

    public int getActivePrimaryShards() {
        return this.clusterStateHealth.getActivePrimaryShards();
    }

    public int getInitializingShards() {
        return this.clusterStateHealth.getInitializingShards();
    }

    public int getUnassignedShards() {
        return this.clusterStateHealth.getUnassignedShards();
    }

    public int getUnassignedPrimaryShards() {
        return this.clusterStateHealth.getUnassignedPrimaryShards();
    }

    public int getNumberOfNodes() {
        return this.clusterStateHealth.getNumberOfNodes();
    }

    public int getNumberOfDataNodes() {
        return this.clusterStateHealth.getNumberOfDataNodes();
    }

    public int getNumberOfPendingTasks() {
        return this.numberOfPendingTasks;
    }

    public int getNumberOfInFlightFetch() {
        return this.numberOfInFlightFetch;
    }

    public int getDelayedUnassignedShards() {
        return this.delayedUnassignedShards;
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    public void setTimedOut(boolean timedOut) {
        this.timedOut = timedOut;
    }

    public ClusterHealthStatus getStatus() {
        return this.clusterHealthStatus;
    }

    public void setStatus(ClusterHealthStatus status) {
        if (status == null) {
            throw new IllegalArgumentException("'status' must not be null");
        }
        this.clusterHealthStatus = status;
    }

    public Map<String, ClusterIndexHealth> getIndices() {
        return this.clusterStateHealth.getIndices();
    }

    public TimeValue getTaskMaxWaitingTime() {
        return this.taskMaxWaitingTime;
    }

    public double getActiveShardsPercent() {
        return this.clusterStateHealth.getActiveShardsPercent();
    }

    public static ClusterHealthResponse readResponseFrom(StreamInput in) throws IOException {
        return new ClusterHealthResponse(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.clusterName);
        out.writeByte(this.clusterHealthStatus.value());
        this.clusterStateHealth.writeTo(out);
        out.writeInt(this.numberOfPendingTasks);
        out.writeBoolean(this.timedOut);
        out.writeInt(this.numberOfInFlightFetch);
        out.writeInt(this.delayedUnassignedShards);
        out.writeTimeValue(this.taskMaxWaitingTime);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public RestStatus status() {
        return this.isTimedOut() ? RestStatus.REQUEST_TIMEOUT : RestStatus.OK;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean outputIndices;
        builder.startObject();
        builder.field(CLUSTER_NAME, this.getClusterName());
        builder.field(STATUS, this.getStatus().name().toLowerCase(Locale.ROOT));
        builder.field(TIMED_OUT, this.isTimedOut());
        builder.field(NUMBER_OF_NODES, this.getNumberOfNodes());
        builder.field(NUMBER_OF_DATA_NODES, this.getNumberOfDataNodes());
        builder.field(ACTIVE_PRIMARY_SHARDS, this.getActivePrimaryShards());
        builder.field(ACTIVE_SHARDS, this.getActiveShards());
        builder.field(RELOCATING_SHARDS, this.getRelocatingShards());
        builder.field(INITIALIZING_SHARDS, this.getInitializingShards());
        builder.field(UNASSIGNED_SHARDS, this.getUnassignedShards());
        builder.field(UNASSIGNED_PRIMARY_SHARDS, this.getUnassignedPrimaryShards());
        builder.field(DELAYED_UNASSIGNED_SHARDS, this.getDelayedUnassignedShards());
        builder.field(NUMBER_OF_PENDING_TASKS, this.getNumberOfPendingTasks());
        builder.field(NUMBER_OF_IN_FLIGHT_FETCH, this.getNumberOfInFlightFetch());
        builder.humanReadableField(TASK_MAX_WAIT_TIME_IN_QUEUE_IN_MILLIS, TASK_MAX_WAIT_TIME_IN_QUEUE, (Object)this.getTaskMaxWaitingTime());
        builder.percentageField(ACTIVE_SHARDS_PERCENT_AS_NUMBER, ACTIVE_SHARDS_PERCENT, this.getActiveShardsPercent());
        ClusterStatsLevel level = ClusterStatsLevel.of(params, ClusterStatsLevel.CLUSTER);
        boolean bl = outputIndices = level == ClusterStatsLevel.INDICES || level == ClusterStatsLevel.SHARDS;
        if (outputIndices) {
            builder.startObject(INDICES);
            for (ClusterIndexHealth indexHealth : this.clusterStateHealth.getIndices().values()) {
                indexHealth.toXContent(builder, params);
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterHealthResponse that = (ClusterHealthResponse)o;
        return Objects.equals(this.clusterName, that.clusterName) && this.numberOfPendingTasks == that.numberOfPendingTasks && this.numberOfInFlightFetch == that.numberOfInFlightFetch && this.delayedUnassignedShards == that.delayedUnassignedShards && Objects.equals(this.taskMaxWaitingTime, that.taskMaxWaitingTime) && this.timedOut == that.timedOut && Objects.equals(this.clusterStateHealth, that.clusterStateHealth) && this.clusterHealthStatus == that.clusterHealthStatus;
    }

    public int hashCode() {
        return Objects.hash(this.clusterName, this.numberOfPendingTasks, this.numberOfInFlightFetch, this.delayedUnassignedShards, this.taskMaxWaitingTime, this.timedOut, this.clusterStateHealth, this.clusterHealthStatus);
    }
}

