/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.ServiceLoader;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.regex.Pattern;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.internal.BuildExtension;
import org.elasticsearch.plugins.ExtensionLoader;

public class ReleaseVersions {
    private static final boolean USES_VERSIONS = ExtensionLoader.loadSingleton(ServiceLoader.load(BuildExtension.class)).map(BuildExtension::hasReleaseVersioning).orElse(true);
    private static final Pattern VERSION_LINE = Pattern.compile("(\\d+\\.\\d+\\.\\d+),(\\d+)");

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IntFunction<String> generateVersionsLookup(Class<?> versionContainer, int current) {
        if (!ReleaseVersions.USES_VERSIONS) {
            return (IntFunction<String>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, toString(int ), (I)Ljava/lang/String;)();
        }
        try {
            versionsFileName = versionContainer.getSimpleName() + ".csv";
            versionsFile = versionContainer.getResourceAsStream(versionsFileName);
            if (versionsFile == null) {
                throw new FileNotFoundException(Strings.format("Could not find versions file for class [%s]", new Object[]{versionContainer}));
            }
            versions = new TreeMap<Integer, List<Version>>();
            versions.computeIfAbsent(current, (Function<Integer, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$generateVersionsLookup$0(java.lang.Integer ), (Ljava/lang/Integer;)Ljava/util/List;)()).add(Version.CURRENT);
            reader = new BufferedReader(new InputStreamReader(versionsFile, StandardCharsets.UTF_8));
            ** try [egrp 1[TRYBLOCK] [1 : 110->272)] { 
lbl13:
            // 1 sources

            ** GOTO lbl-1000
lbl14:
            // 1 sources

            finally {
                reader.close();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
lbl-1000:
        // 2 sources

        {
            while ((line = reader.readLine()) != null) {
                matcher = ReleaseVersions.VERSION_LINE.matcher(line);
                if (!matcher.matches()) {
                    throw new IOException(Strings.format("Incorrect format for line [%s] in [%s]", new Object[]{line, versionsFileName}));
                }
                try {
                    id = Integer.valueOf(matcher.group(2));
                    version = Version.fromString(matcher.group(1));
                    versions.computeIfAbsent(id, (Function<Integer, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$generateVersionsLookup$1(java.lang.Integer ), (Ljava/lang/Integer;)Ljava/util/List;)()).add(version);
                }
                catch (IllegalArgumentException e) {
                    if (!ReleaseVersions.$assertionsDisabled) {
                        throw new AssertionError((Object)("Regex allowed non-integer id or incorrect version through: " + String.valueOf(e)));
                    }
                    throw new IOException(Strings.format("Incorrect format for line [%s] in [%s]", new Object[]{line, versionsFileName}), e);
                }
            }
        }
        versions.replaceAll((BiFunction<Integer, List, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$generateVersionsLookup$2(java.lang.Integer java.util.List ), (Ljava/lang/Integer;Ljava/util/List;)Ljava/util/List;)());
        return ReleaseVersions.lookupFunction(versions);
    }

    private static IntFunction<String> lookupFunction(NavigableMap<Integer, List<Version>> versions) {
        assert (versions.values().stream().allMatch(vs -> vs.size() == 1 || vs.size() == 2)) : "Version ranges have not been properly processed: " + String.valueOf(versions);
        return id -> {
            Object upperBound;
            String lowerBound;
            List versionRange = (List)versions.get(id);
            if (versionRange != null) {
                lowerBound = ((Version)versionRange.get(0)).toString();
                upperBound = ((Version)ReleaseVersions.lastItem(versionRange)).toString();
            } else {
                Map.Entry lowerRange = versions.lowerEntry(id);
                if (lowerRange == null) {
                    Version oldVersion = Version.fromId(id);
                    return oldVersion.toString();
                }
                lowerBound = ReleaseVersions.nextVersion((Version)ReleaseVersions.lastItem((List)lowerRange.getValue())).toString();
                Map.Entry upperRange = versions.higherEntry(id);
                upperBound = upperRange != null ? ((Version)((List)upperRange.getValue()).get(0)).toString() : "[" + id + "]";
            }
            return lowerBound.equals(upperBound) ? lowerBound : lowerBound + "-" + (String)upperBound;
        };
    }

    private static <T> T lastItem(List<T> list) {
        return list.get(list.size() - 1);
    }

    private static Version nextVersion(Version version) {
        return new Version(version.id + 100);
    }

    private static /* synthetic */ List lambda$generateVersionsLookup$2(Integer k, List v) {
        if (v.size() == 1) {
            return List.of((Version)v.get(0));
        }
        v.sort(Comparator.naturalOrder());
        return List.of((Version)v.get(0), (Version)v.get(v.size() - 1));
    }

    private static /* synthetic */ List lambda$generateVersionsLookup$1(Integer k) {
        return new ArrayList();
    }

    private static /* synthetic */ List lambda$generateVersionsLookup$0(Integer k) {
        return new ArrayList();
    }
}

