/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.enrich.action;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.enrich.EnrichPolicy;
import org.elasticsearch.xpack.core.enrich.action.GetEnrichPolicyAction;
import org.elasticsearch.xpack.enrich.EnrichStore;

public class TransportGetEnrichPolicyAction
extends TransportMasterNodeReadAction<GetEnrichPolicyAction.Request, GetEnrichPolicyAction.Response> {
    @Inject
    public TransportGetEnrichPolicyAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/xpack/enrich/get", transportService, clusterService, threadPool, actionFilters, GetEnrichPolicyAction.Request::new, indexNameExpressionResolver, GetEnrichPolicyAction.Response::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
    }

    protected void masterOperation(Task task, GetEnrichPolicyAction.Request request, ClusterState state, ActionListener<GetEnrichPolicyAction.Response> listener) throws Exception {
        Map<String, EnrichPolicy> policies;
        if (request.getNames() == null || request.getNames().isEmpty()) {
            policies = EnrichStore.getPolicies(state);
        } else {
            policies = new HashMap<String, EnrichPolicy>();
            for (String name : request.getNames()) {
                EnrichPolicy policy;
                if (name.isEmpty() || (policy = EnrichStore.getPolicy(name, state)) == null) continue;
                policies.put(name, policy);
            }
        }
        listener.onResponse((Object)new GetEnrichPolicyAction.Response(policies));
    }

    protected ClusterBlockException checkBlock(GetEnrichPolicyAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

