/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.user;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestRequestFilter;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.authc.support.Hasher;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.action.user.ChangePasswordRequestBuilder;
import org.elasticsearch.xpack.security.rest.action.user.NativeUserBaseRestHandler;

@ServerlessScope(value=Scope.INTERNAL)
public class RestChangePasswordAction
extends NativeUserBaseRestHandler
implements RestRequestFilter {
    private final SecurityContext securityContext;
    private final Hasher passwordHasher;
    private static final Set<String> FILTERED_FIELDS = Set.of("password", "password_hash");

    public RestChangePasswordAction(Settings settings, SecurityContext securityContext, XPackLicenseState licenseState) {
        super(settings, licenseState);
        this.securityContext = securityContext;
        this.passwordHasher = Hasher.resolve((String)((String)XPackSettings.PASSWORD_HASHING_ALGORITHM.get(settings)));
    }

    public List<RestHandler.Route> routes() {
        return List.of(RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.PUT, (String)"/_security/user/{username}/_password").replaces(RestRequest.Method.PUT, "/_xpack/security/user/{username}/_password", RestApiVersion.V_7).build(), RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.POST, (String)"/_security/user/{username}/_password").replaces(RestRequest.Method.POST, "/_xpack/security/user/{username}/_password", RestApiVersion.V_7).build(), RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.PUT, (String)"/_security/user/_password").replaces(RestRequest.Method.PUT, "/_xpack/security/user/_password", RestApiVersion.V_7).build(), RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.POST, (String)"/_security/user/_password").replaces(RestRequest.Method.POST, "/_xpack/security/user/_password", RestApiVersion.V_7).build());
    }

    public String getName() {
        return "security_change_password_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        User user = this.securityContext.getUser();
        String username = request.param("username") == null ? user.principal() : request.param("username");
        String refresh = request.param("refresh");
        BytesReference content = request.requiredContent();
        return channel -> ((ChangePasswordRequestBuilder)new ChangePasswordRequestBuilder((ElasticsearchClient)client).username(username).source(content, request.getXContentType(), this.passwordHasher).setRefreshPolicy(refresh)).execute((ActionListener)new RestBuilderListener<ActionResponse.Empty>(channel){

            public RestResponse buildResponse(ActionResponse.Empty response, XContentBuilder builder) throws Exception {
                return new RestResponse(RestStatus.OK, builder.startObject().endObject());
            }
        });
    }

    public Set<String> getFilteredFields() {
        return FILTERED_FIELDS;
    }
}

