/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.profile;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.time.Instant;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.hash.MessageDigests;
import org.elasticsearch.common.xcontent.ObjectParserHelper;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.security.action.profile.Profile;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.Subject;
import org.elasticsearch.xpack.core.security.user.User;

public record ProfileDocument(String uid, boolean enabled, long lastSynchronized, ProfileDocumentUser user, Map<String, Object> labels, BytesReference applicationData) implements ToXContentObject
{
    static final ConstructingObjectParser<ProfileDocumentUser, Void> PROFILE_DOC_USER_PARSER = new ConstructingObjectParser("user_profile_document_user", false, (args, v) -> new ProfileDocumentUser((String)args[0], (List)args[1], (Authentication.RealmRef)args[2], (String)args[3], (String)args[4]));
    static final ConstructingObjectParser<ProfileDocument, Void> PROFILE_DOC_PARSER = new ConstructingObjectParser("user_profile_document", false, (args, v) -> new ProfileDocument((String)args[0], (Boolean)args[1], (Long)args[2], (ProfileDocumentUser)args[3], (Map)args[4], (BytesReference)args[5]));
    static final ConstructingObjectParser<ProfileDocument, Void> PARSER = new ConstructingObjectParser("user_profile_document_container", true, (args, v) -> (ProfileDocument)args[0]);

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("uid", this.uid);
        builder.field("enabled", this.enabled);
        builder.field("last_synchronized", this.lastSynchronized);
        this.user.toXContent(builder, params);
        if (params.paramAsBoolean("include_labels", true) && this.labels != null) {
            builder.field("labels", this.labels);
        } else {
            builder.startObject("labels").endObject();
        }
        if (params.paramAsBoolean("include_data", true) && this.applicationData != null) {
            builder.field("application_data", (ToXContent)this.applicationData);
        } else {
            builder.startObject("application_data").endObject();
        }
        builder.endObject();
        return builder;
    }

    static ProfileDocument fromSubject(Subject subject) {
        String baseUid = ProfileDocument.computeBaseUidForSubject(subject);
        return ProfileDocument.fromSubjectWithUid(subject, baseUid + "_0");
    }

    static ProfileDocument fromSubjectWithUid(Subject subject, String uid) {
        assert (uid.startsWith(ProfileDocument.computeBaseUidForSubject(subject) + "_") || uid.startsWith("u_" + subject.getUser().principal() + "_"));
        User subjectUser = subject.getUser();
        return new ProfileDocument(uid, true, Instant.now().toEpochMilli(), new ProfileDocumentUser(subjectUser.principal(), Arrays.asList(subjectUser.roles()), subject.getRealm(), subjectUser.email(), subjectUser.fullName()), Map.of(), null);
    }

    static String computeBaseUidForSubject(Subject subject) {
        MessageDigest digest = MessageDigests.sha256();
        digest.update(subject.getUser().principal().getBytes(StandardCharsets.UTF_8));
        return "u_" + Base64.getUrlEncoder().withoutPadding().encodeToString(digest.digest());
    }

    public static ProfileDocument fromXContent(XContentParser parser) {
        return (ProfileDocument)PARSER.apply(parser, null);
    }

    static {
        PROFILE_DOC_USER_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("username", new String[0]));
        PROFILE_DOC_USER_PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), new ParseField("roles", new String[0]));
        PROFILE_DOC_USER_PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> (Authentication.RealmRef)Authentication.REALM_REF_PARSER.parse(p, c), new ParseField("realm", new String[0]));
        PROFILE_DOC_USER_PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), new ParseField("email", new String[0]));
        PROFILE_DOC_USER_PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), new ParseField("full_name", new String[0]));
        PROFILE_DOC_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("uid", new String[0]));
        PROFILE_DOC_PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), new ParseField("enabled", new String[0]));
        PROFILE_DOC_PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField("last_synchronized", new String[0]));
        PROFILE_DOC_PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> (ProfileDocumentUser)PROFILE_DOC_USER_PARSER.parse(p, null), new ParseField("user", new String[0]));
        PROFILE_DOC_PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.map(), new ParseField("labels", new String[0]));
        ObjectParserHelper.declareRawObject(PROFILE_DOC_PARSER, (BiConsumer)ConstructingObjectParser.constructorArg(), (ParseField)new ParseField("application_data", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> (ProfileDocument)PROFILE_DOC_PARSER.parse(p, null), new ParseField("user_profile", new String[0]));
    }

    public record ProfileDocumentUser(String username, List<String> roles, Authentication.RealmRef realm, String email, String fullName) implements ToXContent
    {
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject("user");
            builder.field("username", this.username);
            builder.field("roles", this.roles);
            builder.field("realm", (ToXContent)this.realm);
            builder.field("email", this.email);
            builder.field("full_name", this.fullName);
            builder.endObject();
            return builder;
        }

        public Profile.ProfileUser toProfileUser() {
            String domainName = this.realm.getDomain() != null ? this.realm.getDomain().name() : null;
            return new Profile.ProfileUser(this.username, this.roles, this.realm.getName(), domainName, this.email, this.fullName);
        }

        public Subject toSubject() {
            return new Subject(new User(this.username, (String[])this.roles.toArray(String[]::new), this.fullName, this.email, Map.of(), true), this.realm);
        }
    }
}

