/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rank.rrf;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.search.Explanation;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.rank.RankDoc;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public final class RRFRankDoc
extends RankDoc {
    static final String NAME = "rrf_rank_doc";
    public final int[] positions;
    public final float[] scores;
    public final int rankConstant;

    public RRFRankDoc(int doc, int shardIndex, int queryCount, int rankConstant) {
        super(doc, 0.0f, shardIndex);
        this.positions = new int[queryCount];
        Arrays.fill(this.positions, -1);
        this.scores = new float[queryCount];
        this.rankConstant = rankConstant;
    }

    public RRFRankDoc(StreamInput in) throws IOException {
        super(in);
        this.rank = in.readVInt();
        this.positions = in.readIntArray();
        this.scores = in.readFloatArray();
        this.rankConstant = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.RRF_QUERY_REWRITE) ? in.readVInt() : 60;
    }

    public Explanation explain(Explanation[] sources, String[] queryNames) {
        assert (sources.length == this.scores.length);
        int queries = this.positions.length;
        Explanation[] details = new Explanation[queries];
        for (int i = 0; i < queries; ++i) {
            String queryAlias = queryNames[i] == null ? "" : " [" + queryNames[i] + "]";
            String queryIdentifier = "at index [" + i + "]" + queryAlias;
            if (this.positions[i] == -1) {
                String description = "rrf score: [0], result not found in query " + queryIdentifier;
                details[i] = Explanation.noMatch((String)description, (Explanation[])new Explanation[0]);
                continue;
            }
            int rank = this.positions[i] + 1;
            float rrfScore = 1.0f / (float)(rank + this.rankConstant);
            details[i] = Explanation.match((Number)rank, (String)("rrf score: [" + rrfScore + "], for rank [" + rank + "] in query " + queryIdentifier + " computed as [1 / (" + rank + " + " + this.rankConstant + ")], for matching query with score"), (Explanation[])new Explanation[]{sources[i]});
        }
        return Explanation.match((Number)Float.valueOf(this.score), (String)("rrf score: [" + this.score + "] computed for initial ranks " + Arrays.toString(Arrays.stream(this.positions).map(x -> x + 1).toArray()) + " with rankConstant: [" + this.rankConstant + "] as sum of [1 / (rank + rankConstant)] for each query"), (Explanation[])details);
    }

    public void doWriteTo(StreamOutput out) throws IOException {
        out.writeVInt(this.rank);
        out.writeIntArray(this.positions);
        out.writeFloatArray(this.scores);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.RRF_QUERY_REWRITE)) {
            out.writeVInt(this.rankConstant);
        }
    }

    public boolean doEquals(RankDoc rd) {
        RRFRankDoc rrfrd = (RRFRankDoc)rd;
        return Arrays.equals(this.positions, rrfrd.positions) && Arrays.equals(this.scores, rrfrd.scores) && Objects.equals(this.rankConstant, rrfrd.rankConstant);
    }

    public int doHashCode() {
        int result = Arrays.hashCode(this.positions) + Objects.hash(this.rankConstant);
        result = 31 * result + Arrays.hashCode(this.scores);
        return result;
    }

    public String toString() {
        return "RRFRankDoc{rank=" + this.rank + ", positions=" + Arrays.toString(this.positions) + ", scores=" + Arrays.toString(this.scores) + ", score=" + this.score + ", doc=" + this.doc + ", shardIndex=" + this.shardIndex + ", rankConstant=" + this.rankConstant + "}";
    }

    public String getWriteableName() {
        return NAME;
    }

    protected void doToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("positions", (Object)this.positions);
        builder.field("scores", (Object)this.scores);
        builder.field("rankConstant", this.rankConstant);
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.RRF_QUERY_REWRITE;
    }
}

