/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation.table;

import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.aggregation.table.RowInTableLookup;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;

public final class AscendingSequenceRowInTableLookup
extends RowInTableLookup {
    private final BlockFactory blockFactory;
    private final int min;
    private final int max;

    public AscendingSequenceRowInTableLookup(BlockFactory blockFactory, int min, int max) {
        this.blockFactory = blockFactory;
        this.min = min;
        this.max = max;
    }

    @Override
    public ReleasableIterator<IntBlock> lookup(Page page, ByteSizeValue targetBlockSize) {
        IntBlock block = (IntBlock)page.getBlock(0);
        IntVector vector = block.asVector();
        int target = Math.toIntExact(targetBlockSize.getBytes());
        if (vector != null && vector.getPositionCount() * 4 < target) {
            return ReleasableIterator.single((Releasable)this.lookupVector(vector));
        }
        return new Lookup(block, target);
    }

    private IntBlock lookupVector(IntVector vector) {
        if (vector.min() >= this.min && vector.max() < this.max) {
            if (this.min == 0) {
                vector.incRef();
                return vector.asBlock();
            }
            return this.lookupVectorInRange(vector).asBlock();
        }
        return this.lookupVectorMaybeInRange(vector);
    }

    private IntVector lookupVectorInRange(IntVector vector) {
        try (IntVector.FixedBuilder builder = this.blockFactory.newIntVectorFixedBuilder(vector.getPositionCount());){
            for (int i = 0; i < vector.getPositionCount(); ++i) {
                builder.appendInt(i, vector.getInt(i) - this.min);
            }
            IntVector intVector = builder.build();
            return intVector;
        }
    }

    private IntBlock lookupVectorMaybeInRange(IntVector vector) {
        try (IntBlock.Builder builder = this.blockFactory.newIntBlockBuilder(vector.getPositionCount());){
            for (int i = 0; i < vector.getPositionCount(); ++i) {
                int v = vector.getInt(i);
                if (v < this.min || v >= this.max) {
                    builder.appendNull();
                    continue;
                }
                builder.appendInt(v - this.min);
            }
            IntBlock intBlock = builder.build();
            return intBlock;
        }
    }

    @Override
    public String toString() {
        return "AscendingSequence[" + this.min + "-" + this.max + "]";
    }

    public void close() {
    }

    private class Lookup
    implements ReleasableIterator<IntBlock> {
        private final IntBlock block;
        private final int target;
        int p;

        private Lookup(IntBlock block, int target) {
            this.block = block;
            this.target = target;
            block.incRef();
        }

        public boolean hasNext() {
            return this.p < this.block.getPositionCount();
        }

        public IntBlock next() {
            int initialEntries = Math.min(this.target / 4 / 2, this.block.getPositionCount() - this.p);
            try (IntBlock.Builder builder = AscendingSequenceRowInTableLookup.this.blockFactory.newIntBlockBuilder(initialEntries);){
                if (builder.estimatedBytes() > (long)this.target) {
                    throw new IllegalStateException("initial builder overshot target [" + builder.estimatedBytes() + "] vs [" + this.target + "]");
                }
                while (this.p < this.block.getPositionCount() && builder.estimatedBytes() < (long)this.target) {
                    int start = this.block.getFirstValueIndex(this.p);
                    int end = start + this.block.getValueCount(this.p);
                    int first = -1;
                    boolean started = false;
                    for (int i = start; i < end; ++i) {
                        int v = this.block.getInt(i);
                        if (v < AscendingSequenceRowInTableLookup.this.min || v >= AscendingSequenceRowInTableLookup.this.max) continue;
                        if (first < 0) {
                            first = v - AscendingSequenceRowInTableLookup.this.min;
                            continue;
                        }
                        if (!started) {
                            builder.beginPositionEntry();
                            builder.appendInt(first);
                            started = true;
                        }
                        builder.appendInt(v - AscendingSequenceRowInTableLookup.this.min);
                    }
                    ++this.p;
                    if (started) {
                        builder.endPositionEntry();
                        continue;
                    }
                    if (first < 0) {
                        builder.appendNull();
                        continue;
                    }
                    builder.appendInt(first);
                }
                IntBlock intBlock = builder.build();
                return intBlock;
            }
        }

        public void close() {
            this.block.decRef();
        }

        public String toString() {
            return "AscendingSequence[" + this.p + "/" + this.block.getPositionCount() + "]";
        }
    }
}

