/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation.blockhash;

import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BitArray;
import org.elasticsearch.common.util.LongLongHash;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.aggregation.blockhash.BlockHash;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.mvdedupe.LongLongBlockAdd;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;
import org.elasticsearch.core.Releasables;

final class LongLongBlockHash
extends BlockHash {
    private final int channel1;
    private final int channel2;
    private final int emitBatchSize;
    private final LongLongHash hash;

    LongLongBlockHash(BlockFactory blockFactory, int channel1, int channel2, int emitBatchSize) {
        super(blockFactory);
        this.channel1 = channel1;
        this.channel2 = channel2;
        this.emitBatchSize = emitBatchSize;
        this.hash = new LongLongHash(1L, blockFactory.bigArrays());
    }

    public void close() {
        Releasables.close((Releasable)this.hash);
    }

    @Override
    public void add(Page page, GroupingAggregatorFunction.AddInput addInput) {
        LongBlock block1 = (LongBlock)page.getBlock(this.channel1);
        LongBlock block2 = (LongBlock)page.getBlock(this.channel2);
        LongVector vector1 = block1.asVector();
        LongVector vector2 = block2.asVector();
        if (vector1 != null && vector2 != null) {
            try (IntBlock groupIds = this.add(vector1, vector2).asBlock();){
                addInput.add(0, groupIds.asVector());
            }
        }
        try (LongLongBlockAdd addBlock = new LongLongBlockAdd(this.blockFactory, this.emitBatchSize, addInput, this.hash, block1, block2);){
            addBlock.add();
        }
    }

    IntVector add(LongVector vector1, LongVector vector2) {
        int positions = vector1.getPositionCount();
        try (IntVector.FixedBuilder builder = this.blockFactory.newIntVectorFixedBuilder(positions);){
            for (int i = 0; i < positions; ++i) {
                builder.appendInt(i, Math.toIntExact(LongLongBlockHash.hashOrdToGroup(this.hash.add(vector1.getLong(i), vector2.getLong(i)))));
            }
            IntVector intVector = builder.build();
            return intVector;
        }
    }

    @Override
    public ReleasableIterator<IntBlock> lookup(Page page, ByteSizeValue targetBlockSize) {
        throw new UnsupportedOperationException("TODO");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Block[] getKeys() {
        int positions = (int)this.hash.size();
        LongVector k1 = null;
        LongVector k2 = null;
        try {
            try (LongVector.Builder keys1 = this.blockFactory.newLongVectorBuilder(positions);
                 LongVector.Builder keys2 = this.blockFactory.newLongVectorBuilder(positions);){
                for (long i = 0L; i < (long)positions; ++i) {
                    keys1.appendLong(this.hash.getKey1(i));
                    keys2.appendLong(this.hash.getKey2(i));
                }
                k1 = keys1.build();
                k2 = keys2.build();
            }
            if (k2 != null) return new Block[]{k1.asBlock(), k2.asBlock()};
        }
        catch (Throwable throwable) {
            if (k2 != null) throw throwable;
            Releasables.close(k1);
            throw throwable;
        }
        Releasables.close((Releasable)k1);
        return new Block[]{k1.asBlock(), k2.asBlock()};
    }

    @Override
    public IntVector nonEmpty() {
        return IntVector.range(0, Math.toIntExact(this.hash.size()), this.blockFactory);
    }

    @Override
    public BitArray seenGroupIds(BigArrays bigArrays) {
        return new SeenGroupIds.Range(0, Math.toIntExact(this.hash.size())).seenGroupIds(bigArrays);
    }

    public String toString() {
        return "LongLongBlockHash{channels=[" + this.channel1 + "," + this.channel2 + "], entries=" + this.hash.size() + "}";
    }
}

