/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.proto;

import java.util.Objects;

public class ColumnInfo {
    private final String table;
    private final String name;
    private final String esType;
    private final Integer displaySize;

    public ColumnInfo(String table, String name, String esType, Integer displaySize) {
        this.table = table;
        this.name = name;
        this.esType = esType;
        this.displaySize = displaySize;
    }

    public ColumnInfo(String table, String name, String esType) {
        this.table = table;
        this.name = name;
        this.esType = esType;
        this.displaySize = null;
    }

    public String table() {
        return this.table;
    }

    public String name() {
        return this.name;
    }

    public String esType() {
        return this.esType;
    }

    public Integer displaySize() {
        return this.displaySize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnInfo that = (ColumnInfo)o;
        return Objects.equals(this.displaySize, that.displaySize) && Objects.equals(this.table, that.table) && Objects.equals(this.name, that.name) && Objects.equals(this.esType, that.esType);
    }

    public int hashCode() {
        return Objects.hash(this.table, this.name, this.esType, this.displaySize);
    }

    public String toString() {
        return "ColumnInfo{table='" + this.table + "', name='" + this.name + "', esType='" + this.esType + "', displaySize=" + this.displaySize + '}';
    }
}

