/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.querydsl.query;

import java.util.Objects;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.tree.Source;

public class RegexQuery
extends Query {
    private final String field;
    private final String regex;
    private final boolean caseInsensitive;

    public RegexQuery(Source source, String field, String regex) {
        this(source, field, regex, false);
    }

    public RegexQuery(Source source, String field, String regex, boolean caseInsensitive) {
        super(source);
        this.field = field;
        this.regex = regex;
        this.caseInsensitive = caseInsensitive;
    }

    public String field() {
        return this.field;
    }

    public String regex() {
        return this.regex;
    }

    public Boolean caseInsensitive() {
        return this.caseInsensitive;
    }

    @Override
    public QueryBuilder asBuilder() {
        return QueryBuilders.regexpQuery((String)this.field, (String)this.regex).caseInsensitive(this.caseInsensitive);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field, this.regex, this.caseInsensitive);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RegexQuery other = (RegexQuery)obj;
        return Objects.equals(this.field, other.field) && Objects.equals(this.regex, other.regex) && this.caseInsensitive == other.caseInsensitive;
    }

    @Override
    protected String innerToString() {
        return this.field + "~ /" + this.regex + "/";
    }
}

