/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.server.cli;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.elasticsearch.cli.ProcessInfo;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.core.SuppressForbidden;

public class ServerProcessUtils {
    public static Path setupTempDir(ProcessInfo processInfo) throws UserException {
        Path path;
        String tmpDirOverride = (String)processInfo.envVars().get("ES_TMPDIR");
        if (tmpDirOverride != null) {
            path = Paths.get(tmpDirOverride, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                throw new UserException(78, "Temporary directory [" + String.valueOf(path) + "] does not exist or is not accessible");
            }
            if (!Files.isDirectory(path, new LinkOption[0])) {
                throw new UserException(78, "Temporary directory [" + String.valueOf(path) + "] is not a directory");
            }
        } else {
            try {
                if (((String)processInfo.sysprops().get("os.name")).startsWith("Windows")) {
                    path = Paths.get((String)processInfo.sysprops().get("java.io.tmpdir"), "elasticsearch");
                    Files.createDirectories(path, new FileAttribute[0]);
                } else {
                    path = ServerProcessUtils.createTempDirectory("elasticsearch-", new FileAttribute[0]);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return path;
    }

    @SuppressForbidden(reason="Files#createTempDirectory(String, FileAttribute...)")
    private static Path createTempDirectory(String prefix, FileAttribute<?> ... attrs) throws IOException {
        return Files.createTempDirectory(prefix, attrs);
    }
}

