/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.util;

import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.AssertMethod;

public final class Preconditions {
    private Preconditions() {
    }

    @AssertMethod
    public static void checkArgument(@UnknownKeyFor @NonNull @Initialized boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    @AssertMethod
    public static void checkArgument(@UnknownKeyFor @NonNull @Initialized boolean expression, @UnknownKeyFor @NonNull @Initialized Object errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
    }

    public static void checkArgument(@UnknownKeyFor @NonNull @Initialized boolean expression, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static void checkArgument(@UnknownKeyFor @NonNull @Initialized boolean b, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized char p1) {
        if (!b) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, Character.valueOf(p1)));
        }
    }

    public static void checkArgument(@UnknownKeyFor @NonNull @Initialized boolean b, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized int p1) {
        if (!b) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, p1));
        }
    }

    public static void checkArgument(@UnknownKeyFor @NonNull @Initialized boolean b, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized long p1) {
        if (!b) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, p1));
        }
    }

    public static void checkArgument(@UnknownKeyFor @NonNull @Initialized boolean b, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized Object p1) {
        if (!b) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, p1));
        }
    }

    public static void checkArgument(@UnknownKeyFor @NonNull @Initialized boolean b, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized char p1, @UnknownKeyFor @NonNull @Initialized char p2) {
        if (!b) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, Character.valueOf(p1), Character.valueOf(p2)));
        }
    }

    public static void checkArgument(@UnknownKeyFor @NonNull @Initialized boolean b, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized char p1, @UnknownKeyFor @NonNull @Initialized int p2) {
        if (!b) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, Character.valueOf(p1), p2));
        }
    }

    public static void checkArgument(@UnknownKeyFor @NonNull @Initialized boolean b, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized char p1, @UnknownKeyFor @NonNull @Initialized long p2) {
        if (!b) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, Character.valueOf(p1), p2));
        }
    }

    public static void checkArgument(@UnknownKeyFor @NonNull @Initialized boolean b, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized char p1, @UnknownKeyFor @NonNull @Initialized Object p2) {
        if (!b) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, Character.valueOf(p1), p2));
        }
    }

    public static void checkArgument(@UnknownKeyFor @NonNull @Initialized boolean b, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized int p1, @UnknownKeyFor @NonNull @Initialized char p2) {
        if (!b) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, p1, Character.valueOf(p2)));
        }
    }

    public static void checkArgument(@UnknownKeyFor @NonNull @Initialized boolean b, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized int p1, @UnknownKeyFor @NonNull @Initialized int p2) {
        if (!b) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkArgument(@UnknownKeyFor @NonNull @Initialized boolean b, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized int p1, @UnknownKeyFor @NonNull @Initialized long p2) {
        if (!b) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkArgument(@UnknownKeyFor @NonNull @Initialized boolean b, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized int p1, @UnknownKeyFor @NonNull @Initialized Object p2) {
        if (!b) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkArgument(@UnknownKeyFor @NonNull @Initialized boolean b, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized long p1, @UnknownKeyFor @NonNull @Initialized char p2) {
        if (!b) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, p1, Character.valueOf(p2)));
        }
    }

    public static void checkArgument(@UnknownKeyFor @NonNull @Initialized boolean b, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized long p1, @UnknownKeyFor @NonNull @Initialized int p2) {
        if (!b) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkArgument(@UnknownKeyFor @NonNull @Initialized boolean b, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized long p1, @UnknownKeyFor @NonNull @Initialized long p2) {
        if (!b) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkArgument(@UnknownKeyFor @NonNull @Initialized boolean b, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized long p1, @UnknownKeyFor @NonNull @Initialized Object p2) {
        if (!b) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkArgument(@UnknownKeyFor @NonNull @Initialized boolean b, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized Object p1, @UnknownKeyFor @NonNull @Initialized char p2) {
        if (!b) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, p1, Character.valueOf(p2)));
        }
    }

    public static void checkArgument(@UnknownKeyFor @NonNull @Initialized boolean b, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized Object p1, @UnknownKeyFor @NonNull @Initialized int p2) {
        if (!b) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkArgument(@UnknownKeyFor @NonNull @Initialized boolean b, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized Object p1, @UnknownKeyFor @NonNull @Initialized long p2) {
        if (!b) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkArgument(@UnknownKeyFor @NonNull @Initialized boolean b, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized Object p1, @UnknownKeyFor @NonNull @Initialized Object p2) {
        if (!b) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkArgument(@UnknownKeyFor @NonNull @Initialized boolean b, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized Object p1, @UnknownKeyFor @NonNull @Initialized Object p2, @UnknownKeyFor @NonNull @Initialized Object p3) {
        if (!b) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, p1, p2, p3));
        }
    }

    public static void checkArgument(@UnknownKeyFor @NonNull @Initialized boolean b, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized Object p1, @UnknownKeyFor @NonNull @Initialized Object p2, @UnknownKeyFor @NonNull @Initialized Object p3, @UnknownKeyFor @NonNull @Initialized Object p4) {
        if (!b) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, p1, p2, p3, p4));
        }
    }

    @AssertMethod
    public static void checkState(@UnknownKeyFor @NonNull @Initialized boolean expression) {
        if (!expression) {
            throw new IllegalStateException();
        }
    }

    @AssertMethod
    public static void checkState(@UnknownKeyFor @NonNull @Initialized boolean expression, @UnknownKeyFor @NonNull @Initialized Object errorMessage) {
        if (!expression) {
            throw new IllegalStateException(String.valueOf(errorMessage));
        }
    }

    public static void checkState(@UnknownKeyFor @NonNull @Initialized boolean expression, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static void checkState(@UnknownKeyFor @NonNull @Initialized boolean b, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized char p1) {
        if (!b) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, Character.valueOf(p1)));
        }
    }

    public static void checkState(@UnknownKeyFor @NonNull @Initialized boolean b, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized int p1) {
        if (!b) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, p1));
        }
    }

    public static void checkState(@UnknownKeyFor @NonNull @Initialized boolean b, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized long p1) {
        if (!b) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, p1));
        }
    }

    public static void checkState(@UnknownKeyFor @NonNull @Initialized boolean b, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized Object p1) {
        if (!b) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, p1));
        }
    }

    public static void checkState(@UnknownKeyFor @NonNull @Initialized boolean b, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized char p1, @UnknownKeyFor @NonNull @Initialized char p2) {
        if (!b) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, Character.valueOf(p1), Character.valueOf(p2)));
        }
    }

    public static void checkState(@UnknownKeyFor @NonNull @Initialized boolean b, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized char p1, @UnknownKeyFor @NonNull @Initialized int p2) {
        if (!b) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, Character.valueOf(p1), p2));
        }
    }

    public static void checkState(@UnknownKeyFor @NonNull @Initialized boolean b, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized char p1, @UnknownKeyFor @NonNull @Initialized long p2) {
        if (!b) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, Character.valueOf(p1), p2));
        }
    }

    public static void checkState(@UnknownKeyFor @NonNull @Initialized boolean b, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized char p1, @UnknownKeyFor @NonNull @Initialized Object p2) {
        if (!b) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, Character.valueOf(p1), p2));
        }
    }

    public static void checkState(@UnknownKeyFor @NonNull @Initialized boolean b, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized int p1, @UnknownKeyFor @NonNull @Initialized char p2) {
        if (!b) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, p1, Character.valueOf(p2)));
        }
    }

    public static void checkState(@UnknownKeyFor @NonNull @Initialized boolean b, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized int p1, @UnknownKeyFor @NonNull @Initialized int p2) {
        if (!b) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkState(@UnknownKeyFor @NonNull @Initialized boolean b, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized int p1, @UnknownKeyFor @NonNull @Initialized long p2) {
        if (!b) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkState(@UnknownKeyFor @NonNull @Initialized boolean b, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized int p1, @UnknownKeyFor @NonNull @Initialized Object p2) {
        if (!b) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkState(@UnknownKeyFor @NonNull @Initialized boolean b, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized long p1, @UnknownKeyFor @NonNull @Initialized char p2) {
        if (!b) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, p1, Character.valueOf(p2)));
        }
    }

    public static void checkState(@UnknownKeyFor @NonNull @Initialized boolean b, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized long p1, @UnknownKeyFor @NonNull @Initialized int p2) {
        if (!b) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkState(@UnknownKeyFor @NonNull @Initialized boolean b, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized long p1, @UnknownKeyFor @NonNull @Initialized long p2) {
        if (!b) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkState(@UnknownKeyFor @NonNull @Initialized boolean b, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized long p1, @UnknownKeyFor @NonNull @Initialized Object p2) {
        if (!b) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkState(@UnknownKeyFor @NonNull @Initialized boolean b, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized Object p1, @UnknownKeyFor @NonNull @Initialized char p2) {
        if (!b) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, p1, Character.valueOf(p2)));
        }
    }

    public static void checkState(@UnknownKeyFor @NonNull @Initialized boolean b, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized Object p1, @UnknownKeyFor @NonNull @Initialized int p2) {
        if (!b) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkState(@UnknownKeyFor @NonNull @Initialized boolean b, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized Object p1, @UnknownKeyFor @NonNull @Initialized long p2) {
        if (!b) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkState(@UnknownKeyFor @NonNull @Initialized boolean b, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized Object p1, @UnknownKeyFor @NonNull @Initialized Object p2) {
        if (!b) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
    }

    public static void checkState(@UnknownKeyFor @NonNull @Initialized boolean b, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized Object p1, @UnknownKeyFor @NonNull @Initialized Object p2, @UnknownKeyFor @NonNull @Initialized Object p3) {
        if (!b) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, p1, p2, p3));
        }
    }

    public static void checkState(@UnknownKeyFor @NonNull @Initialized boolean b, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized Object p1, @UnknownKeyFor @NonNull @Initialized Object p2, @UnknownKeyFor @NonNull @Initialized Object p3, @UnknownKeyFor @NonNull @Initialized Object p4) {
        if (!b) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, p1, p2, p3, p4));
        }
    }

    public static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    public static <T> T checkNotNull(T reference, @UnknownKeyFor @NonNull @Initialized Object errorMessage) {
        if (reference == null) {
            throw new NullPointerException(String.valueOf(errorMessage));
        }
        return reference;
    }

    public static <T> T checkNotNull(T reference, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, Object ... errorMessageArgs) {
        if (reference == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, errorMessageArgs));
        }
        return reference;
    }

    public static <T> T checkNotNull(T obj, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized char p1) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, Character.valueOf(p1)));
        }
        return obj;
    }

    public static <T> T checkNotNull(T obj, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized int p1) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, p1));
        }
        return obj;
    }

    public static <T> T checkNotNull(T obj, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized long p1) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, p1));
        }
        return obj;
    }

    public static <T> T checkNotNull(T obj, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized Object p1) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, p1));
        }
        return obj;
    }

    public static <T> T checkNotNull(T obj, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized char p1, @UnknownKeyFor @NonNull @Initialized char p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, Character.valueOf(p1), Character.valueOf(p2)));
        }
        return obj;
    }

    public static <T> T checkNotNull(T obj, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized char p1, @UnknownKeyFor @NonNull @Initialized int p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, Character.valueOf(p1), p2));
        }
        return obj;
    }

    public static <T> T checkNotNull(T obj, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized char p1, @UnknownKeyFor @NonNull @Initialized long p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, Character.valueOf(p1), p2));
        }
        return obj;
    }

    public static <T> T checkNotNull(T obj, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized char p1, @UnknownKeyFor @NonNull @Initialized Object p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, Character.valueOf(p1), p2));
        }
        return obj;
    }

    public static <T> T checkNotNull(T obj, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized int p1, @UnknownKeyFor @NonNull @Initialized char p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, p1, Character.valueOf(p2)));
        }
        return obj;
    }

    public static <T> T checkNotNull(T obj, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized int p1, @UnknownKeyFor @NonNull @Initialized int p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
        return obj;
    }

    public static <T> T checkNotNull(T obj, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized int p1, @UnknownKeyFor @NonNull @Initialized long p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
        return obj;
    }

    public static <T> T checkNotNull(T obj, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized int p1, @UnknownKeyFor @NonNull @Initialized Object p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
        return obj;
    }

    public static <T> T checkNotNull(T obj, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized long p1, @UnknownKeyFor @NonNull @Initialized char p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, p1, Character.valueOf(p2)));
        }
        return obj;
    }

    public static <T> T checkNotNull(T obj, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized long p1, @UnknownKeyFor @NonNull @Initialized int p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
        return obj;
    }

    public static <T> T checkNotNull(T obj, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized long p1, @UnknownKeyFor @NonNull @Initialized long p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
        return obj;
    }

    public static <T> T checkNotNull(T obj, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized long p1, @UnknownKeyFor @NonNull @Initialized Object p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
        return obj;
    }

    public static <T> T checkNotNull(T obj, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized Object p1, @UnknownKeyFor @NonNull @Initialized char p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, p1, Character.valueOf(p2)));
        }
        return obj;
    }

    public static <T> T checkNotNull(T obj, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized Object p1, @UnknownKeyFor @NonNull @Initialized int p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
        return obj;
    }

    public static <T> T checkNotNull(T obj, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized Object p1, @UnknownKeyFor @NonNull @Initialized long p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
        return obj;
    }

    public static <T> T checkNotNull(T obj, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized Object p1, @UnknownKeyFor @NonNull @Initialized Object p2) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, p1, p2));
        }
        return obj;
    }

    public static <T> T checkNotNull(T obj, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized Object p1, @UnknownKeyFor @NonNull @Initialized Object p2, @UnknownKeyFor @NonNull @Initialized Object p3) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, p1, p2, p3));
        }
        return obj;
    }

    public static <T> T checkNotNull(T obj, @UnknownKeyFor @NonNull @Initialized String errorMessageTemplate, @UnknownKeyFor @NonNull @Initialized Object p1, @UnknownKeyFor @NonNull @Initialized Object p2, @UnknownKeyFor @NonNull @Initialized Object p3, @UnknownKeyFor @NonNull @Initialized Object p4) {
        if (obj == null) {
            throw new NullPointerException(Preconditions.format(errorMessageTemplate, p1, p2, p3, p4));
        }
        return obj;
    }

    public static @UnknownKeyFor @NonNull @Initialized int checkElementIndex(@UnknownKeyFor @NonNull @Initialized int index, @UnknownKeyFor @NonNull @Initialized int size) {
        return Preconditions.checkElementIndex(index, size, "index");
    }

    public static @UnknownKeyFor @NonNull @Initialized int checkElementIndex(@UnknownKeyFor @NonNull @Initialized int index, @UnknownKeyFor @NonNull @Initialized int size, @UnknownKeyFor @NonNull @Initialized String desc) {
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException(Preconditions.badElementIndex(index, size, desc));
        }
        return index;
    }

    private static @UnknownKeyFor @NonNull @Initialized String badElementIndex(@UnknownKeyFor @NonNull @Initialized int index, @UnknownKeyFor @NonNull @Initialized int size, @UnknownKeyFor @NonNull @Initialized String desc) {
        if (index < 0) {
            return Preconditions.format("%s (%s) must not be negative", desc, index);
        }
        if (size < 0) {
            throw new IllegalArgumentException("negative size: " + size);
        }
        return Preconditions.format("%s (%s) must be less than size (%s)", desc, index, size);
    }

    public static @UnknownKeyFor @NonNull @Initialized long checkPositionIndex(@UnknownKeyFor @NonNull @Initialized long index, @UnknownKeyFor @NonNull @Initialized long size) {
        return Preconditions.checkPositionIndex(index, size, "index");
    }

    public static @UnknownKeyFor @NonNull @Initialized long checkPositionIndex(@UnknownKeyFor @NonNull @Initialized long index, @UnknownKeyFor @NonNull @Initialized long size, @UnknownKeyFor @NonNull @Initialized String desc) {
        if (index < 0L || index > size) {
            throw new IndexOutOfBoundsException(Preconditions.badPositionIndex(index, size, desc));
        }
        return index;
    }

    private static @UnknownKeyFor @NonNull @Initialized String badPositionIndex(@UnknownKeyFor @NonNull @Initialized long index, @UnknownKeyFor @NonNull @Initialized long size, @UnknownKeyFor @NonNull @Initialized String desc) {
        if (index < 0L) {
            return Preconditions.format("%s (%s) must not be negative", desc, index);
        }
        if (size < 0L) {
            throw new IllegalArgumentException("negative size: " + size);
        }
        return Preconditions.format("%s (%s) must not be greater than size (%s)", desc, index, size);
    }

    public static void checkPositionIndexes(@UnknownKeyFor @NonNull @Initialized int start, @UnknownKeyFor @NonNull @Initialized int end, @UnknownKeyFor @NonNull @Initialized int size) {
        if (start < 0 || end < start || end > size) {
            throw new IndexOutOfBoundsException(Preconditions.badPositionIndexes(start, end, size));
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized String badPositionIndexes(@UnknownKeyFor @NonNull @Initialized int start, @UnknownKeyFor @NonNull @Initialized int end, @UnknownKeyFor @NonNull @Initialized int size) {
        if (start < 0 || start > size) {
            return Preconditions.badPositionIndex(start, size, "start index");
        }
        if (end < 0 || end > size) {
            return Preconditions.badPositionIndex(end, size, "end index");
        }
        return Preconditions.format("end index (%s) must not be less than start index (%s)", end, start);
    }

    static @UnknownKeyFor @NonNull @Initialized String format(@UnknownKeyFor @NonNull @Initialized String template, Object ... args) {
        int placeholderStart;
        template = String.valueOf(template);
        StringBuilder builder = new StringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        int i = 0;
        while (i < args.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template, templateStart, placeholderStart);
            builder.append(args[i++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template, templateStart, template.length());
        if (i < args.length) {
            builder.append(" [");
            builder.append(args[i++]);
            while (i < args.length) {
                builder.append(", ");
                builder.append(args[i++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }
}

