/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class Collections2 {
    private Collections2() {
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized List<T> toList(@UnknownKeyFor @NonNull @Initialized Iterator<T> iterator) {
        ArrayList target = new ArrayList();
        iterator.forEachRemaining(target::add);
        return target;
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized List<T> toList(@UnknownKeyFor @NonNull @Initialized Iterable<T> iterable) {
        if (iterable instanceof Collection) {
            return new ArrayList((Collection)iterable);
        }
        return Collections2.toList(iterable.iterator());
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized List<T> toImmutableList(@UnknownKeyFor @NonNull @Initialized Iterable<T> iterable) {
        return Collections.unmodifiableList(Collections2.toList(iterable));
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized Map<K, V> immutableMapCopy(@UnknownKeyFor @NonNull @Initialized Map<K, V> map) {
        return Collections.unmodifiableMap(new HashMap<K, V>(map));
    }

    public static <V> @UnknownKeyFor @NonNull @Initialized List<V> immutableListCopy(@UnknownKeyFor @NonNull @Initialized List<V> list) {
        return Collections.unmodifiableList(new ArrayList<V>(list));
    }

    public static <V> @UnknownKeyFor @NonNull @Initialized List<V> asImmutableList(V ... values) {
        return Collections.unmodifiableList(Arrays.asList(values));
    }

    public static @UnknownKeyFor @NonNull @Initialized String toString(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> iterator) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).map(String::valueOf).collect(Collectors.joining(", ", "[", "]"));
    }
}

