/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory.util;

import java.util.Arrays;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class StackTrace {
    private final @Nullable @UnknownKeyFor @Initialized StackTraceElement @UnknownKeyFor @NonNull @Initialized [] stackTraceElements;

    public StackTrace() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        this.stackTraceElements = Arrays.copyOfRange(stack, 2, stack.length);
    }

    public void writeToBuilder(@UnknownKeyFor @NonNull @Initialized StringBuilder sb, @UnknownKeyFor @NonNull @Initialized int indent) {
        char[] indentation = new char[indent * 2];
        Arrays.fill(indentation, ' ');
        for (StackTraceElement ste : this.stackTraceElements) {
            if (ste == null) continue;
            sb.append(indentation).append("at ").append(ste.getClassName()).append('.').append(ste.getMethodName()).append('(').append(ste.getFileName()).append(':').append(Integer.toString(ste.getLineNumber())).append(")\n");
        }
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        StringBuilder sb = new StringBuilder();
        this.writeToBuilder(sb, 0);
        return sb.toString();
    }
}

