/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.entitlement.runtime.policy;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.entitlement.runtime.policy.Scope;

public class Policy {
    public final String name;
    public final List<Scope> scopes;

    public Policy(String name, List<Scope> scopes) {
        this.name = Objects.requireNonNull(name);
        this.scopes = Collections.unmodifiableList(Objects.requireNonNull(scopes));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Policy policy = (Policy)o;
        return Objects.equals(this.name, policy.name) && Objects.equals(this.scopes, policy.scopes);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.scopes);
    }

    public String toString() {
        return "Policy{name='" + this.name + "', scopes=" + String.valueOf(this.scopes) + "}";
    }
}

