/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.entitlement.instrumentation;

import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import java.util.Set;
import org.elasticsearch.entitlement.instrumentation.Instrumenter;

public class Transformer
implements ClassFileTransformer {
    private final Instrumenter instrumenter;
    private final Set<String> classesToTransform;

    public Transformer(Instrumenter instrumenter, Set<String> classesToTransform) {
        this.instrumenter = instrumenter;
        this.classesToTransform = classesToTransform;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        if (this.classesToTransform.contains(className)) {
            return this.instrumenter.instrumentClass(className, classfileBuffer);
        }
        return classfileBuffer;
    }
}

