#!/bin/sh

# panic: Assertion !(sb->sb_state & SBS_CANTRCVMORE) failed at ../../../kern/uipc_usrreq.c:1549
# cpuid = 6
# time = 1754809105
# KDB: stack backtrace:
# db_trace_self_wrapper() at db_trace_self_wrapper+0x2b/frame 0xfffffe0176ef6a80
# vpanic() at vpanic+0x136/frame 0xfffffe0176ef6bb0
# panic() at panic+0x43/frame 0xfffffe0176ef6c10
# uipc_soreceive_stream_or_seqpacket() at uipc_soreceive_stream_or_seqpacket+0x968/frame 0xfffffe0176ef6cd0
# soreceive() at soreceive+0x45/frame 0xfffffe0176ef6cf0
# kern_recvit() at kern_recvit+0x181/frame 0xfffffe0176ef6da0
# sys_recvmsg() at sys_recvmsg+0x67/frame 0xfffffe0176ef6e00
# amd64_syscall() at amd64_syscall+0x169/frame 0xfffffe0176ef6f30
# fast_syscall_common() at fast_syscall_common+0xf8/frame 0xfffffe0176ef6f30
# --- syscall (0, FreeBSD ELF64, syscall), rip = 0x821d3da8a, rsp = 0x824440f68, rbp = 0x824440f90 ---
# KDB: enter: panic
# [ thread pid 17448 tid 292963 ]
# Stopped at      kdb_enter+0x33: movq    $0,0x12304a2(%rip)
# db> x/s version
# version: FreeBSD 15.0-PRERELEASE #0 main-n279510-db7c0e32a05d-dirty: Sat Aug  9 17:21:54 CEST 2025
# pho@mercat1.netperf.freebsd.org:/usr/src/sys/amd64/compile/PHO
# db> 

[ `id -u ` -ne 0 ] && echo "Must be root!" && exit 1

. ../default.cfg
set -u
prog=$(basename "$0" .sh)
cat > /tmp/$prog.c <<EOF
// https://syzkaller.appspot.com/bug?id=79d6de939eb5c7de69e8e4993b6239aa0ae67335
// autogenerated by syzkaller (https://github.com/google/syzkaller)
// syzbot+ffcc3612ea266e36604e@syzkaller.appspotmail.com

#define _GNU_SOURCE

#include <sys/types.h>

#include <errno.h>
#include <pthread.h>
#include <pwd.h>
#include <signal.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/endian.h>
#include <sys/resource.h>
#include <sys/syscall.h>
#include <sys/wait.h>
#include <time.h>
#include <unistd.h>

static unsigned long long procid;

static void kill_and_wait(int pid, int* status)
{
  kill(pid, SIGKILL);
  while (waitpid(-1, status, 0) != pid) {
  }
}

static void sleep_ms(uint64_t ms)
{
  usleep(ms * 1000);
}

static uint64_t current_time_ms(void)
{
  struct timespec ts;
  if (clock_gettime(CLOCK_MONOTONIC, &ts))
    exit(1);
  return (uint64_t)ts.tv_sec * 1000 + (uint64_t)ts.tv_nsec / 1000000;
}

static void thread_start(void* (*fn)(void*), void* arg)
{
  pthread_t th;
  pthread_attr_t attr;
  pthread_attr_init(&attr);
  pthread_attr_setstacksize(&attr, 128 << 10);
  int i = 0;
  for (; i < 100; i++) {
    if (pthread_create(&th, &attr, fn, arg) == 0) {
      pthread_attr_destroy(&attr);
      return;
    }
    if (errno == EAGAIN) {
      usleep(50);
      continue;
    }
    break;
  }
  exit(1);
}

typedef struct {
  pthread_mutex_t mu;
  pthread_cond_t cv;
  int state;
} event_t;

static void event_init(event_t* ev)
{
  if (pthread_mutex_init(&ev->mu, 0))
    exit(1);
  if (pthread_cond_init(&ev->cv, 0))
    exit(1);
  ev->state = 0;
}

static void event_reset(event_t* ev)
{
  ev->state = 0;
}

static void event_set(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  if (ev->state)
    exit(1);
  ev->state = 1;
  pthread_mutex_unlock(&ev->mu);
  pthread_cond_broadcast(&ev->cv);
}

static void event_wait(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  while (!ev->state)
    pthread_cond_wait(&ev->cv, &ev->mu);
  pthread_mutex_unlock(&ev->mu);
}

static int event_isset(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  int res = ev->state;
  pthread_mutex_unlock(&ev->mu);
  return res;
}

static int event_timedwait(event_t* ev, uint64_t timeout)
{
  uint64_t start = current_time_ms();
  uint64_t now = start;
  pthread_mutex_lock(&ev->mu);
  for (;;) {
    if (ev->state)
      break;
    uint64_t remain = timeout - (now - start);
    struct timespec ts;
    ts.tv_sec = remain / 1000;
    ts.tv_nsec = (remain % 1000) * 1000 * 1000;
    pthread_cond_timedwait(&ev->cv, &ev->mu, &ts);
    now = current_time_ms();
    if (now - start > timeout)
      break;
  }
  int res = ev->state;
  pthread_mutex_unlock(&ev->mu);
  return res;
}

static void sandbox_common()
{
  struct rlimit rlim;
  rlim.rlim_cur = rlim.rlim_max = 128 << 20;
  setrlimit(RLIMIT_AS, &rlim);
  rlim.rlim_cur = rlim.rlim_max = 8 << 20;
  setrlimit(RLIMIT_MEMLOCK, &rlim);
  rlim.rlim_cur = rlim.rlim_max = 1 << 20;
  setrlimit(RLIMIT_FSIZE, &rlim);
  rlim.rlim_cur = rlim.rlim_max = 1 << 20;
  setrlimit(RLIMIT_STACK, &rlim);
  rlim.rlim_cur = rlim.rlim_max = 0;
  setrlimit(RLIMIT_CORE, &rlim);
  rlim.rlim_cur = rlim.rlim_max = 256;
  setrlimit(RLIMIT_NOFILE, &rlim);
}

static void loop();

static int do_sandbox_none(void)
{
  sandbox_common();
  loop();
  return 0;
}

struct thread_t {
  int created, call;
  event_t ready, done;
};

static struct thread_t threads[16];
static void execute_call(int call);
static int running;

static void* thr(void* arg)
{
  struct thread_t* th = (struct thread_t*)arg;
  for (;;) {
    event_wait(&th->ready);
    event_reset(&th->ready);
    execute_call(th->call);
    __atomic_fetch_sub(&running, 1, __ATOMIC_RELAXED);
    event_set(&th->done);
  }
  return 0;
}

static void execute_one(void)
{
  if (write(1, "executing program\n", sizeof("executing program\n") - 1)) {
  }
  int i, call, thread;
  for (call = 0; call < 4; call++) {
    for (thread = 0; thread < (int)(sizeof(threads) / sizeof(threads[0]));
         thread++) {
      struct thread_t* th = &threads[thread];
      if (!th->created) {
        th->created = 1;
        event_init(&th->ready);
        event_init(&th->done);
        event_set(&th->done);
        thread_start(thr, th);
      }
      if (!event_isset(&th->done))
        continue;
      event_reset(&th->done);
      th->call = call;
      __atomic_fetch_add(&running, 1, __ATOMIC_RELAXED);
      event_set(&th->ready);
      event_timedwait(&th->done, 50);
      break;
    }
  }
  for (i = 0; i < 100 && __atomic_load_n(&running, __ATOMIC_RELAXED); i++)
    sleep_ms(1);
}

static void execute_one(void);

#define WAIT_FLAGS 0

static void loop(void)
{
//  int iter = 0;
  for (;; /*iter++*/) {
    int pid = fork();
    if (pid < 0)
      exit(1);
    if (pid == 0) {
      execute_one();
      exit(0);
    }
    int status = 0;
    uint64_t start = current_time_ms();
    for (;;) {
      sleep_ms(10);
      if (waitpid(-1, &status, WNOHANG | WAIT_FLAGS) == pid)
        break;
      if (current_time_ms() - start < 5000)
        continue;
      kill_and_wait(pid, &status);
      break;
    }
  }
}

uint64_t r[2] = {0xffffffffffffffff, 0xffffffffffffffff};

void execute_call(int call)
{
  intptr_t res = 0;
  switch (call) {
  case 0:
    //  socketpair\$unix arguments: [
    //    domain: const = 0x1 (8 bytes)
    //    type: unix_socket_type = 0x5 (8 bytes)
    //    proto: const = 0x0 (1 bytes)
    //    fds: ptr[out, unix_pair] {
    //      unix_pair {
    //        fd0: sock_unix (resource)
    //        fd1: sock_unix (resource)
    //      }
    //    }
    //  ]
    res = syscall(SYS_socketpair, /*domain=*/1ul, /*type=SOCK_SEQPACKET*/ 5ul,
                  /*proto=*/0, /*fds=*/0x200000000440ul);
    if (res != -1) {
      r[0] = *(uint32_t*)0x200000000440;
      r[1] = *(uint32_t*)0x200000000444;
    }
    break;
  case 1:
    //  sendmsg arguments: [
    //    fd: sock (resource)
    //    msg: ptr[in, send_msghdr] {
    //      send_msghdr {
    //        msg_name: nil
    //        msg_namelen: len = 0x0 (4 bytes)
    //        pad = 0x0 (4 bytes)
    //        msg_iov: nil
    //        msg_iovlen: len = 0x0 (8 bytes)
    //        msg_control: ptr[inout, array[ANYUNION]] {
    //          array[ANYUNION] {
    //            union ANYUNION {
    //              ANYBLOB: buffer: {04 01 00 00 ff ff 00 00 01} (length 0x9)
    //            }
    //          }
    //        }
    //        msg_controllen: bytesize = 0x104 (8 bytes)
    //        msg_flags: const = 0x0 (4 bytes)
    //        pad = 0x0 (4 bytes)
    //      }
    //    }
    //    f: send_flags = 0x0 (8 bytes)
    //  ]
    *(uint64_t*)0x200000000000 = 0;
    *(uint32_t*)0x200000000008 = 0;
    *(uint64_t*)0x200000000010 = 0;
    *(uint64_t*)0x200000000018 = 0;
    *(uint64_t*)0x200000000020 = 0x2000000007c0;
    memcpy((void*)0x2000000007c0, "\x04\x01\x00\x00\xff\xff\x00\x00\x01", 9);
    *(uint64_t*)0x200000000028 = 0x104;
    *(uint32_t*)0x200000000030 = 0;
    syscall(SYS_sendmsg, /*fd=*/r[1], /*msg=*/0x200000000000ul, /*f=*/0ul);
    for (int i = 0; i < 32; i++) {
      syscall(SYS_sendmsg, /*fd=*/r[1], /*msg=*/0x200000000000ul, /*f=*/0ul);
    }
    break;
  case 2:
    //  close arguments: [
    //    fd: fd (resource)
    //  ]
    syscall(SYS_close, /*fd=*/r[1]);
    break;
  case 3:
    //  recvmsg arguments: [
    //    fd: sock (resource)
    //    msg: ptr[inout, recv_msghdr] {
    //      recv_msghdr {
    //        msg_name: nil
    //        msg_namelen: len = 0x0 (4 bytes)
    //        pad = 0x0 (4 bytes)
    //        msg_iov: nil
    //        msg_iovlen: len = 0x0 (8 bytes)
    //        msg_control: ptr[out, buffer] {
    //          buffer: (DirOut)
    //        }
    //        msg_controllen: len = 0x19 (8 bytes)
    //        msg_flags: const = 0x0 (4 bytes)
    //        pad = 0x0 (4 bytes)
    //      }
    //    }
    //    f: recv_flags = 0x80 (8 bytes)
    //  ]
    *(uint64_t*)0x2000000005c0 = 0;
    *(uint32_t*)0x2000000005c8 = 0;
    *(uint64_t*)0x2000000005d0 = 0;
    *(uint64_t*)0x2000000005d8 = 0;
    *(uint64_t*)0x2000000005e0 = 0x200000000580;
    *(uint64_t*)0x2000000005e8 = 0x19;
    *(uint32_t*)0x2000000005f0 = 0;
    syscall(SYS_recvmsg, /*fd=*/r[0], /*msg=*/0x2000000005c0ul,
            /*f=MSG_DONTWAIT*/ 0x80ul);
    break;
  }
}
int main(void)
{
  syscall(SYS_mmap, /*addr=*/0x200000000000ul, /*len=*/0x1000000ul,
          /*prot=PROT_WRITE|PROT_READ|PROT_EXEC*/ 7ul,
          /*flags=MAP_FIXED|MAP_ANONYMOUS|MAP_PRIVATE*/ 0x1012ul,
          /*fd=*/(intptr_t)-1, /*offset=*/0ul);
  const char* reason;
  (void)reason;
  for (procid = 0; procid < 4; procid++) {
    if (fork() == 0) {
      do_sandbox_none();
    }
  }
  sleep(1000000);
  return 0;
}
EOF
mycc -o /tmp/$prog -Wall -Wextra -O0 /tmp/$prog.c -pthread || exit 1

work=/tmp/$prog.dir
rm -rf $work
mkdir $work
cd /tmp/$prog.dir
kldstat | grep -q sctp || { kldload sctp.ko && loaded=1; }
timeout 3m /tmp/$prog > /dev/null 2>&1

rm -rf /tmp/$prog /tmp/$prog.c /tmp/$prog.core $work
[ $loaded ] && kldunload sctp.ko
exit 0
