/*
 *  Copyright (C) 2021 - This file is part of libecc project
 *
 *  Authors:
 *      Arnaud EBALARD <arnaud.ebalard@ssi.gouv.fr>
 *      Ryad BENADJILA <ryadbenadjila@gmail.com>
 *
 *  This software is licensed under a dual BSD and GPL v2 license.
 *  See LICENSE file at the root folder of the project.
 */
#include <libecc/lib_ecc_config.h>
#ifdef WITH_CURVE_SM2P256V1

#ifndef __EC_PARAMS_SM2P256V1_H__
#define __EC_PARAMS_SM2P256V1_H__
#include <libecc/curves/known/ec_params_external.h>

static const u8 sm2p256v1_p[] = {
        0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
};

TO_EC_STR_PARAM(sm2p256v1_p);

#define CURVE_SM2P256V1_P_BITLEN 256
static const u8 sm2p256v1_p_bitlen[] = {
	0x01, 0x00,
};

TO_EC_STR_PARAM(sm2p256v1_p_bitlen);

#if (WORD_BYTES == 8)     /* 64-bit words */
static const u8 sm2p256v1_r[] = {
        0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x01,
};

TO_EC_STR_PARAM(sm2p256v1_r);

static const u8 sm2p256v1_r_square[] = {
        0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
        0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
        0x02, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
        0x02, 0x00, 0x00, 0x00, 0x03,
};

TO_EC_STR_PARAM(sm2p256v1_r_square);

static const u8 sm2p256v1_mpinv[] = {
	0x01,
};

TO_EC_STR_PARAM(sm2p256v1_mpinv);

static const u8 sm2p256v1_p_shift[] = {
	0x00,
};

TO_EC_STR_PARAM(sm2p256v1_p_shift);

static const u8 sm2p256v1_p_normalized[] = {
        0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
};

TO_EC_STR_PARAM(sm2p256v1_p_normalized);

static const u8 sm2p256v1_p_reciprocal[] = {
        0x01, 0x00, 0x00, 0x00, 0x01,
};

TO_EC_STR_PARAM(sm2p256v1_p_reciprocal);

#elif (WORD_BYTES == 4)   /* 32-bit words */
static const u8 sm2p256v1_r[] = {
        0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x01,
};

TO_EC_STR_PARAM(sm2p256v1_r);

static const u8 sm2p256v1_r_square[] = {
        0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
        0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
        0x02, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
        0x02, 0x00, 0x00, 0x00, 0x03,
};

TO_EC_STR_PARAM(sm2p256v1_r_square);

static const u8 sm2p256v1_mpinv[] = {
	0x01,
};

TO_EC_STR_PARAM(sm2p256v1_mpinv);

static const u8 sm2p256v1_p_shift[] = {
	0x00,
};

TO_EC_STR_PARAM(sm2p256v1_p_shift);

static const u8 sm2p256v1_p_normalized[] = {
        0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
};

TO_EC_STR_PARAM(sm2p256v1_p_normalized);

static const u8 sm2p256v1_p_reciprocal[] = {
	0x01,
};

TO_EC_STR_PARAM(sm2p256v1_p_reciprocal);

#elif (WORD_BYTES == 2)   /* 16-bit words */
static const u8 sm2p256v1_r[] = {
        0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x01,
};

TO_EC_STR_PARAM(sm2p256v1_r);

static const u8 sm2p256v1_r_square[] = {
        0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
        0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
        0x02, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
        0x02, 0x00, 0x00, 0x00, 0x03,
};

TO_EC_STR_PARAM(sm2p256v1_r_square);

static const u8 sm2p256v1_mpinv[] = {
	0x01,
};

TO_EC_STR_PARAM(sm2p256v1_mpinv);

static const u8 sm2p256v1_p_shift[] = {
	0x00,
};

TO_EC_STR_PARAM(sm2p256v1_p_shift);

static const u8 sm2p256v1_p_normalized[] = {
        0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

};

TO_EC_STR_PARAM(sm2p256v1_p_normalized);

static const u8 sm2p256v1_p_reciprocal[] = {
	0x00,
};

TO_EC_STR_PARAM(sm2p256v1_p_reciprocal);

#else                     /* unknown word size */
#error "Unsupported word size"
#endif

static const u8 sm2p256v1_a[] = {
        0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
};

TO_EC_STR_PARAM(sm2p256v1_a);

static const u8 sm2p256v1_b[] = {
        0x28, 0xe9, 0xfa, 0x9e, 0x9d, 0x9f, 0x5e, 0x34,
        0x4d, 0x5a, 0x9e, 0x4b, 0xcf, 0x65, 0x09, 0xa7,
        0xf3, 0x97, 0x89, 0xf5, 0x15, 0xab, 0x8f, 0x92,
        0xdd, 0xbc, 0xbd, 0x41, 0x4d, 0x94, 0x0e, 0x93,
};

TO_EC_STR_PARAM(sm2p256v1_b);

#define CURVE_SM2P256V1_CURVE_ORDER_BITLEN 256
static const u8 sm2p256v1_curve_order[] = {
        0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0x72, 0x03, 0xdf, 0x6b, 0x21, 0xc6, 0x05, 0x2b,
        0x53, 0xbb, 0xf4, 0x09, 0x39, 0xd5, 0x41, 0x23,
};

TO_EC_STR_PARAM(sm2p256v1_curve_order);

static const u8 sm2p256v1_gx[] = {
        0x32, 0xc4, 0xae, 0x2c, 0x1f, 0x19, 0x81, 0x19,
        0x5f, 0x99, 0x04, 0x46, 0x6a, 0x39, 0xc9, 0x94,
        0x8f, 0xe3, 0x0b, 0xbf, 0xf2, 0x66, 0x0b, 0xe1,
        0x71, 0x5a, 0x45, 0x89, 0x33, 0x4c, 0x74, 0xc7,
};

TO_EC_STR_PARAM(sm2p256v1_gx);

static const u8 sm2p256v1_gy[] = {
        0xbc, 0x37, 0x36, 0xa2, 0xf4, 0xf6, 0x77, 0x9c,
        0x59, 0xbd, 0xce, 0xe3, 0x6b, 0x69, 0x21, 0x53,
        0xd0, 0xa9, 0x87, 0x7c, 0xc6, 0x2a, 0x47, 0x40,
        0x02, 0xdf, 0x32, 0xe5, 0x21, 0x39, 0xf0, 0xa0,
};

TO_EC_STR_PARAM(sm2p256v1_gy);

static const u8 sm2p256v1_gz[] = {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
};

TO_EC_STR_PARAM(sm2p256v1_gz);

static const u8 sm2p256v1_gen_order[] = {
        0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0x72, 0x03, 0xdf, 0x6b, 0x21, 0xc6, 0x05, 0x2b,
        0x53, 0xbb, 0xf4, 0x09, 0x39, 0xd5, 0x41, 0x23,
};

TO_EC_STR_PARAM(sm2p256v1_gen_order);

#define CURVE_SM2P256V1_Q_BITLEN 256
static const u8 sm2p256v1_gen_order_bitlen[] = {
	0x01, 0x00,
};

TO_EC_STR_PARAM(sm2p256v1_gen_order_bitlen);

static const u8 sm2p256v1_cofactor[] = {
	0x01,
};

TO_EC_STR_PARAM(sm2p256v1_cofactor);


static const u8 sm2p256v1_alpha_montgomery[] = {
        0x00,
};

TO_EC_STR_PARAM_FIXED_SIZE(sm2p256v1_alpha_montgomery, 0);

static const u8 sm2p256v1_gamma_montgomery[] = {
        0x00,
};

TO_EC_STR_PARAM_FIXED_SIZE(sm2p256v1_gamma_montgomery, 0);

static const u8 sm2p256v1_alpha_edwards[] = {
        0x00,
};

TO_EC_STR_PARAM_FIXED_SIZE(sm2p256v1_alpha_edwards, 0);


static const u8 sm2p256v1_name[] = "SM2P256V1";
TO_EC_STR_PARAM(sm2p256v1_name);

static const u8 sm2p256v1_oid[] = "1.2.156.10197.1.301";
TO_EC_STR_PARAM(sm2p256v1_oid);

static const ec_str_params sm2p256v1_str_params = {
	.p = &sm2p256v1_p_str_param,
	.p_bitlen = &sm2p256v1_p_bitlen_str_param,
	.r = &sm2p256v1_r_str_param,
	.r_square = &sm2p256v1_r_square_str_param,
	.mpinv = &sm2p256v1_mpinv_str_param,
	.p_shift = &sm2p256v1_p_shift_str_param,
	.p_normalized = &sm2p256v1_p_normalized_str_param,
	.p_reciprocal = &sm2p256v1_p_reciprocal_str_param,
	.a = &sm2p256v1_a_str_param,
	.b = &sm2p256v1_b_str_param,
	.curve_order = &sm2p256v1_curve_order_str_param,
	.gx = &sm2p256v1_gx_str_param,
	.gy = &sm2p256v1_gy_str_param,
	.gz = &sm2p256v1_gz_str_param,
	.gen_order = &sm2p256v1_gen_order_str_param,
	.gen_order_bitlen = &sm2p256v1_gen_order_bitlen_str_param,
	.cofactor = &sm2p256v1_cofactor_str_param,
        .alpha_montgomery = &sm2p256v1_alpha_montgomery_str_param,
        .gamma_montgomery = &sm2p256v1_gamma_montgomery_str_param,
        .alpha_edwards = &sm2p256v1_alpha_edwards_str_param,
	.oid = &sm2p256v1_oid_str_param,
	.name = &sm2p256v1_name_str_param,
};

/*
 * Compute max bit length of all curves for p and q
 */
#ifndef CURVES_MAX_P_BIT_LEN
#define CURVES_MAX_P_BIT_LEN    0
#endif
#if (CURVES_MAX_P_BIT_LEN < CURVE_SM2P256V1_P_BITLEN)
#undef CURVES_MAX_P_BIT_LEN
#define CURVES_MAX_P_BIT_LEN CURVE_SM2P256V1_P_BITLEN
#endif
#ifndef CURVES_MAX_Q_BIT_LEN
#define CURVES_MAX_Q_BIT_LEN    0
#endif
#if (CURVES_MAX_Q_BIT_LEN < CURVE_SM2P256V1_Q_BITLEN)
#undef CURVES_MAX_Q_BIT_LEN
#define CURVES_MAX_Q_BIT_LEN CURVE_SM2P256V1_Q_BITLEN
#endif
#ifndef CURVES_MAX_CURVE_ORDER_BIT_LEN
#define CURVES_MAX_CURVE_ORDER_BIT_LEN  0
#endif
#if (CURVES_MAX_CURVE_ORDER_BIT_LEN < CURVE_SM2P256V1_CURVE_ORDER_BITLEN)
#undef CURVES_MAX_CURVE_ORDER_BIT_LEN
#define CURVES_MAX_CURVE_ORDER_BIT_LEN CURVE_SM2P256V1_CURVE_ORDER_BITLEN
#endif

/*
 * Compute and adapt max name and oid length
 */
#ifndef MAX_CURVE_OID_LEN
#define MAX_CURVE_OID_LEN 0
#endif
#ifndef MAX_CURVE_NAME_LEN
#define MAX_CURVE_NAME_LEN 0
#endif
#if (MAX_CURVE_OID_LEN < 21)
#undef MAX_CURVE_OID_LEN
#define MAX_CURVE_OID_LEN 21
#endif
#if (MAX_CURVE_NAME_LEN < 10)
#undef MAX_CURVE_NAME_LEN
#define MAX_CURVE_NAME_LEN 10
#endif

#endif /* __EC_PARAMS_SM2P256V1_H__ */

#endif /* WITH_CURVE_SM2P256V1 */
