/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Communicator;
import Ice.Connection;
import Ice.Identity;
import Ice.LocatorPrx;
import Ice.RouterPrx;
import IceInternal.BasicStream;
import IceInternal.Endpoint;
import IceInternal.Instance;
import IceInternal.LocatorInfo;
import IceInternal.RouterInfo;
import IceUtil.CloneException;
import IceUtil.Debug;
import IceUtil.StringUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;

public abstract class Reference {
    private Instance _instance;
    private Communicator _communicator;
    private int _mode;
    private boolean _secure;
    private Identity _identity;
    private Hashtable _context;
    private static Hashtable _emptyContext = new Hashtable();
    private String _facet;
    private boolean _overrideTimeout;
    private int _timeout;
    protected int _hashValue;
    protected boolean _hashInitialized;

    public final int getMode() {
        return this._mode;
    }

    public final boolean getSecure() {
        return this._secure;
    }

    public final Identity getIdentity() {
        return this._identity;
    }

    public final String getFacet() {
        return this._facet;
    }

    public final Instance getInstance() {
        return this._instance;
    }

    public final Hashtable getContext() {
        return this._context;
    }

    public final Communicator getCommunicator() {
        return this._communicator;
    }

    public RouterInfo getRouterInfo() {
        return null;
    }

    public LocatorInfo getLocatorInfo() {
        return null;
    }

    public abstract Endpoint[] getEndpoints();

    public abstract String getAdapterId();

    public final Reference changeContext(Hashtable hashtable) {
        if (hashtable == null) {
            hashtable = _emptyContext;
        }
        Reference reference = this._instance.referenceFactory().copy(this);
        if (hashtable.isEmpty()) {
            reference._context = _emptyContext;
        } else {
            Hashtable hashtable2 = new Hashtable(hashtable.size());
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                hashtable2.put(k, hashtable.get(k));
            }
            reference._context = hashtable2;
        }
        return reference;
    }

    public final Reference changeMode(int n) {
        if (n == this._mode) {
            return this;
        }
        Reference reference = this._instance.referenceFactory().copy(this);
        reference._mode = n;
        return reference;
    }

    public final Reference changeSecure(boolean bl) {
        if (bl == this._secure) {
            return this;
        }
        Reference reference = this._instance.referenceFactory().copy(this);
        reference._secure = bl;
        return reference;
    }

    public final Reference changeIdentity(Identity identity) {
        if (identity.equals(this._identity)) {
            return this;
        }
        Reference reference = this._instance.referenceFactory().copy(this);
        try {
            reference._identity = (Identity)identity.ice_clone();
        }
        catch (CloneException cloneException) {
            // empty catch block
        }
        return reference;
    }

    public final Reference changeFacet(String string) {
        if (string.equals(this._facet)) {
            return this;
        }
        Reference reference = this._instance.referenceFactory().copy(this);
        reference._facet = string;
        return reference;
    }

    public Reference changeTimeout(int n) {
        if (this._overrideTimeout && this._timeout == n) {
            return this;
        }
        Reference reference = this.getInstance().referenceFactory().copy(this);
        reference._timeout = n;
        reference._overrideTimeout = true;
        return reference;
    }

    public abstract Reference changeAdapterId(String var1);

    public abstract Reference changeRouter(RouterPrx var1);

    public abstract Reference changeLocator(LocatorPrx var1);

    public synchronized int hashCode() {
        int n;
        if (this._hashInitialized) {
            return this._hashValue;
        }
        int n2 = this._mode;
        int n3 = this._identity.name.length();
        for (n = 0; n < n3; ++n) {
            n2 = 5 * n2 + this._identity.name.charAt(n);
        }
        n3 = this._identity.category.length();
        for (n = 0; n < n3; ++n) {
            n2 = 5 * n2 + this._identity.category.charAt(n);
        }
        n3 = this._facet.length();
        for (n = 0; n < n3; ++n) {
            n2 = 5 * n2 + this._facet.charAt(n);
        }
        this._hashValue = n2 = 5 * n2 + (this.getSecure() ? 1 : 0);
        this._hashInitialized = true;
        return n2;
    }

    public void streamWrite(BasicStream basicStream) {
        if (this._facet.length() == 0) {
            basicStream.writeStringSeq(null);
        } else {
            String[] stringArray = new String[]{this._facet};
            basicStream.writeStringSeq(stringArray);
        }
        basicStream.writeByte((byte)this._mode);
        basicStream.writeBool(this.getSecure());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this._instance.identityToString(this._identity);
        if (StringUtil.findFirstOf(string, " \t\n\r:@") != -1) {
            stringBuffer.append('\"');
            stringBuffer.append(string);
            stringBuffer.append('\"');
        } else {
            stringBuffer.append(string);
        }
        if (this._facet.length() > 0) {
            stringBuffer.append(" -f ");
            String string2 = StringUtil.escapeString(this._facet, "");
            if (StringUtil.findFirstOf(string2, " \t\n\r:@") != -1) {
                stringBuffer.append('\"');
                stringBuffer.append(string2);
                stringBuffer.append('\"');
            } else {
                stringBuffer.append(string2);
            }
        }
        switch (this._mode) {
            case 0: {
                stringBuffer.append(" -t");
                break;
            }
            case 1: {
                stringBuffer.append(" -o");
                break;
            }
            case 2: {
                stringBuffer.append(" -O");
                break;
            }
            case 3: {
                stringBuffer.append(" -d");
                break;
            }
            case 4: {
                stringBuffer.append(" -D");
            }
        }
        if (this.getSecure()) {
            stringBuffer.append(" -s");
        }
        return stringBuffer.toString();
    }

    public abstract Connection getConnection();

    public boolean equals(Object object) {
        Reference reference = (Reference)object;
        if (this._mode != reference._mode) {
            return false;
        }
        if (this._secure != reference._secure) {
            return false;
        }
        if (!this._identity.equals(reference._identity)) {
            return false;
        }
        if (!IceUtil.Hashtable.equals(this._context, reference._context)) {
            return false;
        }
        if (!this._facet.equals(reference._facet)) {
            return false;
        }
        if (this._overrideTimeout != reference._overrideTimeout) {
            return false;
        }
        return !this._overrideTimeout || this._timeout == reference._timeout;
    }

    protected void shallowCopy(Reference reference) {
        reference._instance = this._instance;
        reference._mode = this._mode;
        reference._identity = this._identity;
        reference._context = this._context;
        reference._facet = this._facet;
        reference._timeout = this._timeout;
        reference._overrideTimeout = this._overrideTimeout;
        reference._hashInitialized = false;
    }

    public Object ice_clone() {
        Debug.Assert(false);
        return null;
    }

    protected Reference() {
    }

    protected Reference(Instance instance, Communicator communicator, Identity identity, Hashtable hashtable, String string, int n, boolean bl) {
        this._instance = instance;
        this._communicator = communicator;
        this._mode = n;
        this._secure = bl;
        this._identity = identity;
        this._context = hashtable == null ? _emptyContext : hashtable;
        this._facet = string;
        this._overrideTimeout = false;
        this._timeout = -1;
        this._hashInitialized = false;
    }

    protected void applyOverrides(Endpoint[] endpointArray) {
        for (int i = 0; i < endpointArray.length; ++i) {
            if (!this._overrideTimeout) continue;
            endpointArray[i] = endpointArray[i].timeout(this._timeout);
        }
    }

    protected Endpoint[] filterEndpoints(Endpoint[] endpointArray) {
        int n;
        Vector<Endpoint> vector = new Vector<Endpoint>();
        for (n = 0; n < endpointArray.length; ++n) {
            if (endpointArray[n].unknown()) continue;
            vector.addElement(endpointArray[n]);
        }
        switch (this.getMode()) {
            case 0: 
            case 1: 
            case 2: {
                for (n = vector.size(); n > 0; --n) {
                    if (!((Endpoint)vector.elementAt(n - 1)).datagram()) continue;
                    vector.removeElementAt(n - 1);
                }
                break;
            }
            case 3: 
            case 4: {
                for (n = vector.size(); n > 0; --n) {
                    if (((Endpoint)vector.elementAt(n - 1)).datagram()) continue;
                    vector.removeElementAt(n - 1);
                }
                break;
            }
        }
        if (vector.size() > 1) {
            Vector vector2 = new Vector();
            vector2.setSize(vector.size());
            Random random = new Random();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                int n2;
                while (vector2.elementAt(n2 = Math.abs(random.nextInt() % vector.size())) != null) {
                }
                vector2.setElementAt(enumeration.nextElement(), n2);
            }
            vector = vector2;
        }
        if (vector.size() > 1) {
            Vector vector3 = new Vector();
            for (int i = vector.size(); i > 0; --i) {
                if (!((Endpoint)vector.elementAt(i - 1)).secure()) continue;
                vector3.addElement(vector.elementAt(i - 1));
                vector.removeElementAt(i - 1);
            }
            if (this.getSecure()) {
                vector = vector3;
            } else {
                Enumeration enumeration = vector3.elements();
                while (enumeration.hasMoreElements()) {
                    vector.addElement((Endpoint)enumeration.nextElement());
                }
            }
        } else if (vector.size() == 1) {
            Endpoint endpoint = (Endpoint)vector.elementAt(0);
            if (this.getSecure() && !endpoint.secure()) {
                vector.removeElementAt(0);
            }
        }
        Object[] objectArray = new Endpoint[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected boolean compare(Endpoint[] endpointArray, Endpoint[] endpointArray2) {
        if (endpointArray == endpointArray2) {
            return true;
        }
        if (endpointArray.length == endpointArray2.length) {
            for (int i = 0; i < endpointArray.length; ++i) {
                if (((Object)endpointArray[i]).equals(endpointArray2[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

