/*
 * Decompiled with CFR 0.152.
 */
package IceUtil;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedList;

public class OutputBase {
    protected PrintWriter _out;
    protected int _pos;
    protected int _indent;
    protected int _indentSize;
    protected LinkedList _indentSave = new LinkedList();
    protected boolean _useTab;
    protected boolean _separator;
    static final /* synthetic */ boolean $assertionsDisabled;

    public OutputBase() {
        this._out = null;
        this._pos = 0;
        this._indent = 0;
        this._indentSize = 4;
        this._useTab = true;
        this._separator = true;
    }

    public OutputBase(PrintWriter out) {
        this._out = out;
        this._pos = 0;
        this._indent = 0;
        this._indentSize = 4;
        this._useTab = true;
        this._separator = true;
    }

    public OutputBase(String s) {
        this._out = null;
        this._pos = 0;
        this._indent = 0;
        this._indentSize = 4;
        this._useTab = true;
        this._separator = true;
        this.open(s);
    }

    public void setIndent(int indentSize) {
        this._indentSize = indentSize;
    }

    public void setUseTab(boolean useTab) {
        this._useTab = useTab;
    }

    public void open(String s) {
        try {
            FileWriter fw = new FileWriter(s);
            BufferedWriter bw = new BufferedWriter(fw);
            this._out = new PrintWriter(bw);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void print(String s) {
        char[] arr = s.toCharArray();
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] == '\n') {
                this._pos = 0;
                continue;
            }
            ++this._pos;
        }
        this._out.print(s);
    }

    public void inc() {
        this._indent += this._indentSize;
    }

    public void dec() {
        if (!$assertionsDisabled && this._indent < this._indentSize) {
            throw new AssertionError();
        }
        this._indent -= this._indentSize;
    }

    public void useCurrentPosAsIndent() {
        this._indentSave.addFirst(new Integer(this._indent));
        this._indent = this._pos;
    }

    public void zeroIndent() {
        this._indentSave.addFirst(new Integer(this._indent));
        this._indent = 0;
    }

    public void restoreIndent() {
        if (!$assertionsDisabled && this._indentSave.isEmpty()) {
            throw new AssertionError();
        }
        this._indent = (Integer)this._indentSave.removeFirst();
    }

    public void nl() {
        this._out.println();
        this._pos = 0;
        this._separator = true;
        int indent = this._indent;
        if (this._useTab) {
            while (indent >= 8) {
                indent -= 8;
                this._out.print('\t');
                this._pos += 8;
            }
        } else {
            while (indent >= this._indentSize) {
                indent -= this._indentSize;
                this._out.print("    ");
                this._pos += this._indentSize;
            }
        }
        while (indent > 0) {
            --indent;
            this._out.print(' ');
            ++this._pos;
        }
        this._out.flush();
    }

    public void sp() {
        if (this._separator) {
            this._out.println();
        }
    }

    public boolean valid() {
        return this._out != null;
    }

    static {
        $assertionsDisabled = !OutputBase.class.desiredAssertionStatus();
    }
}

