/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.LocatorPrx;
import Ice.LocatorPrxHelper;
import IceInternal.LocatorInfo;
import IceInternal.LocatorTable;
import java.util.HashMap;
import java.util.Iterator;

public final class LocatorManager {
    private HashMap _table = new HashMap();
    private HashMap _locatorTables = new HashMap();

    LocatorManager() {
    }

    synchronized void destroy() {
        Iterator i = this._table.values().iterator();
        while (i.hasNext()) {
            LocatorInfo info = (LocatorInfo)i.next();
            info.destroy();
        }
        this._table.clear();
        this._locatorTables.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocatorInfo get(LocatorPrx loc) {
        if (loc == null) {
            return null;
        }
        LocatorPrx locator = LocatorPrxHelper.uncheckedCast(loc.ice_locator(null));
        LocatorManager locatorManager = this;
        synchronized (locatorManager) {
            LocatorInfo info = (LocatorInfo)this._table.get(locator);
            if (info == null) {
                LocatorTable table = (LocatorTable)this._locatorTables.get(locator.ice_getIdentity());
                if (table == null) {
                    table = new LocatorTable();
                    this._locatorTables.put(locator.ice_getIdentity(), table);
                }
                info = new LocatorInfo(locator, table);
                this._table.put(locator, info);
            }
            return info;
        }
    }
}

