/* sqlheavy-queryable.c generated by valac 0.12.1, the Vala compiler
 * generated from sqlheavy-queryable.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include "SQLHeavy.h"
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <stdio.h>

#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_mapped_file_unref0(var) ((var == NULL) ? NULL : (var = (g_mapped_file_unref (var), NULL)))



static SQLHeavyTransaction* sql_heavy_queryable_real_begin_transaction (SQLHeavyQueryable* self, GError** error);
static GHashTable* sql_heavy_queryable_va_list_to_hash_table (va_list args, GError** error);
static void _g_free0_ (gpointer var);
static void _vala_GValue_free (GValue* self);
static void __vala_GValue_free0_ (gpointer var);
static GValue* _g_value_dup (GValue* self);
void sql_heavy_query_set_list (SQLHeavyQuery* self, gboolean has_first_parameter, const gchar* first_parameter, va_list args, GError** error);
static void sql_heavy_queryable_run_internal (SQLHeavyQueryable* self, const gchar* sql, gssize max_len, GError** error);
static SQLHeavyQuery* sql_heavy_queryable_real_prepare (SQLHeavyQueryable* self, const gchar* sql, GError** error);
static void sql_heavy_queryable_real_run_script (SQLHeavyQueryable* self, const gchar* filename, GError** error);
static void sql_heavy_queryable_real_print_table (SQLHeavyQueryable* self, const gchar* sql, FILE* fd, GError** error);


/**
     * Lock the queryable and refuse to run any queries against it.
     *
     * @see unlock
     */
void sql_heavy_queryable_lock (SQLHeavyQueryable* self) {
	SQL_HEAVY_QUERYABLE_GET_INTERFACE (self)->lock (self);
}


/**
     * Unlock the queryable and allow queries to be run against it.
     *
     * @see lock
     */
void sql_heavy_queryable_unlock (SQLHeavyQueryable* self) {
	SQL_HEAVY_QUERYABLE_GET_INTERFACE (self)->unlock (self);
}


/**
     * Queue a query to be executed when the queryable is unlocked
     *
     * @param query the query to queue
     */
void sql_heavy_queryable_queue (SQLHeavyQueryable* self, SQLHeavyQuery* query, GError** error) {
	SQL_HEAVY_QUERYABLE_GET_INTERFACE (self)->queue (self, query, error);
}


/**
     * Begin a transaction. Will lock the queryable until the transaction is resolved.
     *
     * @return a new transaction
     */
static SQLHeavyTransaction* sql_heavy_queryable_real_begin_transaction (SQLHeavyQueryable* self, GError** error) {
	SQLHeavyTransaction* result = NULL;
	SQLHeavyTransaction* _tmp0_ = NULL;
	SQLHeavyTransaction* _tmp1_;
	GError * _inner_error_ = NULL;
	_tmp0_ = sql_heavy_transaction_new (self, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp1_;
	return result;
}


SQLHeavyTransaction* sql_heavy_queryable_begin_transaction (SQLHeavyQueryable* self, GError** error) {
	return SQL_HEAVY_QUERYABLE_GET_INTERFACE (self)->begin_transaction (self, error);
}


/**
     * Parse variadic arguments into a hash table
     *
     * @param args the list of arguments to parse
     */
static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


static void __vala_GValue_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL));
}


static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


static gpointer __g_value_dup0 (gpointer self) {
	return self ? _g_value_dup (self) : NULL;
}


static GHashTable* sql_heavy_queryable_va_list_to_hash_table (va_list args, GError** error) {
	GHashTable* result = NULL;
	GHashTable* _tmp0_ = NULL;
	GHashTable* parameters;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, __vala_GValue_free0_);
	parameters = _tmp0_;
	{
		const gchar* _tmp1_ = NULL;
		const gchar* current_parameter;
		_tmp1_ = va_arg (args, gchar*);
		current_parameter = _tmp1_;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				GType _tmp4_;
				GType gtype;
				GValue _tmp5_ = {0};
				GValue _tmp6_ = {0};
				GValue gval;
				gboolean _tmp7_ = FALSE;
				gchar* _tmp14_;
				GValue* _tmp15_;
				if (!_tmp2_) {
					const gchar* _tmp3_ = NULL;
					_tmp3_ = va_arg (args, gchar*);
					current_parameter = _tmp3_;
				}
				_tmp2_ = FALSE;
				if (!(current_parameter != NULL)) {
					break;
				}
				_tmp4_ = va_arg (args, GType);
				gtype = _tmp4_;
				g_value_init (&_tmp5_, gtype);
				_tmp6_ = _tmp5_;
				gval = _tmp6_;
				if (gtype == G_TYPE_INT64) {
					_tmp7_ = TRUE;
				} else {
					_tmp7_ = gtype == G_TYPE_INT;
				}
				if (_tmp7_) {
					gint64 _tmp8_;
					_tmp8_ = va_arg (args, gint64);
					g_value_set_int64 (&gval, _tmp8_);
				} else {
					if (gtype == G_TYPE_DOUBLE) {
						gdouble _tmp9_;
						_tmp9_ = va_arg (args, gdouble);
						g_value_set_double (&gval, _tmp9_);
					} else {
						if (gtype == G_TYPE_STRING) {
							const gchar* _tmp10_ = NULL;
							_tmp10_ = va_arg (args, gchar*);
							g_value_set_string (&gval, _tmp10_);
						} else {
							if (gtype == G_TYPE_BYTE_ARRAY) {
								void* _tmp11_ = NULL;
								_tmp11_ = va_arg (args, void*);
								g_value_set_boxed (&gval, _tmp11_);
							} else {
								if (gtype == G_TYPE_POINTER) {
									g_value_set_pointer (&gval, NULL);
								} else {
									const gchar* _tmp12_ = NULL;
									GError* _tmp13_ = NULL;
									_tmp12_ = g_type_name (gtype);
									_tmp13_ = g_error_new (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_DATA_TYPE, "Data type (`%s') unsupported.", _tmp12_);
									_inner_error_ = _tmp13_;
									if (_inner_error_->domain == SQL_HEAVY_ERROR) {
										g_propagate_error (error, _inner_error_);
										G_IS_VALUE (&gval) ? (g_value_unset (&gval), NULL) : NULL;
										_g_hash_table_unref0 (parameters);
										return NULL;
									} else {
										G_IS_VALUE (&gval) ? (g_value_unset (&gval), NULL) : NULL;
										_g_hash_table_unref0 (parameters);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return NULL;
									}
								}
							}
						}
					}
				}
				_tmp14_ = g_strdup (current_parameter);
				_tmp15_ = __g_value_dup0 (&gval);
				g_hash_table_replace (parameters, _tmp14_, _tmp15_);
				G_IS_VALUE (&gval) ? (g_value_unset (&gval), NULL) : NULL;
			}
		}
	}
	result = parameters;
	return result;
}


/**
     * Execute the supplied SQL
     *
     * This function accepts an arbitrary number of groups of
     * arguments for binding values. The first argument in the group
     * must be the name of the parameter to bind, the second a GType,
     * and the third the value.
     *
     * @param sql the SQL to execute
     * @return the result
     * @see Query.execute
     */
static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


SQLHeavyQueryResult* sql_heavy_queryable_execute (SQLHeavyQueryable* self, const gchar* sql, GError** error, ...) {
	SQLHeavyQueryResult* result = NULL;
	const gchar* s;
	va_list args;
	SQLHeavyQueryResult* _result_;
	GHashTable* parameters;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (sql != NULL, NULL);
	s = sql;
	va_start (args, sql);
	_result_ = NULL;
	parameters = NULL;
	{
		gchar* sp;
		sp = (gchar*) s;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				if (!_tmp0_) {
					sp++;
					s = (const gchar*) sp;
				}
				_tmp0_ = FALSE;
				if (!((*sp) != '\0')) {
					break;
				}
				_tmp1_ = g_ascii_isspace (*sp);
				if (!_tmp1_) {
					SQLHeavyQuery* query;
					SQLHeavyQuery* _tmp2_ = NULL;
					SQLHeavyQuery* _tmp3_;
					gint _tmp5_;
					gint param_count;
					SQLHeavyQueryResult* _tmp12_ = NULL;
					SQLHeavyQueryResult* _tmp13_;
					query = NULL;
					if (_result_ != NULL) {
						g_critical ("sqlheavy-queryable.vala:104: Executing multiple statements from Querya" \
"ble.execute is deprecated. Use Queryable.run.");
					}
					_tmp2_ = sql_heavy_query_new_full (self, (const gchar*) s, -1, &s, &_inner_error_);
					_tmp3_ = _tmp2_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == SQL_HEAVY_ERROR) {
							goto __catch21_sql_heavy_error;
						}
						_g_object_unref0 (query);
						_g_hash_table_unref0 (parameters);
						_g_object_unref0 (_result_);
						va_end (args);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
					_g_object_unref0 (query);
					query = _tmp3_;
					sp = ((gchar*) s) - 1;
					goto __finally21;
					__catch21_sql_heavy_error:
					{
						GError * e;
						e = _inner_error_;
						_inner_error_ = NULL;
						if (g_error_matches (e, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_NO_SQL)) {
							_g_error_free0 (e);
							_g_object_unref0 (query);
							break;
						} else {
							GError* _tmp4_;
							_tmp4_ = _g_error_copy0 (e);
							_inner_error_ = _tmp4_;
							_g_error_free0 (e);
							goto __finally21;
						}
						_g_error_free0 (e);
					}
					__finally21:
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == SQL_HEAVY_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (query);
							_g_hash_table_unref0 (parameters);
							_g_object_unref0 (_result_);
							va_end (args);
							return NULL;
						} else {
							_g_object_unref0 (query);
							_g_hash_table_unref0 (parameters);
							_g_object_unref0 (_result_);
							va_end (args);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp5_ = sql_heavy_query_get_parameter_count (query);
					param_count = _tmp5_;
					{
						gint p;
						p = 0;
						{
							gboolean _tmp6_;
							_tmp6_ = TRUE;
							while (TRUE) {
								const gchar* _tmp9_ = NULL;
								const gchar* name;
								gconstpointer _tmp10_ = NULL;
								GValue* value;
								if (!_tmp6_) {
									p++;
								}
								_tmp6_ = FALSE;
								if (!(p < param_count)) {
									break;
								}
								if (parameters == NULL) {
									GHashTable* _tmp7_ = NULL;
									GHashTable* _tmp8_;
									_tmp7_ = sql_heavy_queryable_va_list_to_hash_table (args, &_inner_error_);
									_tmp8_ = _tmp7_;
									if (_inner_error_ != NULL) {
										if (_inner_error_->domain == SQL_HEAVY_ERROR) {
											g_propagate_error (error, _inner_error_);
											_g_object_unref0 (query);
											_g_hash_table_unref0 (parameters);
											_g_object_unref0 (_result_);
											va_end (args);
											return NULL;
										} else {
											_g_object_unref0 (query);
											_g_hash_table_unref0 (parameters);
											_g_object_unref0 (_result_);
											va_end (args);
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return NULL;
										}
									}
									_g_hash_table_unref0 (parameters);
									parameters = _tmp8_;
								}
								_tmp9_ = sql_heavy_query_parameter_name (query, p + 1, &_inner_error_);
								name = _tmp9_;
								if (_inner_error_ != NULL) {
									if (_inner_error_->domain == SQL_HEAVY_ERROR) {
										g_propagate_error (error, _inner_error_);
										_g_object_unref0 (query);
										_g_hash_table_unref0 (parameters);
										_g_object_unref0 (_result_);
										va_end (args);
										return NULL;
									} else {
										_g_object_unref0 (query);
										_g_hash_table_unref0 (parameters);
										_g_object_unref0 (_result_);
										va_end (args);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return NULL;
									}
								}
								_tmp10_ = g_hash_table_lookup (parameters, name);
								value = (GValue*) _tmp10_;
								if (value == NULL) {
									GError* _tmp11_ = NULL;
									_tmp11_ = g_error_new (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_MISSING_PARAMETER, "Parameter `%s' left unbound", name);
									_inner_error_ = _tmp11_;
									if (_inner_error_->domain == SQL_HEAVY_ERROR) {
										g_propagate_error (error, _inner_error_);
										_g_object_unref0 (query);
										_g_hash_table_unref0 (parameters);
										_g_object_unref0 (_result_);
										va_end (args);
										return NULL;
									} else {
										_g_object_unref0 (query);
										_g_hash_table_unref0 (parameters);
										_g_object_unref0 (_result_);
										va_end (args);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return NULL;
									}
								}
								sql_heavy_query_set (query, name, value, &_inner_error_);
								if (_inner_error_ != NULL) {
									if (_inner_error_->domain == SQL_HEAVY_ERROR) {
										g_propagate_error (error, _inner_error_);
										_g_object_unref0 (query);
										_g_hash_table_unref0 (parameters);
										_g_object_unref0 (_result_);
										va_end (args);
										return NULL;
									} else {
										_g_object_unref0 (query);
										_g_hash_table_unref0 (parameters);
										_g_object_unref0 (_result_);
										va_end (args);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return NULL;
									}
								}
							}
						}
					}
					_tmp12_ = sql_heavy_query_execute (query, NULL, &_inner_error_, NULL);
					_tmp13_ = _tmp12_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == SQL_HEAVY_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (query);
							_g_hash_table_unref0 (parameters);
							_g_object_unref0 (_result_);
							va_end (args);
							return NULL;
						} else {
							_g_object_unref0 (query);
							_g_hash_table_unref0 (parameters);
							_g_object_unref0 (_result_);
							va_end (args);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_g_object_unref0 (_result_);
					_result_ = _tmp13_;
					_g_object_unref0 (query);
				}
			}
		}
	}
	result = _result_;
	_g_hash_table_unref0 (parameters);
	va_end (args);
	return result;
}


/**
     * Execute the supplied SQL, iterating through multiple statements
     * if necessary.
     *
     * This function accepts an arbitrary number of groups of
     * arguments for binding values. The first argument in the group
     * must be the name of the parameter to bind, the second a GType,
     * and the third the value.
     *
     * @param sql the SQL query to run
     * @see Query.execute
     */
void sql_heavy_queryable_run (SQLHeavyQueryable* self, const gchar* sql, GError** error, ...) {
	const gchar* s;
	va_list args;
	GHashTable* parameters;
	SQLHeavyTransaction* _tmp0_ = NULL;
	SQLHeavyTransaction* trans;
	GError * _inner_error_ = NULL;
	g_return_if_fail (sql != NULL);
	s = sql;
	va_start (args, sql);
	parameters = NULL;
	_tmp0_ = sql_heavy_queryable_begin_transaction (self, &_inner_error_);
	trans = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_hash_table_unref0 (parameters);
			va_end (args);
			return;
		} else {
			_g_hash_table_unref0 (parameters);
			va_end (args);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	{
		gchar* sp;
		sp = (gchar*) s;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_;
				if (!_tmp1_) {
					sp++;
					s = (const gchar*) sp;
				}
				_tmp1_ = FALSE;
				if (!((*sp) != '\0')) {
					break;
				}
				_tmp2_ = g_ascii_isspace (*sp);
				if (!_tmp2_) {
					SQLHeavyQuery* query;
					SQLHeavyQuery* _tmp3_ = NULL;
					SQLHeavyQuery* _tmp4_;
					gint _tmp6_;
					gint param_count;
					SQLHeavyQueryResult* _tmp13_ = NULL;
					SQLHeavyQueryResult* _tmp14_;
					query = NULL;
					_tmp3_ = sql_heavy_query_new_full ((SQLHeavyQueryable*) trans, (const gchar*) s, -1, &s, &_inner_error_);
					_tmp4_ = _tmp3_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == SQL_HEAVY_ERROR) {
							goto __catch22_sql_heavy_error;
						}
						_g_object_unref0 (query);
						_g_object_unref0 (trans);
						_g_hash_table_unref0 (parameters);
						va_end (args);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_g_object_unref0 (query);
					query = _tmp4_;
					sp = ((gchar*) s) - 1;
					goto __finally22;
					__catch22_sql_heavy_error:
					{
						GError * e;
						e = _inner_error_;
						_inner_error_ = NULL;
						if (g_error_matches (e, SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_NO_SQL)) {
							_g_error_free0 (e);
							_g_object_unref0 (query);
							break;
						} else {
							GError* _tmp5_;
							_tmp5_ = _g_error_copy0 (e);
							_inner_error_ = _tmp5_;
							_g_error_free0 (e);
							goto __finally22;
						}
						_g_error_free0 (e);
					}
					__finally22:
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == SQL_HEAVY_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (query);
							_g_object_unref0 (trans);
							_g_hash_table_unref0 (parameters);
							va_end (args);
							return;
						} else {
							_g_object_unref0 (query);
							_g_object_unref0 (trans);
							_g_hash_table_unref0 (parameters);
							va_end (args);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_tmp6_ = sql_heavy_query_get_parameter_count (query);
					param_count = _tmp6_;
					{
						gint p;
						p = 0;
						{
							gboolean _tmp7_;
							_tmp7_ = TRUE;
							while (TRUE) {
								const gchar* _tmp10_ = NULL;
								const gchar* name;
								gconstpointer _tmp11_ = NULL;
								GValue* value;
								if (!_tmp7_) {
									p++;
								}
								_tmp7_ = FALSE;
								if (!(p < param_count)) {
									break;
								}
								if (parameters == NULL) {
									GHashTable* _tmp8_ = NULL;
									GHashTable* _tmp9_;
									_tmp8_ = sql_heavy_queryable_va_list_to_hash_table (args, &_inner_error_);
									_tmp9_ = _tmp8_;
									if (_inner_error_ != NULL) {
										if (_inner_error_->domain == SQL_HEAVY_ERROR) {
											g_propagate_error (error, _inner_error_);
											_g_object_unref0 (query);
											_g_object_unref0 (trans);
											_g_hash_table_unref0 (parameters);
											va_end (args);
											return;
										} else {
											_g_object_unref0 (query);
											_g_object_unref0 (trans);
											_g_hash_table_unref0 (parameters);
											va_end (args);
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return;
										}
									}
									_g_hash_table_unref0 (parameters);
									parameters = _tmp9_;
								}
								_tmp10_ = sql_heavy_query_parameter_name (query, p + 1, &_inner_error_);
								name = _tmp10_;
								if (_inner_error_ != NULL) {
									if (_inner_error_->domain == SQL_HEAVY_ERROR) {
										g_propagate_error (error, _inner_error_);
										_g_object_unref0 (query);
										_g_object_unref0 (trans);
										_g_hash_table_unref0 (parameters);
										va_end (args);
										return;
									} else {
										_g_object_unref0 (query);
										_g_object_unref0 (trans);
										_g_hash_table_unref0 (parameters);
										va_end (args);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return;
									}
								}
								_tmp11_ = g_hash_table_lookup (parameters, name);
								value = (GValue*) _tmp11_;
								if (value == NULL) {
									GError* _tmp12_ = NULL;
									_tmp12_ = g_error_new (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_MISSING_PARAMETER, "Parameter `%s' left unbound", name);
									_inner_error_ = _tmp12_;
									if (_inner_error_->domain == SQL_HEAVY_ERROR) {
										g_propagate_error (error, _inner_error_);
										_g_object_unref0 (query);
										_g_object_unref0 (trans);
										_g_hash_table_unref0 (parameters);
										va_end (args);
										return;
									} else {
										_g_object_unref0 (query);
										_g_object_unref0 (trans);
										_g_hash_table_unref0 (parameters);
										va_end (args);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return;
									}
								}
								sql_heavy_query_set (query, name, value, &_inner_error_);
								if (_inner_error_ != NULL) {
									if (_inner_error_->domain == SQL_HEAVY_ERROR) {
										g_propagate_error (error, _inner_error_);
										_g_object_unref0 (query);
										_g_object_unref0 (trans);
										_g_hash_table_unref0 (parameters);
										va_end (args);
										return;
									} else {
										_g_object_unref0 (query);
										_g_object_unref0 (trans);
										_g_hash_table_unref0 (parameters);
										va_end (args);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return;
									}
								}
							}
						}
					}
					_tmp13_ = sql_heavy_query_execute (query, NULL, &_inner_error_, NULL);
					_tmp14_ = _tmp13_;
					_g_object_unref0 (_tmp14_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == SQL_HEAVY_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (query);
							_g_object_unref0 (trans);
							_g_hash_table_unref0 (parameters);
							va_end (args);
							return;
						} else {
							_g_object_unref0 (query);
							_g_object_unref0 (trans);
							_g_hash_table_unref0 (parameters);
							va_end (args);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_g_object_unref0 (query);
				}
			}
		}
	}
	sql_heavy_transaction_commit (trans, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (trans);
			_g_hash_table_unref0 (parameters);
			va_end (args);
			return;
		} else {
			_g_object_unref0 (trans);
			_g_hash_table_unref0 (parameters);
			va_end (args);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (trans);
	_g_hash_table_unref0 (parameters);
	va_end (args);
}


/**
     * Execute the supplied insert statement
     *
     * This function accepts an arbitrary number of groups of
     * arguments for binding values. The first argument in the group
     * must be the name of the parameter to bind, the second a GType,
     * and the third the value.
     *
     * @param sql an INSERT query
     * @return the inserted row ID
     * @see execute
     * @see Query.execute_insert
     */
gint64 sql_heavy_queryable_execute_insert (SQLHeavyQueryable* self, const gchar* sql, GError** error, ...) {
	gint64 result = 0LL;
	SQLHeavyQuery* _tmp0_ = NULL;
	SQLHeavyQuery* query;
	va_list args;
	gint64 _tmp1_;
	gint64 _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (sql != NULL, 0LL);
	_tmp0_ = sql_heavy_queryable_prepare (self, sql, &_inner_error_);
	query = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0LL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0LL;
		}
	}
	va_start (args, sql);
	sql_heavy_query_set_list (query, FALSE, NULL, args, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			va_end (args);
			_g_object_unref0 (query);
			return 0LL;
		} else {
			va_end (args);
			_g_object_unref0 (query);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0LL;
		}
	}
	_tmp1_ = sql_heavy_query_execute_insert (query, NULL, &_inner_error_, NULL);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			va_end (args);
			_g_object_unref0 (query);
			return 0LL;
		} else {
			va_end (args);
			_g_object_unref0 (query);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0LL;
		}
	}
	result = _tmp2_;
	va_end (args);
	_g_object_unref0 (query);
	return result;
}


/**
     * Execute the supplied SQL, iterating through multiple statements if necessary.
     *
     * @param sql An SQL query.
     * @param max_len the maximum length of the query, or -1 to use strlen (sql)
     */
static void sql_heavy_queryable_run_internal (SQLHeavyQueryable* self, const gchar* sql, gssize max_len, GError** error) {
	const gchar* s;
	GError * _inner_error_ = NULL;
	g_return_if_fail (sql != NULL);
	s = sql;
	{
		gssize _tmp0_ = 0L;
		gsize current_max;
		if (max_len < 0) {
			gint _tmp1_;
			_tmp1_ = strlen (s);
			_tmp0_ = (gssize) _tmp1_;
		} else {
			_tmp0_ = max_len;
		}
		current_max = (gsize) _tmp0_;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_ = FALSE;
				gchar* os;
				if (!_tmp2_) {
				}
				_tmp2_ = FALSE;
				if (s != NULL) {
					_tmp3_ = current_max > 0;
				} else {
					_tmp3_ = FALSE;
				}
				if (!_tmp3_) {
					break;
				}
				os = (gchar*) s;
				{
					SQLHeavyQuery* _tmp4_ = NULL;
					SQLHeavyQuery* _tmp5_;
					SQLHeavyQuery* _tmp6_;
					SQLHeavyQueryResult* _tmp7_ = NULL;
					SQLHeavyQueryResult* _tmp8_;
					_tmp4_ = sql_heavy_query_new_full (self, (const gchar*) s, (gint) current_max, &s, &_inner_error_);
					_tmp5_ = _tmp4_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == SQL_HEAVY_ERROR) {
							g_propagate_error (error, _inner_error_);
							return;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_tmp6_ = _tmp5_;
					_tmp7_ = sql_heavy_query_execute (_tmp6_, NULL, &_inner_error_, NULL);
					_tmp8_ = _tmp7_;
					_g_object_unref0 (_tmp8_);
					_g_object_unref0 (_tmp6_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == SQL_HEAVY_ERROR) {
							g_propagate_error (error, _inner_error_);
							return;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
				}
				current_max = current_max - (((gchar*) s) - os);
				{
					gchar* sp;
					sp = (gchar*) s;
					{
						gboolean _tmp9_;
						_tmp9_ = TRUE;
						while (TRUE) {
							gboolean _tmp10_;
							if (!_tmp9_) {
								current_max--;
								sp++;
								s = (const gchar*) sp;
							}
							_tmp9_ = FALSE;
							if (!(current_max > 0)) {
								break;
							}
							_tmp10_ = g_ascii_isspace (*sp);
							if (!_tmp10_) {
								break;
							}
						}
					}
				}
			}
		}
	}
}


/**
     * Create a prepared statement.
     *
     * @param sql An SQL query.
     * @return a new statement
     */
static SQLHeavyQuery* sql_heavy_queryable_real_prepare (SQLHeavyQueryable* self, const gchar* sql, GError** error) {
	SQLHeavyQuery* result = NULL;
	SQLHeavyQuery* _tmp0_ = NULL;
	SQLHeavyQuery* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (sql != NULL, NULL);
	_tmp0_ = sql_heavy_query_new (self, sql, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp1_;
	return result;
}


SQLHeavyQuery* sql_heavy_queryable_prepare (SQLHeavyQueryable* self, const gchar* sql, GError** error) {
	return SQL_HEAVY_QUERYABLE_GET_INTERFACE (self)->prepare (self, sql, error);
}


/**
     * Runs an SQL script located in a file
     *
     * @param filename the location of the script
     */
static void sql_heavy_queryable_real_run_script (SQLHeavyQueryable* self, const gchar* filename, GError** error) {
	GMappedFile* _tmp0_ = NULL;
	GMappedFile* file;
	SQLHeavyTransaction* _tmp1_ = NULL;
	SQLHeavyTransaction* trans;
	gchar* _tmp2_ = NULL;
	gsize _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (filename != NULL);
	_tmp0_ = g_mapped_file_new (filename, FALSE, &_inner_error_);
	file = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_FILE_ERROR) {
			goto __catch23_g_file_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp1_ = sql_heavy_queryable_begin_transaction (self, &_inner_error_);
	trans = _tmp1_;
	if (_inner_error_ != NULL) {
		_g_mapped_file_unref0 (file);
		if (_inner_error_->domain == G_FILE_ERROR) {
			goto __catch23_g_file_error;
		}
		goto __finally23;
	}
	_tmp2_ = g_mapped_file_get_contents (file);
	_tmp3_ = g_mapped_file_get_length (file);
	sql_heavy_queryable_run_internal ((SQLHeavyQueryable*) trans, (const gchar*) _tmp2_, (gssize) _tmp3_, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (trans);
		_g_mapped_file_unref0 (file);
		if (_inner_error_->domain == G_FILE_ERROR) {
			goto __catch23_g_file_error;
		}
		goto __finally23;
	}
	sql_heavy_transaction_commit (trans, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (trans);
		_g_mapped_file_unref0 (file);
		if (_inner_error_->domain == G_FILE_ERROR) {
			goto __catch23_g_file_error;
		}
		goto __finally23;
	}
	_g_object_unref0 (trans);
	_g_mapped_file_unref0 (file);
	goto __finally23;
	__catch23_g_file_error:
	{
		GError * e;
		GError* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = g_error_new (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_IO, "Unable to open script: %s (%d).", e->message, e->code);
		_inner_error_ = _tmp4_;
		_g_error_free0 (e);
		goto __finally23;
	}
	__finally23:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void sql_heavy_queryable_run_script (SQLHeavyQueryable* self, const gchar* filename, GError** error) {
	SQL_HEAVY_QUERYABLE_GET_INTERFACE (self)->run_script (self, filename, error);
}


/**
     * Print the result set to a file stream
     *
     * @param sql the query
     * @param fd the stream to print to
     * @see Queryable.print_table
     */
static void sql_heavy_queryable_real_print_table (SQLHeavyQueryable* self, const gchar* sql, FILE* fd, GError** error) {
	SQLHeavyQuery* _tmp0_ = NULL;
	SQLHeavyQuery* _tmp1_;
	SQLHeavyQuery* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (sql != NULL);
	_tmp0_ = sql_heavy_queryable_prepare (self, sql, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp2_ = _tmp1_;
	sql_heavy_query_print_table (_tmp2_, NULL, &_inner_error_);
	_g_object_unref0 (_tmp2_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void sql_heavy_queryable_print_table (SQLHeavyQueryable* self, const gchar* sql, FILE* fd, GError** error) {
	SQL_HEAVY_QUERYABLE_GET_INTERFACE (self)->print_table (self, sql, fd, error);
}


SQLHeavyDatabase* sql_heavy_queryable_get_database (SQLHeavyQueryable* self) {
	return SQL_HEAVY_QUERYABLE_GET_INTERFACE (self)->get_database (self);
}


static void sql_heavy_queryable_base_init (SQLHeavyQueryableIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		/**
		     * Database
		     */
		g_object_interface_install_property (iface, g_param_spec_object ("database", "database", "database", SQL_HEAVY_TYPE_DATABASE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		/**
		     * Signal which is emitted when a query finished executing.
		     *
		     * @param query the query which was executed
		     * @see Database.sql_executed
		     */
		g_signal_new ("query_executed", SQL_HEAVY_TYPE_QUERYABLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, SQL_HEAVY_TYPE_QUERY);
		iface->begin_transaction = sql_heavy_queryable_real_begin_transaction;
		iface->prepare = sql_heavy_queryable_real_prepare;
		iface->run_script = sql_heavy_queryable_real_run_script;
		iface->print_table = sql_heavy_queryable_real_print_table;
	}
}


/**
   * Interface on which queries may be run
   */
GType sql_heavy_queryable_get_type (void) {
	static volatile gsize sql_heavy_queryable_type_id__volatile = 0;
	if (g_once_init_enter (&sql_heavy_queryable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SQLHeavyQueryableIface), (GBaseInitFunc) sql_heavy_queryable_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType sql_heavy_queryable_type_id;
		sql_heavy_queryable_type_id = g_type_register_static (G_TYPE_INTERFACE, "SQLHeavyQueryable", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (sql_heavy_queryable_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&sql_heavy_queryable_type_id__volatile, sql_heavy_queryable_type_id);
	}
	return sql_heavy_queryable_type_id__volatile;
}



