/* vim:set noet ts=4: */
/** 
 * scim-python
 * 
 * Copyright (c) 2007-2008 Huang Peng <shawn.p.huang@gmail.com>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 *
 * $Id: $
 */
#ifndef __SCIM_PYTHON_HELPER_H_
#define __SCIM_PYTHON_HELPER_H_
#define Uses_SCIM_HELPER
#define Uses_SCIM_CONFIG_BASE
#include <Python.h>
#include <scim.h>

using namespace scim;

struct PyHelperAgentObject;

class PyHelperAgent : public HelperAgent {
private:
	PyHelperAgentObject *self;

private:
	PyHelperAgent (PyObject *self);
	virtual ~PyHelperAgent ();

public:
	//Wrapper functions for HelperAgent class
	static PyObject *py_open_connection		(PyHelperAgentObject		*self, 
											 PyObject					*args);
	static PyObject *py_close_connection	(PyHelperAgentObject		*self, 
											 PyObject					*args);
	static PyObject *py_get_connection_number	
											(PyHelperAgentObject		*self, 
											 PyObject					*args);
	static PyObject *py_is_connected		(PyHelperAgentObject		*self, 
											 PyObject					*args);
	static PyObject *py_has_pending_event	(PyHelperAgentObject		*self, 
											 PyObject					*args);
	static PyObject *py_filter_event		(PyHelperAgentObject		*self, 
											 PyObject					*args);
	static PyObject *py_reload_config		(PyHelperAgentObject		*self, 
											 PyObject					*args);
	static PyObject *py_register_properties	(PyHelperAgentObject		*self, 
											 PyObject					*args);
	static PyObject *py_update_property		(PyHelperAgentObject		*self, 
											 PyObject					*args);
	static PyObject *py_send_imengine_event	(PyHelperAgentObject		*self, 
											 PyObject					*args);
	static PyObject *py_send_key_event		(PyHelperAgentObject		*self, 
											 PyObject					*args);
	static PyObject *py_forward_key_event	(PyHelperAgentObject		*self, 
											 PyObject					*args);
	static PyObject *py_commit_string		(PyHelperAgentObject		*self, 
											 PyObject					*args);
private:
	// Slots for HelperAgent
	void slot_exit							(const HelperAgent *helper, int ic, const String &ic_uuid);
	void slot_attach_input_context			(const HelperAgent *helper, int ic, const String &ic_uuid);
	void slot_detach_input_context			(const HelperAgent *helper, int ic, const String &ic_uuid);
	void slot_reload_config					(const HelperAgent *helper, int ic, const String &ic_uuid);
	void slot_update_screen					(const HelperAgent *helper, int ic, const String &ic_uuid, int screen_number);
	void slot_update_spot_location			(const HelperAgent *helper, int ic, const String &ic_uuid, int x, int y);
	void slot_trigger_property				(const HelperAgent *helper, int ic, const String &ic_uuid, const String &property);
	void slot_process_imengine_event		(const HelperAgent *helper, int ic, const String &ic_uuid, const Transaction &transaction);

	// Connections for slots
	Connection exit_signal_connection;
	Connection attach_input_context_signal_connection;
	Connection detach_input_context_signal_connection;
	Connection reload_config_signal_connection;
	Connection update_screen_signal_connection;
	Connection update_spot_location_signal_connection;
	Connection trigger_property_connection;
	Connection process_imengine_event_connection;


public:
	// Functions for PyObject
	static PyObject *py_new					(PyTypeObject				*type,
											 PyObject					*args,
											 PyObject					*kwds);
	static int py_init						(PyHelperAgentObject		*self,
											 PyObject					*args,
											 PyObject					*kwds);
	static void py_dealloc					(PyHelperAgentObject	 	*self);
	static HelperAgent *from_pyobject
											(PyObject					*object);

	static PyMethodDef py_methods[];

	static void operator delete 			(void						*p);

};

void init_helper (PyObject *module);

#endif /*__SCIM_PYTHON_HELPER_H_*/
