#ifndef VISUAL_PLATLINUX_H
#define VISUAL_PLATLINUX_H

// Copyright (c) 2000, 2001, 2002, 2003 by David Scherer and others.
// See the file license.txt for complete license terms.
// See the file authors.txt for a complete list of contributors.

#include <glib.h>
#include "platform.h"
#include <pthread.h>

namespace visual {

/* Counting is used to implement cache updates.  Obtaining a counted_lock (typedefed as write_lock)
 * incriments the count variable.  If count exceeds the last count when rendering, than it has been updated
 * and the object must refresh its cached data.  Cache::updateCache is called unconditionally by the render
 * loop, and Cache::refreshCache is called conditionally if such an update is requred.  All caching objects
 * must implement their own refreshCache function.
 * See also: vcache.{h,cpp} and GLdevice::render.
 */
class mutex 
{
	int count;
	pthread_mutex_t mtx;
  
 public:
	typedef lock<mutex> lock;

	mutex(int spincount=0, int count=1);
	~mutex();
  
	inline void sync_lock() { pthread_mutex_lock( &mtx); }
	inline void count_lock() { pthread_mutex_lock( &mtx); count++; }
	inline void sync_unlock() { pthread_mutex_unlock( &mtx); }
	inline int sync_count() { return count; }
  
	inline void clear() 
	{ sync_lock(); count=0; sync_unlock(); }
};

void _threaded_timer( double seconds, bool (*callback)(void*), void *data);

template <class T>
inline void threaded_timer( double seconds, bool (*callback)(T*), T* data) 
{
	_threaded_timer( seconds, (bool(*)(void*))callback, (void*)data);
}

} // !namespace visual
  
#endif // !VISUAL_PLATLINUX_H
