#!/bin/sh -e
# called with '--upstream-version' <version> <file>
# Download the data files needed for the nosetests from the Subversion VCS

PACKAGE_NAME=python-pywcs
VERSION=$2
UPSTREAM_SVN=http://svn6.assembla.com/svn/astrolib/tags/pywcs_${VERSION}/lib
SUBDIR=tests
TMPTARGET=$(mktemp -d)
TARFILENAME=$(dirname $3)/${PACKAGE_NAME}_${VERSION}.orig-${SUBDIR}.tar.gz

svn co -q ${UPSTREAM_SVN}/${SUBDIR} ${TMPTARGET}
tar czf $TARFILENAME --exclude-vcs -C ${TMPTARGET} .
rm -rf ${TMPTARGET}

uupdate --no-symlink "$@"
