/* Copyright (C) 2001 Beau Kuiper

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "../../config.h"

#ifndef HAVE_SETEUID
#error huh
/* seteuid replacement for systems without it, uses setresuid */

int seteuid(uid_t euid)
{
	return setresuid((uid_t)-1, euid, (uid_t)-1);
}

#endif /* HAVE_SETEUID */

#ifndef HAVE_SETEGID

/* setegid replacement for systems without it, uses setresgid */

int setegid(gid_t egid)
{
	return setresgid((gid_t)-1, egid, (gid_t)-1);
}

#endif /* HAVE_SETEGID */
