/*
 *    Copyright (C) 2010
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package mediathek.wiz.wizard;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedList;

/**
 *
 * @author emil
 */
public class Wizard extends javax.swing.JDialog {

    public WizData wizData;
    public boolean ok = false;
    private String titel = "";
    private WizPanel panel = null;
    private LinkedList<WizPanel> listePanel = new LinkedList<WizPanel>();

    public Wizard(java.awt.Frame parent, boolean modal, String ttitel, WizData wwizData) {
        super(parent, modal);
        titel = ttitel;
        wizData = wwizData;
        initComponents();
        this.setTitle(titel);
        jPanelExtra.setLayout(new BorderLayout());
        jButtonVor.addActionListener(new BeobVorZurueck(true));
        jButtonZurueck.addActionListener(new BeobVorZurueck(false));
        jButtonOk.addActionListener(new BeobOk());
        jButtonAbbrechen.addActionListener(new BeobAbbrechen());
//        jButtonHilfe.addActionListener(new BeobHilfe());
        setPanel();
    }

    public void start(String strPanel) {
        panel = getPanel(strPanel);
        setPanel();
        super.setVisible(true);
    }

    public void addPanel(WizPanel wizPanel) {
        listePanel.add(wizPanel);
    }

    public WizPanel getPanel(String name) {
        WizPanel ret = null, tmp = null;
        Iterator<WizPanel> it = listePanel.iterator();
        while (it.hasNext()) {
            tmp = it.next();
            if (tmp.name.equals(name)) {
                ret = tmp;
                break;
            }
        }
        return ret;
    }
    //////////////////////////
    // Private
    //////////////////////////

    private void setPanel() {
        if (panel != null) {
            jPanelExtra.removeAll();
            jTextAreaHelp.setText(panel.hilfe);
            jLabelTitel.setText(panel.titel);
            jPanelExtra.add(panel);
            jPanelExtra.updateUI();
            jButtonVor.setEnabled(panel.panelVor != null);
            jButtonZurueck.setEnabled(panel.panelZurueck != null);
        }
    }

    private void vorZurueck(boolean vor) {
        if (panel != null) {
            if (vor) {
                if (panel.panelVor != null) {
                    panel = getPanel(panel.panelVor);
                }
            } else {
                if (panel.panelZurueck != null) {
                    panel = getPanel(panel.panelZurueck);
                }
            }
            setPanel();
        }
    }

    private void beenden() {
        ok = true;
        this.dispose();
    }

    private void abbrechen() {
        this.dispose();
    }

//    private void hilfe() {
//        if (panel != null) {
//            if (!panel.hilfe.equals("")) {
//                new DialogHilfe(null, true, panel.hilfe).setVisible(true);
//            }
//        }
//    }
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        jTextPane1 = new javax.swing.JTextPane();
        jButtonOk = new javax.swing.JButton();
        jButtonAbbrechen = new javax.swing.JButton();
        jPanel1 = new javax.swing.JPanel();
        jButtonZurueck = new javax.swing.JButton();
        jLabelTitel = new javax.swing.JLabel();
        jButtonVor = new javax.swing.JButton();
        jPanelExtra = new javax.swing.JPanel();
        jScrollPane2 = new javax.swing.JScrollPane();
        jTextAreaHelp = new javax.swing.JTextArea();

        jScrollPane1.setName("jScrollPane1"); // NOI18N

        jTextPane1.setName("jTextPane1"); // NOI18N
        jScrollPane1.setViewportView(jTextPane1);

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);

        jButtonOk.setText("OK");
        jButtonOk.setName("jButtonOk"); // NOI18N

        jButtonAbbrechen.setText("Abbrechen");
        jButtonAbbrechen.setName("jButtonAbbrechen"); // NOI18N

        jPanel1.setBorder(new javax.swing.border.SoftBevelBorder(javax.swing.border.BevelBorder.RAISED));
        jPanel1.setName("jPanel1"); // NOI18N

        jButtonZurueck.setText("<<");
        jButtonZurueck.setName("jButtonZurueck"); // NOI18N

        jLabelTitel.setText("jLabel1");
        jLabelTitel.setName("jLabelTitel"); // NOI18N

        jButtonVor.setText(">>");
        jButtonVor.setName("jButtonVor"); // NOI18N

        jPanelExtra.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jPanelExtra.setName("jPanelExtra"); // NOI18N

        javax.swing.GroupLayout jPanelExtraLayout = new javax.swing.GroupLayout(jPanelExtra);
        jPanelExtra.setLayout(jPanelExtraLayout);
        jPanelExtraLayout.setHorizontalGroup(
            jPanelExtraLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 359, Short.MAX_VALUE)
        );
        jPanelExtraLayout.setVerticalGroup(
            jPanelExtraLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 185, Short.MAX_VALUE)
        );

        jScrollPane2.setName("jScrollPane2"); // NOI18N

        jTextAreaHelp.setColumns(20);
        jTextAreaHelp.setEditable(false);
        jTextAreaHelp.setRows(3);
        jTextAreaHelp.setName("jTextAreaHelp"); // NOI18N
        jScrollPane2.setViewportView(jTextAreaHelp);

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(jButtonZurueck)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabelTitel)
                            .addComponent(jPanelExtra, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jButtonVor))
                    .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 495, Short.MAX_VALUE))
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabelTitel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jButtonZurueck, javax.swing.GroupLayout.DEFAULT_SIZE, 189, Short.MAX_VALUE)
                    .addComponent(jButtonVor, javax.swing.GroupLayout.DEFAULT_SIZE, 189, Short.MAX_VALUE)
                    .addComponent(jPanelExtra, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addGap(12, 12, 12)
                .addComponent(jScrollPane2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jPanel1, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jButtonOk)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonAbbrechen)))
                .addContainerGap())
        );

        layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {jButtonAbbrechen, jButtonOk});

        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonAbbrechen)
                    .addComponent(jButtonOk))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonAbbrechen;
    private javax.swing.JButton jButtonOk;
    private javax.swing.JButton jButtonVor;
    private javax.swing.JButton jButtonZurueck;
    private javax.swing.JLabel jLabelTitel;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanelExtra;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JTextArea jTextAreaHelp;
    private javax.swing.JTextPane jTextPane1;
    // End of variables declaration//GEN-END:variables

//    private WizPanel createObject(String panel, WizData wizData) {
//        Constructor constructor = null;
//        Class panelClass = null;
//        Class[] argsClass = null;
//        Object[] args = null;
//        WizPanel ret = null;
//        try {
//            panelClass = Class.forName(panel);
//            argsClass = new Class[]{WizData.class};
//            args = new Object[]{wizData};
//            constructor = panelClass.getConstructor(argsClass);
//            ret = (WizPanel) constructor.newInstance(args);
//            return ret;
//        } catch (NoSuchMethodException e) {
//            System.out.println(e);
//        } catch (SecurityException e) {
//            System.out.println(e);
//        } catch (ClassNotFoundException e) {
//            System.out.println(e);
//        } catch (InstantiationException e) {
//            System.out.println(e);
//        } catch (IllegalAccessException e) {
//            System.out.println(e);
//        } catch (IllegalArgumentException e) {
//            System.out.println(e);
//        } catch (InvocationTargetException e) {
//            System.out.println(e);
//        }
//        return ret;
//    }
    private class BeobVorZurueck implements ActionListener {

        boolean vor = true;

        public BeobVorZurueck(boolean vvor) {
            vor = vvor;
        }

        public void actionPerformed(ActionEvent e) {
            vorZurueck(vor);
        }

    }

    private class BeobOk implements ActionListener {

        public void actionPerformed(ActionEvent e) {
            beenden();
        }

    }

    private class BeobAbbrechen implements ActionListener {

        public void actionPerformed(ActionEvent e) {
            abbrechen();
        }

    }

//    private class BeobHilfe implements ActionListener {
//
//        public void actionPerformed(ActionEvent e) {
//            hilfe();
//        }
//
//    }
}
