/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package mediathek.io;

import mediathek.filme.FilmListener;
import com.sun.syndication.feed.synd.SyndEnclosure;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.File;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.event.EventListenerList;
import mediathek.Konstanten;
import mediathek.daten.Daten;
import mediathek.filme.DatenFilm;
import mediathek.daten.DatenPod;
import mediathek.filme.FilmeLaden;
import mediathek.filme.ListeFilme;

public class FeedReaderPods {

    private Daten daten;
    private boolean stop;
    private EventListenerList listeners = new EventListenerList();
    private ListeFilme liste;
    private int threads = 0;
    private Iterator<DatenPod> itPod;

    //===================================
    // public
    //===================================
    public FeedReaderPods(Daten d) {
        daten = d;
        liste = new ListeFilme(daten);
        listeners = new EventListenerList();
    }

    public boolean starten() {
        boolean ret = daten.listePod.size() > 0;
        threads = 0;
        stop = false;
        liste.clear();
        notifyStart(daten.listePod.size());
        new Thread(new Laden()).start();
        return ret;
    }

    /**
     * 
     * @param listener
     */
    public void addAdListener(FilmListener listener) {
        listeners.add(FilmListener.class, listener);
    }

    public void stoppen() {
        stop = true;
    }

    public ListeFilme getListe() {
        return liste;
    }

    //===================================
    // private
    //===================================
    private class Laden implements Runnable {

        @Override
        public synchronized void run() {
            itPod = daten.listePod.iterator();
            for (int t = 0; t < Konstanten.MAX_THREAD_LADEN_PODCAST; ++t) {
                ++threads;
                new Thread(new Starten()).start();
            }
            while (threads > 0) {
                try {
                    this.wait(500);
                } catch (InterruptedException ex) {
                }
            }
            if (stop) {
                liste.clear();
            }
            notifyFertig();
        }

    }

    private synchronized DatenPod getPod() {
        if (itPod.hasNext()) {
            return itPod.next();
        } else {
            return null;
        }
    }

    private synchronized void addListe(DatenFilm film) {
        liste.add(film);
    }

    private class Starten implements Runnable {

        @Override
        public synchronized void run() {
            ListeFilme list = new ListeFilme(daten);
            DatenPod pod;
            while (!stop && (pod = getPod()) != null) {
                downloadPods(pod, pod.arr[Konstanten.POD_NAME_NR], pod.arr[Konstanten.POD_URL_NR],
                             list, pod.arr[Konstanten.POD_ZIELPFAD_NR]);
                notifyProgress(pod.arr[Konstanten.POD_URL_NR]);
            }
            Iterator<DatenFilm> itPod = list.iterator();
            while (itPod.hasNext()) {
                addListe(itPod.next());
            }
            --threads;
        }

    }

    private void downloadPods(DatenPod pod, String podcast, String strUrl, ListeFilme liste, String zielPfad) {
        try {
            URL feedUrl = new URL(strUrl);
            URLConnection conn = feedUrl.openConnection();
            conn.setRequestProperty("User-Agent", daten.system[Konstanten.SYSTEM_USER_AGENT_NR]);
            conn.setReadTimeout(2000);
            XmlReader xmlReader = new XmlReader(conn.getInputStream());
            SyndFeed feed = new SyndFeedInput().build(xmlReader);
            Iterator entryIter = feed.getEntries().iterator();
            DatenFilm film;
            while (!stop && entryIter.hasNext()) {
                SyndEntry entry = (SyndEntry) entryIter.next();
                Iterator it = entry.getEnclosures().iterator();
                while (!stop && it.hasNext()) {
                    SyndEnclosure sEnc = (SyndEnclosure) it.next();
                    if (!daten.system[Konstanten.SYSTEM_ZIELPFAD_POD_NR].endsWith(File.separator)) {
                        daten.system[Konstanten.SYSTEM_ZIELPFAD_POD_NR] += File.separator;
                    }
                    //Pfad
                    if (zielPfad.startsWith(File.separator)) {
                        zielPfad = zielPfad.substring(1);
                    }
                    if (!zielPfad.endsWith(File.separator)) {
                        zielPfad += File.separator;
                    }
                    zielPfad = daten.system[Konstanten.SYSTEM_ZIELPFAD_POD_NR] + zielPfad;
                    //Url
                    String url = sEnc.getUrl();
                    //prüfen
                    if (!daten.log.zeilePruefen(url, Konstanten.LOG_DATEI_POD)) {
                        if (!listeContainUrl(liste, url)) {
                            //Neues DatenFilm-Object anlegen und hinzufügen
                            //DatenFilm(Daten ddaten, String ssender, String tthema, String ttitel, String uurl, String zielPfad) {
                            film = new DatenFilm(daten, Konstanten.SENDER_PODCAST, podcast, entry.getTitle(), url, zielPfad);
                            liste.add(film);
                            pod.arr[Konstanten.POD_DOWN_DATUM_NR] = new SimpleDateFormat("dd.MM.yyyy").format(new Date());
                            daten.setGeaendert();
                        }
                    }
                }
            }
        } catch (Exception e) {
            String[] str = new String[3];
            str[0] = e.getMessage();
            str[1] = "Podcast:  " + podcast;
            str[2] = "Url:      " + strUrl;
             daten.fehler.fehlerMeldung("Fehler!", str);
        }
    }

    private boolean listeContainUrl(ListeFilme liste, String str) {
        //String[]-Liste nach String an der Stelle suchen
        boolean ret = false;
        ListIterator<DatenFilm> it = liste.listIterator(0);
        while (it.hasNext()) {
            if (it.next().arr[Konstanten.FILM_URL_NR].equals(str)) {
                ret = true;
                break;
            }
        }
        return ret;
    }

    private void notifyStart(int max) {
        for (FilmListener l : listeners.getListeners(FilmListener.class)) {
            l.start("Podcast",  max);
        }
    }

    private void notifyProgress(String text) {
        for (FilmListener l : listeners.getListeners(FilmListener.class)) {
            l.progress("Podcast", text);
        }
    }

    private void notifyFertig() {
        if (threads <= 0) { // sonst läuft noch was
            if (stop) {
                daten.filmeLaden.listeFilme.clear();
            }
            for (FilmListener l : listeners.getListeners(FilmListener.class)) {
                l.fertig("Podcast",  stop);
            }
        }
    }

}


