/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek.filme.sender;

import mediathek.Konstanten;
import mediathek.daten.Daten;
import mediathek.filme.DatenFilm;
import mediathek.io.GetUrl;

/**
 * 
 * @author
 */
public class MediathekSf extends MediathekReader implements Runnable {

    private final int MAX_FILME_THEMA = 5;
    private StringBuffer seite = new StringBuffer();

    /**
     * 
     * @param ddaten
     */
    public MediathekSf(Daten ddaten) {
        super(ddaten);
        sender = Konstanten.SENDER_SF;
        text = "SF (ca. 25 MB, 1300 Filme)";
    }

    /**
     * 
     */
    @Override
    public void addToList() {
        //Liste von http://www.videoportal.sf.tv/sendungen holen
        //<a class="sendung_name" href="/sendung?id=6fd27ab0-d10f-450f-aaa9-836f1cac97bd">1 gegen 100</a><p class="az_description">Gameshow, in der ein Kandidat gegen 100 Kontrahenten antritt.</p></div>
        final String MUSTER = "sendung_name\" href=\"/sendung?id=";
        listeThemen.clear();
        seite = getUrlIo.getUri_Utf(sender, "http://www.videoportal.sf.tv/sendungen", seite, "");
        int pos = 0;
        int pos1 = 0;
        int pos2 = 0;
        String url = "";
        String thema = "";
        while ((pos = seite.indexOf(MUSTER, pos)) != -1) {
            pos += MUSTER.length();
            pos1 = pos;
            pos2 = seite.indexOf("\"", pos);
            if (pos1 != -1 && pos2 != -1) {
                url = seite.substring(pos1, pos2);
                if (!url.equals("")) {
                    pos1 = seite.indexOf(">", pos);
                    pos2 = seite.indexOf("</a>", pos);
                    if (pos1 != -1 && pos2 != -1) {
                        thema = seite.substring(pos1 + 1, pos2);
                        if (nurAboLaden()) {
                            //nur Abos laden
                            if (!daten.listeAbo.aboExists(sender, thema)) {
                                continue;
                            }
                        }
                    }
                    String[] add = new String[]{"http://www.videoportal.sf.tv/rss/sendung?id=" + url, thema};
                    if (!istInListe(listeThemen, url, 0)) {
                        listeThemen.add(add);
                    }
                } else {
                    daten.fehler.fehlerMeldung("Fehler!", "MediathekSf.addToList: keine URL");

                }
            }
        }
        if (!stop) {
            if (listeThemen.size() > 0) {
                notifyStart(listeThemen.size());
                for (int t = 0; t < Konstanten.MAX_THREAD_LADEN_FILME_KLEIN; ++t) {
                    new Thread(new SfThemaLaden()).start();
                }
            }
        }
    }

    private class SfThemaLaden implements Runnable {

        GetUrl getUrl = new GetUrl(daten, -1, Konstanten.WARTEN_BASIS_URL_LANG);
        private StringBuffer seite1 = new StringBuffer();
        private StringBuffer seite2 = new StringBuffer();

        @Override
        public void run() {
            addThread();
            String link[];
            while (!stop && (link = getListeThemen()) != null) {
                notifyProgress(link[0] /*url*/);
                seite.setLength(0);
                addFilme(link[1], link[0] /*url*/);
            }
            threadUndFertig();
        }

        private void addFilme(String thema, String strUrlFeed) {
            //&lt;li&gt;&lt;a href="/video?id=1887caf6-ec0e-4557-87f6-e92245cd66b8;DCSext.zugang=videoportal_sendungsuebersicht"&gt;sportaktuell vom 11.09.2010&lt;/a&gt;&lt;/li&gt;
            //<title>10vor10 vom 17.11.2010, 21:50</title>

            final String MUSTER_TITEL = "&gt;"; //bis zum &
            final String MUSTER_URL = "href=\"/video?id="; //bis zum ;
            final String MUSTER_ITEM_1 = "<item>";
            final String MUSTER_ITEM_2 = "</item>";
            final String MUSTER_DATUM = "<title>";
            notifyProgress("*" + strUrlFeed);
            seite1 = getUrl.getUri_Utf(sender, strUrlFeed, seite1, "");
            try {
                int counter = 0;
                int posItem1 = 0;
                int posItem2 = 0;
                int pos = 0;
                int pos1 = 0;
                int pos2 = 0;
                String url = "";
                String link = "";
                String datum = "";
                String zeit = "";
                String titel = "";
                String tmp = "";
                while (!stop && (daten.allesLaden || counter < MAX_FILME_THEMA) && (posItem1 = seite1.indexOf(MUSTER_ITEM_1, posItem1)) != -1) {
                    posItem1 += MUSTER_ITEM_1.length();
//                    posItem2 = seite1.indexOf(MUSTER_ITEM_2, posItem1);
                    ++counter;
                    if ((pos1 = seite1.indexOf(MUSTER_DATUM, posItem1)) != -1) {
                        pos1 += MUSTER_DATUM.length();
                        if ((pos2 = seite1.indexOf("<", pos1)) != -1) {
                            tmp = seite1.substring(pos1, pos2);
                            if (tmp.contains("vom")) {
                                tmp = tmp.substring(tmp.indexOf("vom") + 3);
                                if (tmp.contains(",")) {
                                    datum = tmp.substring(0, tmp.indexOf(",")).trim();
                                    zeit = tmp.substring(tmp.indexOf(",") + 1).trim() + ":00";
                                }
                            }
                        }
                    }
                    if ((pos1 = seite1.indexOf(MUSTER_URL, posItem1)) != -1) {
                        pos1 += MUSTER_URL.length();
                        if ((pos2 = seite1.indexOf(";", pos1)) != -1) {
                            url = seite1.substring(pos1, pos2);
                            if (!url.equals("")) {
                                if ((pos1 = seite1.indexOf(MUSTER_TITEL, pos2)) != -1) {
                                    pos1 += MUSTER_TITEL.length();
                                    if ((pos2 = seite1.indexOf("&", pos1)) != -1) {
                                        titel = seite1.substring(pos1, pos2);
                                        addFilme2(thema, strUrlFeed, "http://www.videoportal.sf.tv/cvis/segment/" + url + "/.json", titel, datum, zeit);
                                    } else {
                                        daten.fehler.fehlerMeldung("Fehler!", "MediathekSf.addFilme: keine URL");
                                    }
                                }
                            }
                        }
                    }
                }
            } catch (Exception ex) {
                daten.fehler.fehlerMeldung(ex, "MediathekSf.addToList");
            }
        }

        private void addFilme2(String thema, String strUrlFeed, String url, String titel, String datum, String zeit) {
            final String MUSTER_URL = "\"url\":\""; //bis zum "
            notifyProgress("*" + url);
            seite2 = getUrl.getUri_Utf(sender, url, seite2, "");
            try {
                int pos = 0;
                int pos1 = 0;
                int pos2 = 0;
                if ((pos = seite2.indexOf(MUSTER_URL, pos)) != -1) {
                    pos += MUSTER_URL.length();
                    pos1 = pos;
                    pos2 = seite2.indexOf("\"", pos);
                    if (pos1 != -1 && pos2 != -1) {
                        url = seite2.substring(pos1, pos2);
                        if (!url.equals("")) {
                            url = url.replace("\\", "");
                            // DatenFilm(Daten ddaten, String ssender, String tthema, String urlThema, String ttitel, String uurl, String uurlorg, String zziel) {
                            DatenFilm film = new DatenFilm(daten, sender, thema, strUrlFeed, titel, url, datum, zeit);
                            daten.filmeLaden.listeFilmeSchattenliste.addSenderRtmp(film);
                        } else {
                            daten.fehler.fehlerMeldung("Fehler!", "MediathekSf.addFilme2: keine URL");
                        }
                    }
                }
            } catch (Exception ex) {
                daten.fehler.fehlerMeldung(ex, "MediathekSf.addToList");
            }
        }
    }
}
