/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek.filme.sender;

import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.Semaphore;
import javax.swing.JDialog;
import javax.swing.event.EventListenerList;
import mediathek.Funktionen;
import mediathek.Konstanten;
import mediathek.daten.Daten;
import mediathek.filme.DatenFilm;
import mediathek.filme.FilmListener;
import mediathek.io.GetUrl;

/**
 * 
 * @author
 */
public class MediathekReader implements Runnable {

    private int seitenSender = 0;
    private Date startZeit = null, endZeit = null;
    public String text = "";
    public String sender = "";
    boolean senderOn = true;
    public boolean updateOn = false;
    public JDialog panelEinstellungen = null;
    int threads = 0;
    boolean stop = false;
    Daten daten;
    EventListenerList listeners = new EventListenerList();
    LinkedList<String[]> listeThemen = new LinkedList<String[]>();
    GetUrl getUrlIo;
    Semaphore sem = new Semaphore(1);

    /**
     * 
     * @param ddaten
     */
    public MediathekReader(Daten ddaten) {
        daten = ddaten;
        getUrlIo = new GetUrl(daten);
    }
    //===================================
    // public 
    //===================================

    public boolean istSenderAn() {
        return senderOn;
    }

    public void setSenderAn(boolean an) {
        senderOn = an;
    }

//    public static String leitungAendern(Daten daten, DatenFilm film) {
//        return film.arr[Konstanten.FILM_URL_ORG_NR];
//    }
    /**
     * 
     * @param listener
     */
    public void addAdListener(FilmListener listener) {
        listeners.add(FilmListener.class, listener);
    }

    /**
     * 
     */
    public void stoppen() {
        stop = true;
    }

    @Override
    public void run() {
        //alles laden
        startZeit = null;
        endZeit = null;
        try {
            if (daten.noGui || senderOn || updateOn) {
                // bei nogui werden immer alle Sender geladen
                updateOn = false;
                startZeit = new Date();
                stop = false;
                threads = 0;
                addToList();
            }
        } catch (Exception e) {
            daten.fehler.fehlerMeldung(e, "Exception im Thread Sender: " + sender);
        }
    }

    void getSem() {
        try {
            sem.acquire();
        } catch (InterruptedException e) {
            daten.fehler.fehlerMeldung(e, sender + " sem.acquire()");
        }
    }

    void relSem() {
        sem.release();
    }

    synchronized void addThread() {
        ++threads;
        notifyThread();
    }

    synchronized void threadUndFertig() {
        --threads;
        notifyThread();
        notifyFertig();
    }

    void addToList() {
    }

//    public void addThema(String uurl, String tthema) {
//        // nur ein Thema laden
//        stop = false;
//        if (!uurl.equals("") && !tthema.equals("")) {
//            daten.filmeLaden.listeFilme.delThema(sender, tthema);
//            listeThemen.clear();
//            notifyStart(1);
//            String[] add = new String[]{uurl, tthema};
//            listeThemen.add(add);
//            if (listeThemen.size() > 0) {
//                themaLaden();
//            }
//        }
//    }
//
//    void themaLaden() {
//    }
    void notifyMax(int max) {
        for (FilmListener l : listeners.getListeners(FilmListener.class)) {
            l.addMax(sender, max);
        }
    }

    void notifyStart(int max) {
        daten.fehler.systemMeldung("Starten " + sender + ": " + Funktionen.getJetzt_HH_MM_SS());
        for (FilmListener l : listeners.getListeners(FilmListener.class)) {
            l.start(sender, max);
        }
    }

    void notifyThread() {
        for (FilmListener l : listeners.getListeners(FilmListener.class)) {
            l.threads(sender, threads);
        }
    }

    void notifyFertig() {
        //wird erst ausgeführt wenn alle Threads beendet sind
        if (threads <= 0) { // sonst läuft noch was
            endZeit = new Date();
            daten.fehler.systemMeldung("Fertig " + sender + ": " + Funktionen.getJetzt_HH_MM_SS());
            seitenSenderSchreiben();
//            daten.filmeLaden.listeFilme.datumSchreiben(stop /*löschen*/);
            for (FilmListener l : listeners.getListeners(FilmListener.class)) {
                l.fertig(sender, stop);
            }
        }
    }

    void notifyProgress(String text) {
        for (FilmListener l : listeners.getListeners(FilmListener.class)) {
            l.progress(sender, text);
        }
    }

    boolean istInListe(LinkedList<String[]> liste, String str, int nr) {
        boolean ret = false;
        Iterator<String[]> it = liste.listIterator();
        while (it.hasNext()) {
            if (it.next()[nr].equals(str)) {
                ret = true;
                break;
            }
        }
        return ret;
    }

    synchronized String[] getListeThemen() {
        return listeThemen.pollFirst();
    }

    //
    // Seitenzähler
    //
    private void seitenSenderSchreiben() {
        System.out.println("Sender " + sender + ": " + seitenSender + " Seiten");
    }

    public void incSeitenZaehler() {
        ++seitenSender;
    }

    public void seitenZaehlerLoeschen() {
        seitenSender = 0;
    }

    public int getSeitenZaehler() {
        return seitenSender;
    }

    public String getLaufzeitMinuten() {
        String ret = "";
        int sekunden = 0;
        try {
            if (startZeit != null && endZeit != null) {
                sekunden = Math.round((endZeit.getTime() - startZeit.getTime()) / 1000);
                String min = String.valueOf(sekunden / 60);
                String sek = String.valueOf(sekunden % 60);
                if (sek.length() == 1) {
                    sek = "0" + sek;
                }
                ret = min + ":" + sek;
            }
        } catch (Exception ex) {
        }
        return ret;
    }

    public boolean nurAboLaden() {
        // liefert true, wenn nur abos geladen werden sollen
        boolean ret = false;
        //bei noGui immer alles laden
        if (!daten.noGui) {
            //wenn Abo eingeschaltet
            if (Boolean.parseBoolean(daten.system[Konstanten.SYSTEM_ABO_NR])) {
                //und NurAboLaden eingeschaltet
                if (Boolean.parseBoolean(daten.system[Konstanten.SYSTEM_NUR_ABO_NR])) {
                    ret = true;
                }
            }
        }
        return ret;
    }
}
