/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek.filme.sender;

import java.text.SimpleDateFormat;
import java.util.Date;
import mediathek.Funktionen;
import mediathek.Konstanten;
import mediathek.daten.Daten;
import mediathek.filme.DatenFilm;
import mediathek.io.GetUrl;

/**
 *
 * @author
 */
public class MediathekNdrFlash extends MediathekReader implements Runnable {

    private final int MAX_PER_FEED = 10;

    /**
     *
     * @param ddaten
     */
    public MediathekNdrFlash(Daten ddaten) {
        super(ddaten);
        sender = Konstanten.SENDER_NDR_FLASH;
        text = "NDR  (ca. 6 MB, 500 Filme)";
    }

//-> erste Seite:
//http://www.ndr.de/mediathek/mediathek100-mediathek_medium-tv_searchtype-broadcasts.xml
//-> Thema:
//http://www.ndr.de/mediathek/mediathek100-mediathek_medium-tv_broadcast-46_pageSize-24.xml
//-> Film:
//http://www.ndr.de/mediathek/visite4392-mediathek_details-true.xml
    @Override
    void addToList() {
        //<broadcast id="1391" site="ndrfernsehen">45 Min</broadcast>
        final String ADRESSE = "http://www.ndr.de/mediathek/mediathek100-mediathek_medium-tv_searchtype-broadcasts.xml";
        final String MUSTER_URL1 = "<broadcast id=\"";
        listeThemen.clear();
        StringBuffer seite = new StringBuffer();
        seite = getUrlIo.getUri_Utf(sender, ADRESSE, seite, "");
        int pos = 0;
        int pos1 = 0;
        int pos2 = 0;
        String url = "";
        String thema = "";
        //Podcasts auslesen
        while ((pos = seite.indexOf(MUSTER_URL1, pos)) != -1) {
            try {
                pos += MUSTER_URL1.length();
                pos1 = pos;
                pos2 = seite.indexOf("\"", pos);
                if (pos1 != -1 && pos2 != -1) {
                    url = seite.substring(pos1, pos2);
                }
                pos1 = seite.indexOf(">", pos);
                pos2 = seite.indexOf("<", pos);
                if (pos1 != -1 && pos2 != -1 && pos1 < pos2) {
                    thema = seite.substring(pos1 + 1, pos2);
                    if (nurAboLaden()) {
                        //nur Abos laden
                        if (!daten.listeAbo.aboExists(sender, thema)) {
                            continue;
                        }
                    }
                }
                if (url.equals("")) {
                    continue;
                }
                String[] add = new String[]{"http://www.ndr.de/mediathek/mediathek100-mediathek_medium-tv_broadcast-" + url + "_pageSize-24.xml", thema};
                if (!istInListe(listeThemen, url, 0)) {
                    listeThemen.add(add);
                }
            } catch (Exception ex) {
                daten.fehler.fehlerMeldung("Fehler!", "Test: kein Thema");
            }
        }
        if (!stop) {
            if (listeThemen.size() > 0) {
                notifyStart(listeThemen.size());
                Funktionen.listeSort(listeThemen, 1);
                for (int t = 0; t < Konstanten.MAX_THREAD_LADEN_FILME_KLEIN; ++t) {
                    new Thread(new ThemaLaden()).start();
                }
            }
        }
    }

    private class ThemaLaden implements Runnable {

        GetUrl getUrl = new GetUrl(daten, 20000, Konstanten.WARTEN_BASIS_URL_LANG);
        private StringBuffer seite1 = new StringBuffer();
        private StringBuffer seite2 = new StringBuffer();

        @Override
        public synchronized void run() {
            addThread();
            String[] link;
            while (!stop && (link = getListeThemen()) != null) {
                try {
                    notifyProgress(link[0]);
                    feedEinerSeiteSuchen(link[0] /*url*/, link[1] /*Thema*/);
                } catch (Exception ex) {
                }
            }
            threadUndFertig();
        }

        void feedEinerSeiteSuchen(String strUrlFeed, String thema) {
            //<mediaItem id="diezockerbank110" type="video">
            //<title><![CDATA[Die Zockerbank]]></title>
            final String MUSTER_URL = "<mediaItem id=\"";
            final String MUSTER_TITEL = "<title><![CDATA[";
            int counter = 0;
            seite1 = getUrl.getUri_Utf(sender, strUrlFeed, seite1, "Thema: " + thema);
            int pos = 0;
            int pos1 = 0;
            int pos2 = 0;
            String url = "";
            String titel = "";
            try {
                while (!stop && (pos = seite1.indexOf(MUSTER_URL, pos)) != -1) {
                    ++counter;
                    if (!daten.allesLaden && counter > MAX_PER_FEED) {
                        break;
                    }
                    pos += MUSTER_URL.length();
                    pos1 = pos;
                    pos2 = seite1.indexOf("\"", pos);
                    if (pos1 != -1 && pos2 != -1) {
                        url = seite1.substring(pos1, pos2);
                    }
                    if (!url.equals("")) {
                        pos = pos2;
                        if ((pos = seite1.indexOf(MUSTER_TITEL, pos)) != -1) {
                            pos += MUSTER_TITEL.length();
                            pos1 = pos;
                            pos2 = seite1.indexOf("]", pos + 1);
                            if (pos1 != -1 && pos2 != -1) {
                                titel = seite1.substring(pos1, pos2);
                            }
                            filmSuchen(strUrlFeed, thema, titel, "http://www.ndr.de/mediathek/" + url + "-mediathek_details-true.xml");
                        }
                    } else {
                        daten.fehler.fehlerMeldung("Fehler!", "keine Url feedEinerSeiteSuchen" + strUrlFeed);
                    }

                }
            } catch (Exception ex) {
                daten.fehler.fehlerMeldung(ex, "keine Url feedEinerSeiteSuchen" + strUrlFeed);
            }
        }

        void filmSuchen(String strUrlThema, String thema, String titel, String urlFilm) {
            //<source format="mp4hi" mimetype="video/mp4" protocol="rtmpt">rtmpt://ndr.fcod.llnwd.net/a3715/d1/flashmedia/streams/ndr/2010/0208/TV-20100208-1833-0101.hi.mp4</source>
            //<source format="mp4hq" mimetype="video/mp4" protocol="rtmpt">rtmpt://ndr.fcod.llnwd.net/a3715/d1/flashmedia/streams/ndr/2010/0208/TV-20100208-1833-0101.hq.mp4</source>
            //http://www.ndr.de/mediathek/visite4392-mediathek_details-true.xml
            // <date weekday="Dienstag" weekdayShort="Di">2010-11-30T23:45:00</date>
            final String MUSTER_DATUM = "<date ";
            final String MUSTER_URL = "<source format=\"mp4hq\" mimetype=\"video/mp4\" protocol=\"rtmpt\">";
            seite2 = getUrl.getUri_Utf(sender, urlFilm, seite2, "strUrlThema: " + strUrlThema);
            int pos = 0;
            int pos1 = 0;
            int pos2 = 0;
            String url = "";
            String datum = "";
            String zeit = "";
            String tmp = "";
            try {
                if ((pos = seite2.indexOf(MUSTER_DATUM)) != -1) {
                    pos += MUSTER_DATUM.length();
                    if ((pos1 = seite2.indexOf(">", pos)) != -1) {
                        pos1 += 1;
                        if ((pos2 = seite2.indexOf("<", pos1)) != -1) {
                            tmp = seite2.substring(pos1, pos2);
                            try {
                                SimpleDateFormat sdfIn = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                                Date filmDate = sdfIn.parse(tmp);
                                SimpleDateFormat sdfOut;
                                sdfOut = new SimpleDateFormat("dd.MM.yyyy");
                                datum = sdfOut.format(filmDate);
                                sdfOut = new SimpleDateFormat("HH:mm:ss");
                                zeit = sdfOut.format(filmDate);
                            } catch (Exception ex) {
                                daten.fehler.fehlerMeldung(ex, "MediathekNdr.convertDatum");
                            }
                        }
                    }
                }
                pos = 0;
                pos1 = 0;
                pos2 = 0;
                if ((pos = seite2.indexOf(MUSTER_URL)) != -1) {
                    pos += MUSTER_URL.length();
                    pos1 = pos;
                    pos2 = seite2.indexOf("<", pos);
                    if (pos1 != -1 && pos2 != -1) {
                        url = seite2.substring(pos1, pos2);
                    }
                    if (!url.equals("")) {
                        //DatenFilm(Daten ddaten, String ssender, String tthema, String urlThema, String ttitel, String uurl, String uurlorg, String zziel)
                        daten.filmeLaden.listeFilmeSchattenliste.addSenderRtmp(
                                new DatenFilm(daten, sender, thema, strUrlThema, titel, url, datum, zeit));
                    } else {
                        daten.fehler.fehlerMeldung("Fehler!", "keine Url filmSuchen" + strUrlThema);
                    }
                }
            } catch (Exception ex) {
                daten.fehler.fehlerMeldung(ex, "keine Url filmSuchen" + strUrlThema);
            }
        }
    }
}
