# $Id: instdocs.rb,v 1.9 1999/10/21 14:06:40 akira Exp $
if File.exist?('debian/instconf.rb')
  require 'debian/instconf.rb'
end
require 'ftools'
require 'debian/manifest.rb'
require 'rbconfig'
include Config

%r!/([^/]+)-([^-]+)$! =~ Dir.pwd
package_name = $1
package_name.sub!(/^ruby[^-]*/o, CONFIG['ruby_install_name'])
package_version = $2

info = nil
prefix = ''
if File.exist?('MANIFEST')
  info = Manifest::read_manifest('MANIFEST')
else
  Dir.foreach('.') {|x|
    next if /^\./o =~ x
    if File.exist?(x + '/MANIFEST')
      info = Manifest::read_manifest(x + '/MANIFEST')
      prefix = x + '/'
      break
    end
  }
end

ruby_dir = 'debian/tmp/usr/share/doc/' + CONFIG['ruby_install_name']
base_dir = 'debian/tmp/usr/share/doc/' + package_name
document_dir = base_dir
example_dir  = base_dir + '/examples'

unless info
  raise 'can not find MANIFEST file'
end


# install docments

list = []
if info.document_dir_files.size > 0
  list += Manifest::get_install_list2(info.document_dir_files, document_dir)
end
if info.document_files.size > 0
  list += Manifest::get_install_list2(info.document_files, document_dir)
end

list.each {|x|
  dir = File.dirname(x[1])
  unless File.directory?(dir)
    File.makedirs(dir, true)
  end

  next unless FileTest.file?(prefix + x[0])
  File.install(prefix + x[0], x[1], 0444, true)
}

if list.size > 0
  symlink_target = '../../' + package_name
  symlink_file   = ruby_dir + '/ext/' + 
    package_name.gsub(/^lib|-#{Regexp.quote(CONFIG['ruby_install_name'])}$/o, '')
  File.makedirs(ruby_dir + '/ext')
  File.symlink(symlink_target, symlink_file)
end

# install examples

list = []
if info.example_dir_files.size > 0
  list += Manifest::get_install_list2(info.example_dir_files, example_dir)
end
if info.example_files.size > 0
  list += Manifest::get_install_list2(info.example_files, example_dir)
end

list.each {|x|
  dir = File.dirname(x[1])
  unless File.directory?(dir)
    File.makedirs(dir, true)
  end

  next unless FileTest.file?(prefix + x[0])
  File.install(prefix + x[0], x[1], nil, true)

  f = File.open(x[1] + '.tmp', 'w')
  exec = nil
  IO.foreach(x[1]) {|line|
    if exec == nil
      if line.sub!(/^\#!\s*((\S*\/)+ruby|(\S*\/)*env ruby)\S*/,
		   "#!/usr/bin/#{CONFIG['ruby_install_name']}")
	exec = true
      elsif line.sub!(/^\#!\s*(\S*\/)+(wish|perl|env)/,
		      '#!/usr/bin/\2')
	exec = false
      else
	exec = false
      end
    end
    f.print line
  }
  f.close
  File.install(x[1] + '.tmp', 
	       x[1], nil, false)
  if exec
    File.chmod(0555, x[1], true)
  else
    File.chmod(0444, x[1], true)
  end
  File.safe_unlink(x[1] + '.tmp')
}

if list.size > 0
  symlink_target = '../../' + package_name + '/examples'
  symlink_file   = ruby_dir + '/examples/' + 
    package_name.gsub(/^lib|-#{Regexp.quote(CONFIG['ruby_install_name'])}$/o, '')
  File.makedirs(ruby_dir + '/examples')
  File.symlink(symlink_target, symlink_file)
end
