#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>
#include <unistd.h> /* unlink */
#include <errno.h> /* red hat */
#include <wait.h> /* for runit */
#include <dirent.h>
#include <error.h>

/*----------------------------*/
/*                            */
/* System C commands from Ada */
/*                            */
/*----------------------------*/

char Interface_String[255]; /* for passing data back/forth */
char SessionLogName[80];    /* for the session log - set from ada */

char s[81];                 /* temporary string */

const char LongDateFormat[] = "%A, %B %d, %Y";
const char DateFormat[] = "%m/%d/%Y";
const char TimeFormat[] = "%T";

/* C_errno -- binding to errno variable.  Under Gnat 5.x, */
/* errno is not visible to Ada for some reason. */

int C_errno() {
    return errno;
}
void C_reset_errno() {
    errno = 0;
}

/* CFileExists -- determine if a file exists */

int CFileExists( char * path ) {
  struct stat statinfo;
  int result;

  if ( stat( path, &statinfo ) ) {
     result = 0;
  } else {
     result = 1;
  }
  return result;
}

/* CLongDate -- get long date and return result in Interface_String */

void CLongDate() {
   time_t t;
   struct tm *tm;

   time( &t );
   tm = localtime( &t ); 
   strftime( Interface_String, 255, LongDateFormat, tm );
}

/* CDate -- get date and return result in Interface_String */

void CDate() {
   time_t t;
   struct tm *tm;

   time( &t );
   tm = localtime( &t ); 
   strftime( Interface_String, 255, DateFormat, tm );
}

/* CTime -- get long date and return result in Interface_String */

void CTime() {
   time_t t;
   struct tm *tm;

   time( &t );
   tm = localtime( &t ); 
   strftime( Interface_String, 255, TimeFormat, tm );
}

/* CUNIX -- Execute UNIX Shell Command */

int CUNIX()
{
  return system( Interface_String );
}

/* GETTEMPNAME -- Get Name for a Temporary File */

/*void GetTempName()
{
  strcpy( Interface_String, "/tmp/pegasoftXXXXXX" );
  mktemp( Interface_String );
}*/

/* CGetPID -- get my process ID */

long CGetPID() {
  long longid;

  longid = 0;
  longid = getpid();
  return longid;
}

/* CGetTimeStamp -- return a time stamp (number of seconds since 1970 */
/* no longer used
long CGetTimeStamp() {
  long longtime;
  time_t temptime;

  longtime = 0;
  time( &temptime );
  longtime = temptime;
  return longtime;
}
*/

/* CGetUNIX -- Execute UNIX Shell Command, return result */

int CGetUNIX (const char * temppath) {
  int length = 0;
  int  result;        /* result of system call */
  FILE *outfile;      /* file to read results from */
  
  /* Redirect command output to temppath file */
  do {
    if (length >= sizeof(Interface_String)) {
      printf ("CGETUNIX: command too long.\n");
      Interface_String[0] = 0;
      return -1; } }
  while (Interface_String[length++] != 0);
  Interface_String[length-1] = '>';
  do {
    if (length >= sizeof(Interface_String)) {
      printf ("CGETUNIX: temppath too long.\n");
      Interface_String[0] = 0;
      return -1; } }
  while ((Interface_String[length++] = *temppath++) != 0);
  
  printf ("------------ %s\n", Interface_String);
  /* Execute system call */
  result = system (Interface_String);
  if (result != 0) {
    Interface_String[0] = 0;
    return result; }
  printf ("------------ ok\n");

  /* Return command output in interface string */
  if ((outfile = fopen (temppath, "r")) == NULL) {
    error (0, errno, "CGetUNIX: fopen");
    Interface_String[0] = 0;
    return -1; }
  if (fgets (Interface_String, sizeof(Interface_String), outfile)) {
    error (EXIT_FAILURE, 0, "CGetUNIX: fgets failed.\n"); }
  if (fclose (outfile) != 0) {
    error (EXIT_FAILURE, errno, "CGetUNIX: fclose"); }
  if (unlink (temppath) != 0) {
    error (EXIT_FAILURE, errno, "CGetUNIX: unlink"); }
  
  return 0; }

/* CNICE -- Change Process Priority */

void CNice (int change) {
  if (nice (change) == -1) {
    error (EXIT_FAILURE, errno, "CNice: nice"); } }

/* CNotEmpty -- check for an empty file (>0 if not empty) */

int CNotEmpty()
{
  int f;
/*  int b; */
/*  struct stat buf; */
/*  char buf1; */
  char buf2[255];

  strcpy( buf2, "test -s " );
  if ( strcat( buf2, Interface_String ) <= 0 ) {
     printf("CNotEmpty: bad string: '%s'\n",buf2);
     return 1;
  } else {
     f = system( buf2 );
     if (f == 0)
        return 0;
     else
        return 1; 
  }
/*
  f = open( &Interface_String[0], O_RDONLY );
  if (f == -1) return( 0 );
  b = read( f, &buf1, sizeof(buf) );
  close( f ); 
  return( b );
*/
}

/* LOCKIT -- Lock a file, return 0 if success */

int LockIt()
{
  const int f = creat (Interface_String, O_RDWR);
  if (f == -1)
    return (-1);
  return (close(f));
}

/* UNLOCKIT -- Unlock a file */

void UnlockIt()
{
  unlink( Interface_String );
}

/* CSETPATH */

int CSetPath()
{
  return chdir( Interface_String );
}

/* CSYNC */

void CSync() {
   sync();
   sync();
   sync();
}

long Crealtotalmem() {
  unsigned long amount;
  FILE* fp;
  
  if ((fp=fopen ("/proc/meminfo", "r")) == NULL) {
    error (0, errno, "Crealtotalmem: fopen");
    return 0; }
  /* skip headings */
  if (fgets (s, 80, fp) == NULL) {
    error (EXIT_FAILURE, 0, "Crealtotalmem: fgets failed.\n"); }
  if (fscanf (fp, "%80s %lu", s, &amount ) == EOF) {
    error (EXIT_FAILURE, 0, "Crealtotalmem: fscanf failed.\n"); }
  if (fclose (fp) != 0) {
    error (EXIT_FAILURE, errno, "Crealtotalmem: fclose"); }
  return (long)amount; }

long Crealfreemem() {
  unsigned long amount;
  FILE* fp;
  
  if ((fp=fopen ("/proc/meminfo", "r")) == NULL) {
    error (0, errno, "Crealfreemem: fopen");
    return 0; }
  /* skip headings */
  if (fgets (s, 80, fp) == NULL) {
    error (EXIT_FAILURE, 0, "Crealfreemem: fgets failed.\n"); }
  if (fscanf (fp, "%80s %lu %lu %lu", s, &amount, &amount, &amount) == EOF) {
    error (EXIT_FAILURE, 0, "Crealfreemem: fscanf failed.\n"); }
  if (fclose (fp) != 0) {
    error (EXIT_FAILURE, errno, "Crealfreemem: fclose"); }
  return (long)amount; }

long Ctotalmem() {
  unsigned long amount;
  unsigned long swapamount;
  unsigned long t; /* discard stuff we don't want*/
  FILE* fp;

  if ((fp=fopen ("/proc/meminfo", "r")) == NULL) {
    error (0, errno, "Crealfreemem: fopen");
    return 0; }
  /* skip headings */
  if (fgets (s, 80, fp) == NULL) {
    error (EXIT_FAILURE, 0, "Crealfreemem: fgets failed.\n"); }
  if (fscanf (fp, "%80s %lu. %lu %lu %lu %lu %lu", s, &amount, &t, &t, &t, &t, &t) == EOF
      || fscanf (fp, "%80s %lu", s, &swapamount) == EOF) {
    error (EXIT_FAILURE, 0, "Ctotalmem: fscanf failed.\n"); }
  if (fclose (fp) != 0) {
    error (EXIT_FAILURE, errno, "Crealfreemem: fclose"); }
  return (long)(amount+swapamount); }

long Cfreemem() {
  unsigned long amount = 0;
  unsigned long swapamount;
  unsigned long t; /* discard stuff we don't want*/
  FILE* fp;

  if ((fp=fopen ("/proc/meminfo", "r")) == NULL) {
    error (0, errno, "Crealfreemem: fopen");
    return 0; }
  /* skip headings */
  if (fgets (s, 80, fp) == NULL) {
    error (EXIT_FAILURE, 0, "Crealfreemem: fgets failed.\n"); }
  if (fscanf( fp, "%80s %lu %lu %lu %lu %lu %lu", s, &t, &t, &amount, &t, &t, &t) == EOF
      || fscanf (fp, "%80s %lu %lu %lu", s, &t, &t, &swapamount) == EOF) {
    error (EXIT_FAILURE, 0, "Ctotalmem: fscanf failed.\n"); }
  if (fclose (fp) != 0) {
    error (EXIT_FAILURE, errno, "Crealfreemem: fclose"); }
  return (long)(amount+swapamount); }

int Crnd( int limit ) {
/* uniformly distributed random numbers */
  return ( rand() % limit )+1;
}

int Cnormalrnd( int limit ) {
/* normally distributed random numbers */
  long sum; /* the sum of the random numbers */
  int  i;   /* for for loop */

  for (sum=0, i=1; i<=8; i++)
      sum += Crnd( limit );
  return ( sum / 8 );
}

int COdds( int percent ) {
    return ( Crnd(100) >= percent );
}

void Csetrndseed( int seed ) {
     srand( seed );
}

/* Generic Appending to a Text File */

void CAppend( char * Filename ) {
/* add a line to a file */
   FILE *fp;
   if (( fp=fopen( Filename, "a") ) != NULL) {
      fprintf(fp, "%s\n", Interface_String );
      fclose( fp );
   }
}

/* Session Logging */

void CClearSessionLog() {
/* clean session log */
   FILE *fp;
   if ((fp=fopen(SessionLogName,"w"))!=NULL) fclose(fp);
}

void CAddSessionLog() {
/* add a message to the session log */
   CAppend( SessionLogName );
}

int CUnlink( char * Filename ) {
/* delete a file */
    if ( unlink( Filename ) != 0 ) {
       return errno;
    } else {
       return 0;
    }
}

void CUSleep( unsigned long usec ) {
/* delay for usec microseconds */
   usleep( usec ); 
}

float CSin( float angle ) {
  return (float) sin( ( (double) angle * 0.017453292 ) );
}

float CCos( float angle ) {
  return (float) cos( ( (double) angle * 0.017453292 ) );
}

int CIsDirectory( char * path ) {
  struct stat statinfo;
  int result;

  if ( stat( path, &statinfo ) ) {
     result = 0;
  } else {
     if (statinfo.st_mode & S_IFDIR) {
        result = 1;
     } else {
        result = 0;
     }
  }
  return result;
}

int CRunIt( char * path, char * outfile,
    char * param1, char * param2, char * param3 ) {
    pid_t child, result;
    int fd0, fd1, fd2;
    int status;
    int i;

  if ( !(child = fork()) ) {
     /* Redirect stdin, out, err */
     for (i=0; i< FOPEN_MAX; ++i )
         close( i );
     fd0 = open( "/dev/null", O_RDONLY ); 
     if (fd0 < 0 ) exit( 110 );
     fd1 = open( outfile, O_WRONLY | O_CREAT | O_TRUNC,
		 S_IRUSR | S_IRGRP | S_IROTH | S_IWUSR | S_IWGRP | S_IWOTH );
     if (fd1 < 0 ) exit( 111 );
     fd2 = dup( 1 );
     if (param1[0]=='\0') {
         execlp( path, path, NULL );
     } else if (param2[0]=='\0') {
         execlp( path, path, param1, NULL );
     } else if (param3[0]=='\0') {
         execlp( path, path, param1, param2, NULL );
     } else {
         execlp( path, path, param1, param2, param3, NULL );
     }
     /* if we got here, file probably wasn't found */
     exit( errno );
  }
  result = waitpid( child, &status, 0 );
  /* wait( &status ); */
  /* if ( WIFEXITED( status ) != 0 ) */
  /*   status = WEXITSTATUS( status ); */
  status = 112;
  if ( result >= 0 ) {
       status = WIFEXITED( status );
  }
  return status;
}

int CRunItForStdErr( char * path, char * outfile,
    char * param1, char * param2, char * param3 ) {
/* dicard standard out, standard error to outfile */
/* written for uuchk */
    pid_t child, result;
    int fd0, fd1, fd2;
    int status;
    int i;

  if ( !(child = fork()) ) {
     /* Redirect stdin, out, err */
     for (i=0; i< FOPEN_MAX; ++i ) close( i );
     fd0 = open( "/dev/null", O_RDONLY ); 
     if (fd0 < 0 ) exit( 110 );
     fd1 = open( "/dev/null", O_WRONLY );
     if (fd1 < 0 ) exit( 111 );
     fd2 = open( outfile, O_WRONLY | O_CREAT | O_TRUNC ,
                 S_IRUSR | S_IRGRP | S_IROTH | S_IWUSR | S_IWGRP | S_IWOTH );
     if (fd2 < 0 ) exit( 111 );
     if (param1[0]=='\0') {
         execlp( path, path, NULL );
     } else if (param2[0]=='\0') {
         execlp( path, path, param1, NULL );
     } else if (param3[0]=='\0') {
         execlp( path, path, param1, param2, NULL );
     } else {
         execlp( path, path, param1, param2, param3, NULL );
     }
     /* if we got here, file probably wasn't found */
     exit( errno );
  }
  status = 112;
  result = waitpid( child, &status, 0 );
  if ( result >= 0 )
     status = WIFEXITED( status );
  return status;
}

char * C_readdir( DIR* dp ) {
  struct dirent *de;
  de = readdir( dp );
  if ( de == NULL )
     return NULL;
  else
     return de->d_name;
}

