/*
 *  @(#)DefaultTestInfo.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Part of the GroboUtils package at:
 *  http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */
package net.sourceforge.groboutils.autodoc.v1.testserver;


import junit.framework.Test;
import junit.framework.TestSuite;
import junit.framework.TestCase;



/**
 * An implementation of TestInfo which is specific to JUnit.
 *
 * @author     Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @since      March 17, 2002
 * @version    $Date: 2003/02/10 22:52:13 $
 */
public class DefaultTestInfo implements TestInfo
{
    private String suite;
    private String method;
    
    
    /**
     * Only allowed to be implemented by subclasses.
     */
    protected DefaultTestInfo()
    {
        // do nothing
    }
    
    
    /**
     * 
     */
    public DefaultTestInfo( String suite, String method )
    {
        this.suite = suite;
        this.method = method;
    }
    
    
    /**
     * 
     */
    public String getSuite()
    {
        return this.suite;
    }
    
    
    /**
     * 
     */
    public String getMethod()
    {
        return this.method;
    }
    
    
    /**
     * This method does not care about the specific sub-type, jsut as long
     * as the suite and method are identical.
     */
    public boolean equals( Object obj )
    {
        if (obj == null)
        {
            return false;
        }
        if (this == obj)
        {
            return true;
        }
        if (obj instanceof TestInfo)
        {
            TestInfo ti = (TestInfo)obj;
            if (this.getSuite() == null)
            {
                if (ti.getSuite() != null)
                {
                    return false;
                }
            }
            else
            if (!this.getSuite().equals( ti.getSuite() ))
            {
                return false;
            }
            
            
            if (this.getMethod() == null)
            {
                if (ti.getMethod() != null)
                {
                    return false;
                }
            }
            else
            if (!this.getMethod().equals( ti.getMethod() ))
            {
                return false;
            }
            
            // else
            return true;
        }
        // else
        return false;
    }
    
    public int hashCode()
    {
        int hc = 0;
        String s = getSuite();
        String m = getMethod();
        if (s != null)
        {
            hc += s.hashCode();
        }
        if (m != null)
        {
            hc += m.hashCode();
        }
        return hc;
    }
    
    
    
    
    protected void setSuite( String name )
    {
        this.suite = name;
    }
    
    
    protected void setMethod( String name )
    {
        this.method = name;
    }
}

