/*
 * Created on Apr 17, 2005
 */
package org.flexdock.dockbar.activation;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.Timer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.flexdock.dockbar.DockbarManager;
import org.flexdock.dockbar.ViewPane;



/**
 * @author Christopher Butler
 */
public class Animation implements Runnable, ActionListener {
    private static Log log = LogFactory.getLog(Animation.class);

    private static int ANIMATION_INTERVAL = 20;
    private static int TOTAL_FRAME_COUNT = 5;

    private DockbarManager dockManager;
    private Timer timer;
    private float frameDelta;
    private int frameCount;
    private boolean hiding;
    private Runnable next;
    private Object lock;

    public Animation(DockbarManager mgr, boolean hide) {
        dockManager = mgr;
        timer = new Timer(ANIMATION_INTERVAL, this);
        frameDelta = (100f/(float)getTotalFrameCount())/100f;
        hiding = hide;
        lock = new Object();
    }

    public void run() {
        timer.start();
        sleep();
    }

    public void actionPerformed(ActionEvent e) {
        resetViewpaneSize();
        dockManager.revalidate();
        if(frameCount==getTotalFrameCount()-1) {
            timer.stop();
            wakeUp();
        } else
            frameCount++;
    }

    private void resetViewpaneSize() {
        ViewPane viewPane = dockManager.getViewPane();
        int prefSize = dockManager.getPreferredViewpaneSize();

        if(frameCount==0)
            prefSize = getStartSize(prefSize);
        else if(frameCount==getTotalFrameCount()-1)
            prefSize = getEndSize(prefSize);
        else {
            int newSize = (int)((float)prefSize * (frameCount*frameDelta));
            prefSize = hiding? prefSize-newSize: newSize;
        }

        viewPane.setPrefSize(prefSize);
    }

    private int getStartSize(int prefSize) {
        if(hiding)
            return prefSize;
        return 0;
    }

    private int getEndSize(int prefSize) {
        if(hiding)
            return 0;
        return prefSize;
    }

    private int getTotalFrameCount() {
        return TOTAL_FRAME_COUNT;
    }

    public Runnable getNext() {
        return next;
    }
    public void setNext(Runnable next) {
        this.next = next;
    }

    private void sleep() {
        synchronized(lock) {
            try {
                lock.wait();
            } catch(InterruptedException e) {
                log.debug(e.getMessage(), e);
            }
        }
    }

    private void wakeUp() {
        synchronized(lock) {
            lock.notifyAll();
        }
    }
}