/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.xmlrpc;

import java.util.Date;
import java.util.Vector;

/**
 * This class uses tests the Invoker for proper behavior.
 *
 * @author Elias Ross
 * @version 1.0
 * @see Invoker
 */
public class InvokerTest
	extends junit.framework.TestCase
{

	public InvokerTest(String name) {
		super(name);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(InvokerTest.class);
	}

	public String badOne(String a, String b, String c)
		throws Exception
	{
		throw new Exception("I hate this; " + a);
	}
	
	public String printThree(String a, String b, String c)
		throws Exception
	{
		assertEquals(a, A);
		assertEquals(b, B);
		assertEquals(c, C);
		return a + b + c;
	}
	
	public Vector printTwo(int i, Date b)
	{
		Vector stuff = new Vector();
		stuff.add(new Integer(i)); stuff.add(b); 
		return stuff;
	}

	public static String A = "Apples";
	public static String B = "Bannanas";
	public static String C = "Cherries";

	public void test() 
		throws XmlRpcException
	{
		Vector fruits = new Vector();
		fruits.add(A); fruits.add(B); fruits.add(C);

		Vector stuff = new Vector();
		stuff.add(new Integer(1)); stuff.add(new Date(0)); 

		Invoker i = new Invoker(this);
		ParamIterator pi;
		pi = i.execute("printThree", new IteratorAdapter(fruits.iterator()));
		assertTrue(pi.hasNext());
		assertEquals(pi.next(), A + B + C);
		pi = i.execute("printTwo", new IteratorAdapter(stuff.iterator()));
		assertTrue(pi.hasNext());
		assertEquals(pi.next(), new Integer(1));
		assertEquals(pi.next(), new Date(0));
		try {
			i.execute("notHere", new IteratorAdapter(stuff.iterator()));
			fail("Should fail calling notHere");
		} catch (XmlRpcException xre) {
			// xre.printStackTrace();
		}
		try {
			i.execute("badOne", new IteratorAdapter(fruits.iterator()));
			fail("Should fail calling badOne");
		} catch (XmlRpcException xre) {
		}
	}

}
