/*--------------------------------------------------------------------------+
$Id: DiffTest.java 26283 2010-02-18 11:18:57Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.algo;

import java.util.Arrays;
import java.util.List;

import junit.framework.TestCase;
import edu.tum.cs.commons.algo.Diff.Delta;
import edu.tum.cs.commons.string.StringUtils;

/**
 * Tests for the {@link Diff} class.
 * 
 * @author hummelb
 * @author $Author: juergens $
 * @version $Rev: 26283 $
 * @levd.rating GREEN Hash: D18DA477E0134350B6A4E7064812633F
 */
public class DiffTest extends TestCase {

	/** Performs basic execution tests. */
	public void testSimple() {
		assertDiff(6, "abcdef123ghijklmnopqrstuvwxyz",
				"abcdefghijklmnop456qrstuvwxyz");
	}

	/** Tests with equal strings. */
	public void testEqual() {
		assertDiff(0, "abcdefabcdefabcdef", "abcdefabcdefabcdef");
	}

	/** Performs tests with empty strings. */
	public void testEmpty() {
		assertDiff(3, "abc", "");
		assertDiff(6, "", "xyzyzy");
		assertDiff(0, "", "");
	}

	/** Asserts that the diff works for the given strings. */
	private void assertDiff(int expectedSize, String wordA, String wordB) {
		List<Character> a = Arrays.asList(StringUtils.splitChars(wordA));
		List<Character> b = Arrays.asList(StringUtils.splitChars(wordB));

		Delta<Character> delta = Diff.computeDelta(a, b);

		assertEquals(expectedSize, delta.getSize());
		assertEquals(b, delta.forwardPatch(a));
		assertEquals(a, delta.backwardPatch(b));
	}
}